/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.cdex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CDexHeader
extends DexHeader {
    private int feature_flags_;
    private int debug_info_offsets_pos_;
    private int debug_info_offsets_table_offset_;
    private int debug_info_base_;
    private int owned_data_begin_;
    private int owned_data_end_;

    public CDexHeader(BinaryReader reader) throws IOException {
        super(reader);
        this.feature_flags_ = reader.readNextInt();
        this.debug_info_offsets_pos_ = reader.readNextInt();
        this.debug_info_offsets_table_offset_ = reader.readNextInt();
        this.debug_info_base_ = reader.readNextInt();
        this.owned_data_begin_ = reader.readNextInt();
        this.owned_data_end_ = reader.readNextInt();
    }

    public int getFeatureFlags() {
        return this.feature_flags_;
    }

    public int getDebugInfoOffsetsPos() {
        return this.debug_info_offsets_pos_;
    }

    public int getDebugInfoOffsetsTableOffset() {
        return this.debug_info_offsets_table_offset_;
    }

    public int getDebugInfoBase() {
        return this.debug_info_base_;
    }

    public int getOwnedDataBegin() {
        return this.owned_data_begin_;
    }

    public int getOwnedDataEnd() {
        return this.owned_data_end_;
    }

    @Override
    public boolean isDataOffsetRelative() {
        return true;
    }

    @Override
    protected void checkMagic() throws IOException {
        if (!"cdex".equals(new String(this.getMagic()))) {
            throw new IOException("not a cdex file.");
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        Structure structure = (Structure)super.toDataType();
        try {
            structure.setName("cdex_header");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        structure.setCategoryPath(new CategoryPath("/cdex"));
        structure.add(DWORD, "feature_flags_", null);
        structure.add(DWORD, "debug_info_offsets_pos_", null);
        structure.add(DWORD, "debug_info_offsets_table_offset_", null);
        structure.add(DWORD, "debug_info_base_", null);
        structure.add(DWORD, "owned_data_begin_", null);
        structure.add(DWORD, "owned_data_end_", null);
        for (DataTypeComponent component : structure.getComponents()) {
            component.setComment(null);
        }
        return structure;
    }
}

