/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeUseropLibrary;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ComposedPcodeUseropLibrary<T>
implements PcodeUseropLibrary<T> {
    private final Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> userops;

    public static <T> Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> composeUserops(Collection<PcodeUseropLibrary<T>> libraries) {
        HashMap<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> userops = new HashMap<String, PcodeUseropLibrary.PcodeUseropDefinition<T>>();
        for (PcodeUseropLibrary<T> lib : libraries) {
            for (PcodeUseropLibrary.PcodeUseropDefinition<T> def : lib.getUserops().values()) {
                if (userops.put(def.getName(), def) == null) continue;
                throw new IllegalArgumentException("Cannot compose libraries with conflicting definitions on " + def.getName());
            }
        }
        return userops;
    }

    public ComposedPcodeUseropLibrary(Collection<PcodeUseropLibrary<T>> libraries) {
        this.userops = ComposedPcodeUseropLibrary.composeUserops(libraries);
    }

    @Override
    public Map<String, PcodeUseropLibrary.PcodeUseropDefinition<T>> getUserops() {
        return this.userops;
    }
}

