/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.dd;

import com.google.gson.JsonElement;
import ghidra.program.model.listing.Data;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.dd.ExtData;
import sarif.managers.DefinedDataSarifMgr;

public class SarifDataWriter
extends AbstractExtWriter {
    private List<Data> definedData = new ArrayList<Data>();

    public SarifDataWriter(List<Data> target, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.definedData = target;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genData(monitor);
        this.root.add("definedData", (JsonElement)this.objects);
    }

    private void genData(TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.definedData.size());
        for (Data d : this.definedData) {
            ExtData isf = new ExtData(d);
            SarifObject sarif = new SarifObject("DefinedData", DefinedDataSarifMgr.KEY, this.getTree((Object)isf), d.getMinAddress(), d.getMaxAddress());
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }
}

