/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import ghidra.app.plugin.core.analysis.rust.demangler.RustDemanglerFormat;
import ghidra.app.util.demangler.DemanglerOptions;

public class RustDemanglerOptions
extends DemanglerOptions {
    private final RustDemanglerFormat format;
    private final boolean isDeprecated;

    public RustDemanglerOptions() {
        this(RustDemanglerFormat.AUTO);
    }

    public RustDemanglerOptions(RustDemanglerFormat format) {
        this(format, !format.isModernFormat());
    }

    public RustDemanglerOptions(RustDemanglerFormat format, boolean isDeprecated) {
        this.format = format;
        this.isDeprecated = isDeprecated;
        if (!format.isAvailable(isDeprecated)) {
            throw new IllegalArgumentException(format.name() + " is not available");
        }
    }

    public RustDemanglerOptions(DemanglerOptions copy) {
        super(copy);
        if (copy instanceof RustDemanglerOptions) {
            RustDemanglerOptions gCopy = (RustDemanglerOptions)copy;
            this.format = gCopy.format;
            this.isDeprecated = gCopy.isDeprecated;
        } else {
            this.format = RustDemanglerFormat.AUTO;
            this.isDeprecated = false;
        }
    }

    public RustDemanglerFormat getDemanglerFormat() {
        return this.format;
    }

    @Override
    public String toString() {
        return "{\n\tdoDisassembly: " + this.doDisassembly() + ",\n\tapplySignature: " + this.applySignature() + ",\n\tdemangleOnlyKnownPatterns: " + this.demangleOnlyKnownPatterns() + ",\n}";
    }
}

