/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffSectionHeader;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

class CoffSectionHeader1
extends CoffSectionHeader {
    CoffSectionHeader1(BinaryReader reader, CoffFileHeader header) throws IOException {
        this._header = header;
        this.readName(reader);
        this.s_paddr = reader.readNextInt();
        this.s_vaddr = reader.readNextInt();
        this.s_size = reader.readNextInt();
        this.s_scnptr = reader.readNextInt();
        this.s_relptr = reader.readNextInt();
        this.s_lnnoptr = reader.readNextInt();
        this.s_nreloc = reader.readNextUnsignedShort();
        this.s_nlnno = reader.readNextUnsignedShort();
        this.s_flags = reader.readNextUnsignedShort();
        this.s_reserved = (short)(reader.readNextByte() & 0xFF);
        this.s_page = (short)(reader.readNextByte() & 0xFF);
    }

    @Override
    public DataType toDataType() throws IOException {
        StructureDataType struct = new StructureDataType(StructConverterUtil.parseName(this.getClass()), 0);
        struct.add((DataType)new ArrayDataType(ASCII, 8, ASCII.getLength()), "s_name", null);
        struct.add(DWORD, "s_paddr", null);
        struct.add(DWORD, "s_vaddr", null);
        struct.add(DWORD, "s_size", null);
        struct.add(DWORD, "s_scnptr", null);
        struct.add(DWORD, "s_relptr", null);
        struct.add(DWORD, "s_lnnoptr", null);
        struct.add(WORD, "s_nreloc", null);
        struct.add(WORD, "s_nlnno", null);
        struct.add(WORD, "s_flags", null);
        struct.add(BYTE, "s_reserved", null);
        struct.add(BYTE, "s_page", null);
        return struct;
    }
}

