/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeMarkupable;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class DataDirectory
implements PeMarkupable {
    protected static final String TITLE = "IMAGE_DATA_DIRECTORY";
    public static final byte IMAGE_SIZEOF_IMAGE_DIRECTORY_ENTRY = 8;
    protected NTHeader ntHeader;
    protected BinaryReader reader;
    protected int virtualAddress;
    protected int size;
    protected boolean hasParsed = false;

    protected void processDataDirectory(NTHeader nt, BinaryReader rdr) throws IOException {
        this.ntHeader = nt;
        this.reader = rdr;
        this.virtualAddress = rdr.readNextInt();
        this.size = rdr.readNextInt();
        if (this.virtualAddress == 0) {
            return;
        }
        if (!nt.checkRVA(this.virtualAddress)) {
            Msg.warn((Object)this, (Object)"Skipping DataDirectory '%s'. RVA outside of image (RVA: 0x%x, Size: 0x%x). Could be a file-only data directory.".formatted(this.getDirectoryName(), this.virtualAddress, this.size));
            return;
        }
        if (this.size < 0 && this.validateSize()) {
            Msg.warn((Object)this, (Object)"Skipping DataDirectory '%s'. Invalid size (Size: 0x%x).".formatted(this.getDirectoryName(), this.size));
            return;
        }
        this.hasParsed = this.parse();
    }

    protected boolean validateSize() {
        return true;
    }

    public abstract String getDirectoryName();

    public abstract boolean parse() throws IOException;

    protected long va(long va, boolean isBinary) {
        if (isBinary) {
            long ptr = this.ntHeader.rvaToPointer(va);
            if (ptr < 0L && this.virtualAddress > 0) {
                return va;
            }
            return ptr;
        }
        long new_va = va + this.ntHeader.getOptionalHeader().getImageBase();
        if (this.ntHeader.getOptionalHeader().is64bit()) {
            return new_va;
        }
        return new_va & 0xFFFFFFFFL;
    }

    protected void createTerminatedString(Program program, Address addr, boolean label, MessageLog log) {
        PeUtils.createData(program, addr, (DataType)new TerminatedStringDataType(), log);
    }

    protected void createDirectoryBookmark(Program program, Address addr) {
        program.getBookmarkManager().setBookmark(addr, "Info", "PE Header", this.getDirectoryName());
    }

    protected void setBookmark(Program prog, Address addr, String comment) {
        prog.getBookmarkManager().setBookmark(addr, "Info", "PE Header", comment);
    }

    protected void setPlateComment(Program prog, Address addr, String comment) {
        prog.getListing().setComment(addr, CommentType.PLATE, comment);
    }

    protected void setEolComment(Program prog, Address addr, String comment) {
        prog.getListing().setComment(addr, CommentType.EOL, comment);
    }

    protected void setPreComment(Program prog, Address addr, String comment) {
        prog.getListing().setComment(addr, CommentType.PRE, comment);
    }

    protected boolean createFragment(Program program, String fragmentName, Address start, Address end) {
        try {
            ProgramModule module = program.getListing().getDefaultRootModule();
            ProgramFragment fragment = this.findFragment(module, fragmentName);
            if (fragment == null) {
                fragment = module.createFragment(fragmentName);
            }
            fragment.move(start, end.subtract(1L));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ProgramFragment findFragment(ProgramModule module, String fragmentName) {
        Group[] groups;
        for (Group group : groups = module.getChildren()) {
            if (!group.getName().equals(fragmentName)) continue;
            return (ProgramFragment)group;
        }
        return null;
    }

    public int getVirtualAddress() {
        return this.virtualAddress;
    }

    public void setVirtualAddress(int addr) {
        this.virtualAddress = addr;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String toString() {
        return "VirtualAddress: 0x" + Integer.toHexString(this.virtualAddress) + " Size: " + this.size + " bytes";
    }

    int rvaToPointer() {
        return this.ntHeader.rvaToPointer(this.virtualAddress);
    }

    boolean isContainedInSection() {
        return this.rvaToPointer() != this.getVirtualAddress();
    }

    public void writeBytes(RandomAccessFile raf, DataConverter dc, PortableExecutable template) throws IOException {
    }

    public boolean hasParsedCorrectly() {
        return this.hasParsed;
    }

    public int getPointer() {
        if (this.virtualAddress == 0) {
            return -1;
        }
        int ptr = this.ntHeader.rvaToPointer(this.getVirtualAddress());
        if (ptr < 0) {
            Msg.error((Object)this, (Object)("Invalid file index for " + Integer.toHexString(this.getVirtualAddress())));
        }
        return ptr;
    }
}

