/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.program.model.listing.Program;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public interface Loader
extends ExtensionPoint,
Comparable<Loader> {
    public static final String COMMAND_LINE_ARG_PREFIX = "-loader";
    public static final String OPTIONS_PROJECT_SAVE_STATE_KEY = "LOADER_OPTIONS";
    public static final boolean loggingDisabled = SystemUtilities.getBooleanProperty((String)"disable.loader.logging", (boolean)false);

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider var1) throws IOException;

    public LoadResults<? extends DomainObject> load(ByteProvider var1, String var2, Project var3, String var4, LoadSpec var5, List<Option> var6, MessageLog var7, Object var8, TaskMonitor var9) throws IOException, CancelledException, VersionException, LoadException;

    public void loadInto(ByteProvider var1, LoadSpec var2, List<Option> var3, MessageLog var4, Program var5, TaskMonitor var6) throws IOException, LoadException, CancelledException;

    public List<Option> getDefaultOptions(ByteProvider var1, LoadSpec var2, DomainObject var3, boolean var4);

    public String validateOptions(ByteProvider var1, LoadSpec var2, List<Option> var3, Program var4);

    public String getName();

    public LoaderTier getTier();

    public int getTierPriority();

    default public String getPreferredFileName(ByteProvider provider) {
        FSRL fsrl = provider.getFSRL();
        String name = fsrl != null ? fsrl.getName() : provider.getName();
        return name.replaceAll("[\\\\:|]+", "/");
    }

    @Deprecated(since="10.4")
    default public boolean supportsLoadIntoProgram() {
        return false;
    }

    default public boolean supportsLoadIntoProgram(Program program) {
        return this.supportsLoadIntoProgram();
    }

    default public boolean loadsIntoNewFolder() {
        return false;
    }

    @Override
    default public int compareTo(Loader o) {
        int compareTiers = this.getTier().compareTo(o.getTier());
        if (compareTiers == 0) {
            int comparePriorities = this.getTierPriority() - o.getTierPriority();
            if (comparePriorities == 0) {
                return this.getName().compareTo(o.getName());
            }
            return comparePriorities;
        }
        return compareTiers;
    }
}

