/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;

public class OpenCloseManager {
    private Map<Address, int[]> map = new HashMap<Address, int[]>();
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public boolean openData(Data data) {
        int[] path;
        if (data.getComponent(0) == null) {
            return false;
        }
        Address addr = data.getMinAddress();
        if (this.isOpen(addr, path = data.getComponentPath())) {
            return false;
        }
        this.open(addr, path);
        this.notifyDataToggled();
        return true;
    }

    public void closeData(Data data) {
        int[] path;
        if (data.getComponent(0) == null) {
            return;
        }
        Address addr = data.getMinAddress();
        if (!this.isOpen(addr, path = data.getComponentPath())) {
            return;
        }
        this.close(addr, path);
        this.notifyDataToggled();
    }

    private void open(Address address, int[] path) {
        int pathSize = path.length;
        int[] levels = this.map.get(address);
        if (levels == null || pathSize >= levels.length) {
            this.exactOpen(address, path);
            return;
        }
        levels[0] = 0;
        for (int i = 0; i < pathSize; ++i) {
            if (levels[i + 1] == path[i]) continue;
            if (levels[i + 1] != -1) {
                this.exactOpen(address, path);
                return;
            }
            levels[i + 1] = path[i];
        }
        this.map.put(address, levels);
    }

    private void exactOpen(Address address, int[] path) {
        int pathSize = path.length;
        int[] newLevels = new int[pathSize + 1];
        newLevels[0] = 0;
        System.arraycopy(path, 0, newLevels, 1, pathSize);
        this.map.put(address, newLevels);
    }

    private void close(Address address, int[] path) {
        int[] levels = this.map.get(address);
        if (levels == null) {
            return;
        }
        int levelSize = levels.length;
        int pathSize = 0;
        if (path != null) {
            pathSize = path.length;
        }
        if (levelSize < pathSize + 1) {
            return;
        }
        for (int i = 0; i < pathSize; ++i) {
            if (levels[i + 1] == -1 || levels[i + 1] == path[i]) continue;
            return;
        }
        levels[pathSize] = -1;
        int actualLength = this.computeActualLength(levels);
        if (actualLength == 0) {
            this.map.remove(address);
            return;
        }
        int[] newLevels = levels;
        if (actualLength < levelSize) {
            newLevels = new int[actualLength];
            System.arraycopy(levels, 0, newLevels, 0, actualLength);
        }
        this.map.put(address, newLevels);
    }

    private int computeActualLength(int[] levels) {
        int size = levels.length;
        for (int i = size - 1; i >= 0; --i) {
            if (levels[i] == -1) continue;
            return i + 1;
        }
        return 0;
    }

    public boolean isOpen(Address address) {
        return this.isOpen(address, null);
    }

    public boolean isOpen(Address address, int[] path) {
        int[] levels = this.map.get(address);
        if (levels == null) {
            return false;
        }
        if (path == null || path.length == 0) {
            return levels.length > 0 && levels[0] != -1;
        }
        int pathSize = path.length;
        int levelSize = levels.length;
        if (pathSize >= levelSize) {
            return false;
        }
        for (int i = 0; i < pathSize; ++i) {
            if (levels[i + 1] == -1) {
                return false;
            }
            if (levels[i + 1] == path[i]) continue;
            return false;
        }
        return true;
    }

    public int getOpenIndex(Address address, int[] path) {
        int[] levels = this.map.get(address);
        if (levels == null || levels.length == 0) {
            return -1;
        }
        int levelsSize = levels.length;
        int pathSize = 0;
        if (path != null) {
            pathSize = path.length;
        }
        if (pathSize + 2 <= levelsSize) {
            return levels[pathSize + 1];
        }
        return -1;
    }

    public boolean isOpen(Data data) {
        return this.isOpen(data.getMinAddress(), data.getComponentPath());
    }

    public void toggleOpen(Data data) {
        this.toggleTopLevelData(data);
        this.notifyDataToggled();
    }

    private void toggleTopLevelData(Data data) {
        int[] path;
        if (data.getComponent(0) == null) {
            return;
        }
        Address addr = data.getMinAddress();
        if (this.isOpen(addr, path = data.getComponentPath())) {
            this.close(addr, path);
        } else {
            this.open(addr, path);
        }
    }

    private void notifyDataToggled() {
        for (ChangeListener l : this.listeners) {
            l.stateChanged(null);
        }
    }

    public void openAllData(Program program, AddressSetView addresses, TaskMonitor monitor) {
        this.toggleAllDataInAddresses(true, program, addresses, monitor);
    }

    private void toggleAllDataInAddresses(boolean open, Program program, AddressSetView addresses, TaskMonitor monitor) {
        AddressSet unprocessed = new AddressSet(addresses);
        monitor.initialize(addresses.getNumAddresses());
        Listing listing = program.getListing();
        DataIterator iterator = listing.getDefinedData(addresses, true);
        while (iterator.hasNext()) {
            if (monitor.isCancelled()) {
                return;
            }
            Data data = iterator.next();
            this.toggleDataRecursively(data, open, monitor);
            Address min = data.getMinAddress();
            unprocessed.deleteFromMin(min);
            long progress = addresses.getNumAddresses() - unprocessed.getNumAddresses();
            monitor.setProgress(progress);
        }
        this.notifyDataToggled();
    }

    public void openAllData(Data data, TaskMonitor monitor) {
        this.toggleDataRecursively(data, true, monitor);
        this.notifyDataToggled();
    }

    public void closeAllData(Program program, AddressSetView addresses, TaskMonitor monitor) {
        this.toggleAllDataInAddresses(false, program, addresses, monitor);
    }

    public void closeAllData(Data data, TaskMonitor monitor) {
        this.toggleDataRecursively(data, false, monitor);
        this.notifyDataToggled();
    }

    private void toggleDataRecursively(Data data, boolean openState, TaskMonitor monitor) {
        Data component;
        int componentCount;
        if (data == null && !monitor.isCancelled()) {
            return;
        }
        if (this.isOpen(data) != openState) {
            this.toggleTopLevelData(data);
        }
        if ((componentCount = data.getNumComponents()) > 0 && data.isArray() && (component = data.getComponent(0)).getNumComponents() == 0) {
            return;
        }
        NoProgressMonitor noProgressMonitor = new NoProgressMonitor(this, monitor);
        for (int i = 0; i < componentCount && !monitor.isCancelled(); ++i) {
            monitor.incrementProgress(1L);
            this.toggleDataRecursivlyUsingSubMonitor(data.getComponent(i), openState, (TaskMonitor)noProgressMonitor);
        }
    }

    private void toggleDataRecursivlyUsingSubMonitor(Data data, boolean openState, TaskMonitor monitor) {
        if (data == null && !monitor.isCancelled()) {
            return;
        }
        if (this.isOpen(data) != openState) {
            this.toggleTopLevelData(data);
        }
        int componentCount = data.getNumComponents();
        for (int i = 0; i < componentCount && !monitor.isCancelled(); ++i) {
            this.toggleDataRecursivlyUsingSubMonitor(data.getComponent(i), openState, monitor);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private class NoProgressMonitor
    extends TaskMonitorAdapter {
        private final TaskMonitor realMonitor;

        NoProgressMonitor(OpenCloseManager openCloseManager, TaskMonitor realMonitor) {
            this.realMonitor = realMonitor;
        }

        public void incrementProgress(long incrementAmount) {
        }

        public void cancel() {
            super.cancel();
            this.realMonitor.cancel();
        }
    }
}

