/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class EnclosingMethodAttribute
extends AbstractAttributeInfo {
    private short classIndex;
    private short methodIndex;

    public EnclosingMethodAttribute(BinaryReader reader) throws IOException {
        super(reader);
        this.classIndex = reader.readNextShort();
        this.methodIndex = reader.readNextShort();
    }

    public int getClassIndex() {
        return this.classIndex & 0xFFFF;
    }

    public int getMethodIndex() {
        return this.methodIndex & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = this.getBaseStructure("EnclosingMethod_attribute");
        structure.add(WORD, "class_index", null);
        structure.add(WORD, "method_index", null);
        return structure;
    }
}

