/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public interface Symbol {
    public Address getAddress();

    public String getName();

    public String[] getPath();

    public Program getProgram();

    public String getName(boolean var1);

    public Namespace getParentNamespace();

    public Symbol getParentSymbol();

    public boolean isDescendant(Namespace var1);

    public boolean isValidParent(Namespace var1);

    public SymbolType getSymbolType();

    default public int getReferenceCount() {
        return 0;
    }

    default public boolean hasReferences() {
        return false;
    }

    default public Reference[] getReferences(TaskMonitor monitor) {
        return new Reference[0];
    }

    default public Reference[] getReferences() {
        return this.getReferences(TaskMonitor.DUMMY);
    }

    default public ProgramLocation getProgramLocation() {
        return null;
    }

    public void setName(String var1, SourceType var2) throws DuplicateNameException, InvalidInputException;

    public void setNamespace(Namespace var1) throws DuplicateNameException, InvalidInputException, CircularDependencyException;

    public void setNameAndNamespace(String var1, Namespace var2, SourceType var3) throws DuplicateNameException, InvalidInputException, CircularDependencyException;

    public boolean delete();

    default public boolean isPinned() {
        return false;
    }

    default public void setPinned(boolean pinned) {
        throw new UnsupportedOperationException("Only Code and Function Symbols may be pinned.");
    }

    public boolean isDynamic();

    public boolean isExternal();

    public boolean isPrimary();

    public boolean setPrimary();

    default public boolean isExternalEntryPoint() {
        return false;
    }

    public long getID();

    public Object getObject();

    public boolean isGlobal();

    public void setSource(SourceType var1);

    public SourceType getSource();

    public boolean isDeleted();
}

