# frozen_string_literal: true

class PrepareIndexForHasVulnerabilityResolutionOnVulnerabilityReads < Gitlab::Database::Migration[2.2]
  TABLE_NAME = :vulnerability_reads

  GROUP_LEVEL_INDEX = 'index_vulnerability_reads_common_attrs_for_groups'
  GROUP_LEVEL_COLUMNS = [:resolved_on_default_branch, :state, :report_type, :severity, :traversal_ids,
    :vulnerability_id, :has_vulnerability_resolution]

  PROJECT_LEVEL_INDEX = 'index_vulnerability_reads_common_finder_query'
  PROJECT_LEVEL_COLUMNS = [:project_id, :state, :report_type, :severity, :vulnerability_id, :dismissal_reason,
    :has_vulnerability_resolution]

  milestone '17.5'

  # Index created synchronously in https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167603
  def up
    prepare_async_index TABLE_NAME, GROUP_LEVEL_COLUMNS, name: GROUP_LEVEL_INDEX, where: 'archived = false'
    prepare_async_index TABLE_NAME, PROJECT_LEVEL_COLUMNS, name: PROJECT_LEVEL_INDEX,
      order: { vulnerability_id: :desc }
  end

  def down
    unprepare_async_index TABLE_NAME, GROUP_LEVEL_COLUMNS, name: GROUP_LEVEL_INDEX, where: 'archived = false'
    unprepare_async_index TABLE_NAME, PROJECT_LEVEL_COLUMNS, name: PROJECT_LEVEL_INDEX,
      order: { vulnerability_id: :desc }
  end
end
