---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: GitLabの高度な静的アプリケーションセキュリティテスト
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- Pythonの[実験的機能](../../../policy/development_stages_support.md)としてGitLab 17.1で導入されました。
- GoとJavaのサポートが17.2で追加されました。
- GitLab 17.2で実験的機能からベータに[変更](https://gitlab.com/gitlab-org/gitlab/-/issues/461859)されました。
- JavaScript、TypeScript、C#のサポートが17.3で追加されました。
- GitLab 17.3で[一般提供](https://gitlab.com/gitlab-org/gitlab/-/issues/474094)になりました。
- Java Server Pages（JSP）のサポートがGitLab 17.4で追加されました。

{{< /history >}}

GitLabの高度な静的アプリケーションセキュリティテストは、クロスファンクションおよびクロスファイルのテイント解析を実行して脆弱性を検出するように設計された静的アプリケーションセキュリティテスト（SAST）アナライザーです。

GitLabの高度な静的アプリケーションセキュリティテストは、オプトイン機能です。有効にすると、GitLabの高度な静的アプリケーションセキュリティテストのアナライザーは、GitLabの高度なSASTの定義済みルールセットを使用して、サポートされている言語のすべてのファイルをスキャンします。Semgrepアナライザーはこれらのファイルをスキャンしません。

GitLabの高度な静的アプリケーションセキュリティテストのアナライザーによって識別されたすべての脆弱性が報告されます。これには、以前にSemgrepベースのアナライザーによって報告された脆弱性も含まれます。自動移行では、GitLabの高度な静的アプリケーションセキュリティテストがSemgrepベースのアナライザーと同じ場所で同じタイプの脆弱性を見つけた場合、自動的に重複排除されます。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i> GitLabの高度な静的アプリケーションセキュリティテストの概要とその仕組みについては、[GitLabの高度な静的アプリケーションセキュリティテスト: 脆弱性を自動修正する](https://youtu.be/xDa1MHOcyn8)を参照してください。

製品ツアーについては、[GitLabの高度な静的アプリケーションセキュリティテスト製品ツアー](https://gitlab.navattic.com/advanced-sast)をご覧ください。

## 機能比較

| 機能                                                                      | SAST                                                                                                                                      | 高度な静的アプリケーションセキュリティテスト                                                                                                                               |
|------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------|
| 分析の深さ                                                            | 複雑な脆弱性を検出する機能が制限されています。分析は単一のファイル、および（例外はありますが）単一の関数に限定されます。 | クロスファイル、クロスファンクションのテイント解析を使用して、複雑な脆弱性を検出します。                                                            |
| 精度                                                                     | コンテキストが限られているため、誤検出の結果が生じる可能性が高くなります。                                                                      | クロスファイル、クロスファンクションのテイント解析を使用して、真に攻撃されうる脆弱性に焦点を当てることで、誤検出の結果を減らします。      |
| 修正ガイダンス                                                         | 脆弱性の検出結果は行番号で識別されます。                                                                                     | 詳細な[コードフロービュー](#vulnerability-code-flow)は、脆弱性がプログラム全体にどのように流れるかを示し、迅速な修正を可能にします。 |
| GitLab Duo脆弱性の説明と脆弱性の修正に対応するか | はい。                                                                                                                                      | はい。                                                                                                                                        |
| 言語カバレッジ                                                            | [より広範にカバーします](_index.md#supported-languages-and-frameworks)。                                                                            | [より限定的です](#supported-languages)。                                                                                                       |

## 脆弱性が報告されるタイミング

GitLabの高度な静的アプリケーションセキュリティテストは、テイント解析によるクロスファイル、クロスファンクションスキャンを使用して、ユーザーインプットのプログラムへの流れを追跡します。アナライザーは、ユーザーによってインプットが行われたパスを追跡し、信頼できないデータが安全でない方法を用いてアプリケーションの実行に影響を与える可能性のある、潜在的なポイントを識別します。これにより、SQL挿入やクロスサイトスクリプティング（XSS）といったインジェクションの脆弱性が複数の関数やファイルにまたがって存在していても、確実に検出できます。

ノイズを最小限に抑えるために、GitLabの高度な静的アプリケーションセキュリティテストは、信頼できないユーザーインプットソースを機密シンクに持ち込む検証可能なフローが存在する場合にのみ、テイントベースの脆弱性を報告します。他製品の場合、検証が甘い脆弱性が報告される場合があります。

GitLabの高度な静的アプリケーションセキュリティテストは、HTTPリクエストから取得された値など、信頼境界を越えるインプットに重点を置いて調整されています。信頼できないインプットソースのセットには、コマンドライン引数、環境変数、またはプログラムを操作するユーザーによって通常提供されるその他の入力は含まれません。

GitLabの高度な静的アプリケーションセキュリティテストが検出する脆弱性の種類の詳細については、[GitLabの高度な静的アプリケーションセキュリティテストのCWE カバレッジ](advanced_sast_coverage.md)を参照してください。

## サポートされている言語

GitLabの高度な静的アプリケーションセキュリティテストは、クロスファンクションおよびクロスファイルのテイント解析で次の言語をサポートしています。

- C#
- Go
- Java（Java Server Pages（JSP）を含む）
- JavaScript、TypeScript
- Python
- Ruby

## 設定

クロスファンクションおよびクロスファイルのテイント解析を実行して、アプリケーションの脆弱性を検出するには、GitLabの高度な静的アプリケーションセキュリティテストのアナライザーを有効にします。その後、CI/CD変数を使用してその動作を調整できます。

### 要件

他のGitLabのSASTアナライザーと同様、GitLabの高度な静的アプリケーションセキュリティテストのアナライザーにもRunnerとCI/CDパイプラインが必要です。詳細については、[SASTの要件](_index.md#requirements)を参照してください。

GitLab Self-Managedでは、GitLabの高度な静的アプリケーションセキュリティテストをサポートするGitLabバージョンも使用する必要があります。

- 可能な場合は、GitLab 17.4以降を使用する必要があります。GitLab 17.4には、新しいコードフロービュー、脆弱性の重複排除、および SAST CI/CDテンプレートのその他のアップデートが含まれています。
- [SAST CI/CDテンプレート](_index.md#stable-vs-latest-sast-templates)は、次のリリースでGitLabの高度な静的アプリケーションセキュリティテストを含めるように更新されました。
  - 安定版テンプレートには、GitLab 17.3以降のGitLabの高度な静的アプリケーションセキュリティテストが含まれています。
  - 最新テンプレートには、GitLab 17.2以降のGitLabの高度な静的アプリケーションセキュリティテストが含まれています。単一のプロジェクトで、[最新テンプレートと安定版テンプレートが混在しないようにしてください](../detect/roll_out_security_scanning.md#template-editions)。
- 最小限のGitLabの高度な静的アプリケーションセキュリティテストには、バージョン17.1以降が必要です。

### GitLabの高度な静的アプリケーションセキュリティテストのスキャンを有効にする

GitLabの高度な静的アプリケーションセキュリティテストは標準のGitLab SAST CI/CDテンプレートに含まれています。ただし、デフォルトでは有効になっていません。これを有効にするには、CI/CD変数`GITLAB_ADVANCED_SAST_ENABLED`を`true`に設定します。CI/CD設定の管理方法に応じて、この変数をさまざまな方法で設定できます。

#### CI/CDパイプライン定義を手動で編集する

プロジェクトで GitLab SASTスキャンをすでに有効にしている場合は、新しいCI/CD変数を追加してGitLab SASTを有効にします。

この最小限のYAMLファイルには、[安定版SAST テンプレート](_index.md#stable-vs-latest-sast-templates)が含まれており、GitLabの高度な静的アプリケーションセキュリティテストが有効になっています。

```yaml
include:
  - template: Jobs/SAST.gitlab-ci.yml

variables:
  GITLAB_ADVANCED_SAST_ENABLED: 'true'
```

#### スキャン実行ポリシーで適用する

[スキャン実行ポリシー](../policies/scan_execution_policies.md)でGitLabの高度な静的アプリケーションセキュリティテストを有効にするには、ポリシーのスキャンアクションを更新して、CI/CD変数`GITLAB_ADVANCED_SAST_ENABLED`を`true`に設定します。この変数は次の方法で設定できます。

- [ポリシーエディター](../policies/scan_execution_policies.md#scan-execution-policy-editor)のメニューから選択します。
- スキャンアクションで、[`variables`オブジェクト](../policies/scan_execution_policies.md#scan-action-type)に追加します。

#### パイプラインエディタを使用する

パイプラインエディタを使用してGitLabの高度な静的アプリケーションセキュリティテストを有効にするには、次の手順に従います。

1. プロジェクトで、**ビルド > パイプラインエディタ**を選択します。
1. `.gitlab-ci.yml`ファイルが存在しない場合は、**パイプラインの設定**を選択し、例のコンテンツを削除します。
1. CI/CD設定を次のように更新します。
   - GitLab管理の[SAST CI/CDテンプレート](_index.md#stable-vs-latest-sast-templates)のいずれかが[まだ含まれていない](_index.md#configure-sast-in-your-cicd-yaml)場合は、それを含めます。
       - GitLab 17.3以降では、安定版テンプレート `Jobs/SAST.gitlab-ci.yml`を使用する必要があります。
       - GitLab 17.2では、GitLabの高度な静的アプリケーションセキュリティテストは最新テンプレート`Jobs/SAST.latest.gitlab-ci.yml`でのみ使用できます。単一のプロジェクトで、[最新テンプレートと安定版テンプレートが混在しないようにしてください](../detect/roll_out_security_scanning.md#template-editions)。
       - GitLab 17.1では、GitLabの高度な静的アプリケーションセキュリティテストのジョブの内容をCI/CDパイプライン定義に手動でコピーする必要があります。
   - CI/CD変数`GITLAB_ADVANCED_SAST_ENABLED`を`true`に設定します。

   上記の[最小限のYAMLの例](#edit-the-cicd-pipeline-definition-manually)を参照してください。
1. **検証**タブを選択し、**パイプラインの検証**を選択します。

   **シミュレーションが正常に完了しました**というメッセージは、ファイルが有効であることを裏付けています。
1. **編集**タブを選択します。
1. フィールドに入力します。**ブランチ**フィールドにデフォルトブランチを使用しないでください。
1. **これらの変更で新しいマージリクエストを開始**チェックボックスをオンにし、**変更をコミットする**を選択します。
1. 標準のワークフローに従ってフィールドに入力し、**マージリクエストの作成**を選択します。
1. 標準のワークフローに従ってマージリクエストをレビューおよび編集し、**マージ**を選択します。

パイプラインにGitLabの高度な静的アプリケーションセキュリティテスのジョブが含まれるようになりました。

### GitLabの高度な静的アプリケーションセキュリティテスのスキャンを無効にする

高度な静的アプリケーションセキュリティテストのスキャンはデフォルトでは有効になっていませんが、グループレベルまたは複数のプロジェクトに影響を与える別の方法で有効になっている場合があります。

プロジェクトで高度な静的アプリケーションセキュリティテストのスキャンを明示的に無効にするには、CI/CD変数`GITLAB_ADVANCED_SAST_ENABLED`を`false`に設定します。この変数は、[高度な静的アプリケーションセキュリティテストのスキャンを有効にする](#enable-gitlab-advanced-sast-scanning)のと同じ方法を含め、CI/CD変数を構成できる場所ならどこでも設定できます。

## 脆弱性コードフロー

{{< history >}}

- GitLab 17.3で、[いくつかのフラグ](../../../administration/feature_flags.md)とともに導入されました。デフォルトで有効になっています。
- GitLab17.7のGitLab Self-ManagedおよびGitLab Dedicatedで有効になりました。
- GitLab 17.7で一般提供になりました。すべての機能フラグが削除されました。

{{< /history >}}

特定の種類の脆弱性について、GitLabの高度な静的アプリケーションセキュリティテストはコードフロー情報を提供します。脆弱性のコードフローとは、データのユーザインプット（ソース）から、すべてのアサインメント、操作、サニタイズを通じて、脆弱なコード行（シンク）までのパスのことを指します。この情報は、脆弱性のコンテキスト、影響、およびリスクを理解および評価するのに役立ちます。コードフロー情報は、ソースからシンクへのインプットをトレースすることで検出された脆弱性で利用できます。以下を含みます。

- SQL挿入
- コマンドインジェクション
- クロスサイトスクリプティング（XSS）
- パストラバーサル

コードフロー情報は、**コードフロー**タブに表示され、以下が含まれます。

- ソースからシンクまでのステップ。
- コードスニペットを含む、関連ファイル。

![2つのファイルにまたがるPythonアプリケーションのコードフロー](../vulnerabilities/img/code_flow_view_v17_7.png)

## トラブルシューティング

GitLabの高度な静的アプリケーションセキュリティテストの使用中に問題が発生した場合は、[トラブルシューティングガイド](troubleshooting.md)を参照してください。

### GitLabの高度な静的アプリケーションセキュリティテストのアナライザーのバージョンを特定する

GitLabの高度な静的アプリケーションセキュリティテストのアナライザーのバージョンを特定するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択し、プロジェクトを見つけます。
1. **ビルド > ジョブ**を選択します。
1. `gitlab-advanced-sast`ジョブを探します。
1. ジョブの出力で、文字列`GitLab GitLab Advanced SAST analyzer`を検索します。

その文字列を含む行の末尾にバージョンがあります。次に例を示します。

```plaintext
[INFO] [GitLab Advanced SAST] [2025-01-24T15:51:03Z] ▶ GitLab GitLab Advanced SAST analyzer v1.1.1
```

この例では、バージョンは`1.1.1`です。

## GitLabの高度な静的アプリケーションセキュリティテストをカスタマイズする

他のアナライザーと同様、GitLabの高度な静的アプリケーションセキュリティテストのルールを無効にしたり、そのメタデータを編集したりできます。詳細については、[ルールセットのカスタマイズ](customize_rulesets.md#disable-predefined-gitlab-advanced-sast-rules)を参照してください。

## GitLabの高度な静的アプリケーションセキュリティテストで、LGPLライセンスコンポーネントのソースコードをリクエストする

GitLabの高度な静的アプリケーションセキュリティテストで、LGPLライセンスコンポーネントのソースコードに関する情報をリクエストするには、[GitLabサポートにお問い合わせください](https://about.gitlab.com/support/)。

迅速な対応を確保するために、リクエストにGitLabの高度な静的アプリケーションセキュリティテストのアナライザーのバージョンを含めてください。

この機能はUltimateプランでのみ利用できるため、そのレベルのサポート資格を持つ組織に関連付けられている必要があります。

## フィードバック

専用の[イシュー466322](https://gitlab.com/gitlab-org/gitlab/-/issues/466322)にフィードバックを追加してください。
