---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Use merge request reviews to discuss and improve code before it is merged into your project.
title: マージリクエストの管理
---

GitLabには、プロジェクトとグループのマージリクエストを管理するためのツールが用意されています。

## マージリクエストを削除する

ほとんどの場合、マージリクエストは削除するのではなく、クローズすべきです。マージリクエストを削除すると、元に戻すことができません。

前提要件:

- プロジェクトのオーナーロールが必要です。

マージリクエストを削除するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **コード＞マージリクエスト**を選択し、削除するマージリクエストを見つけます。
1. **編集**を選択します。
1. ページの一番下までスクロールし、**マージリクエストを削除**を選択します。

{{< alert type="note" >}}

マージリクエストを削除しても、すべてのデータが完全に消去されるわけではありません。プロジェクトの履歴を維持し、リカバリープロセスをサポートするために、一部の情報が保持されます。詳細については、[機密情報を処理する](../../../topics/git/undo.md#handle-sensitive-information)を参照してください。

{{< /alert >}}

## プロジェクト内のマージリクエストを一括編集する

マージリクエストの一括編集時に編集可能な属性は次のとおりです。

- 状態（オープン/完了）
- 担当者
- マイルストーン
- ラベル
- サブスクリプション

前提要件:

- デベロッパーロール以上が必要です。

これを行うには、次の手順に従います。

1. プロジェクトで、**コード＞マージリクエスト**に移動します。
1. **一括編集**を選択します。画面の右側に、編集可能なフィールドを含むサイドバーが表示されます。
1. 編集する各マージリクエストの横にあるチェックボックスをオンにします。
1. サイドバーから適切なフィールドと値を選択します。
1. **選択済みアイテムを更新する**を選択します。

## グループ内のマージリクエストを一括編集する

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

グループのマージリクエストの一括編集時に編集可能な属性は次のとおりです。

- マイルストーン
- ラベル

前提要件:

- プロジェクトのデベロッパーロール以上が必要です。

複数のグループマージリクエストを同時に更新するには、次の手順に従います。

1. グループで、**コード＞マージリクエスト**に移動します。
1. **一括編集**を選択します。画面の右側に、編集可能なフィールドを含むサイドバーが表示されます。
1. 編集する各マージリクエストの横にあるチェックボックスをオンにします。
1. サイドバーから適切なフィールドと値を選択します。
1. **選択済みアイテムを更新する**を選択します。

## 関連トピック

- [イシューを一括編集する](../issues/managing_issues.md#bulk-edit-issues-from-a-group)
