---
stage: Tenant Scale
group: Organizations
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Project visibility, search, badges, layout.
title: プロジェクトで作業を整理する
---

プロジェクトを作成してGitLabでコードベースをホストします。プロジェクトは以下の目的にも使用できます。

- イシューの追跡
- 作業の計画
- コードの共同作業
- CI/CDツールを使用して、アプリを継続的にビルド、テスト、デプロイする

プロジェクトは、[公開、内部、またはプライベート](../public_access.md)で利用できます。GitLabでは、作成できるプライベートプロジェクトの数に制限はありません。

| | | |
|--|--|--|
| [**はじめに**](../get_started/get_started_projects.md)<br>機能の連携の概要 | [**プロジェクトを作成する**](_index.md)<br>新しいプロジェクト、プロジェクトテンプレート | [**プロジェクトを管理する**](working_with_projects.md)<br>設定、構成、プロジェクトアクティビティ、プロジェクトの削除  |
| [**プロジェクトの表示レベル**](../public_access.md)<br>公開、プライベート、内部 | [**プロジェクトの設定**](working_with_projects.md)<br>プロジェクトの機能、分析、プロジェクトの権限 | [**説明テンプレート**](description_templates.md)<br>イシューテンプレート、マージリクエストテンプレート、インスタンステンプレート、グループテンプレート |
| [**プロジェクトアクセストークン**](settings/project_access_tokens.md)<br>認証、作成、失効、トークンの有効期限 | [**デプロイキー**](deploy_keys/_index.md)<br>SSH公開鍵、リポジトリアクセス、ボットユーザー、読み取り専用アクセス  | [**デプロイトークン**](deploy_tokens/_index.md)<br>リポジトリのクローン作成、トークンの作成、コンテナレジストリ |
| [**プロジェクトの共有**](members/sharing_projects_groups.md)<br>メンバーロール、招待、グループアクセス | [**予約済みのプロジェクト名とグループ名**](../reserved_names.md)<br>命名規則、制限、予約済みの名前 | [**検索**](../search/_index.md)<br>基本検索、高度な検索、完全一致検索、検索スコープ、コミットSHA検索 |
| [**バッジ**](badges.md)<br>パイプラインの状態、グループ、プロジェクト、カスタムバッジ | [**プロジェクトのトピック**](project_topics.md)<br>プロジェクトの整理、サブスクライブ、表示  | [**コードインテリジェンス**](code_intelligence.md)<br>型シグネチャ、シンボルドキュメント、定義へ移動 |
| [**インポートと移行**](import/_index.md)<br>リポジトリの移行、サードパーティリポジトリ、ユーザーのコントリビュートマッピング | [**システムノート**](system_notes.md)<br>イベント履歴、アクティビティーログ、コメント履歴 | [**プロジェクトを別のネームスペースに転送する**](import/_index.md)<br>ネームスペース間の転送、サブスクリプション間の転送 |
| [**プロジェクトをGoパッケージとして使用する**](use_project_as_go_package.md)<br>Goモジュール、インポートの呼び出し | [**チュートリアル:プロジェクト用の保護ワークフローを構築する**](../../tutorials/protected_workflow/_index.md)<br>セキュリティ、承認ルール、ブランチ保護 | [**トラブルシューティング**](troubleshooting.md)<br>問題解決、一般的な問題、デバッグ、エラー解決 |
