---
stage: GitLab Delivery
group: Operate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Configuration settings.
title: Configure GitLab
---

{{< details >}}

- Tier: Free, Premium, Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

Customize and configure GitLab Self-Managed.

- [Admin area](admin_area.md)
- [Agent server for Kubernetes](clusters/kas.md)
- [Application cache interval](application_settings_cache.md)
- [Cells](cells.md)
- [CI/CD](cicd/_index.md)
- [ClickHouse for analytics](analytics.md)
- [Consul](consul.md)
- [Cron](../topics/cron/_index.md)
- [Custom HTML header tags](custom_html_header_tags.md)
- [Environment variables](environment_variables.md)
- [File hooks](file_hooks.md)
- [Geo](geo/_index.md)
- [Disaster Recovery (Geo)](geo/disaster_recovery/_index.md)
- [Geo sites](geo_sites.md)
- [Git LFS administration](lfs/_index.md)
- [Git protocol v2](git_protocol.md)
- [Health check](monitoring/health_check.md)
- [Host the product documentation](docs_self_host.md)
- [Incoming email](incoming_email.md)
- [Instance limits](instance_limits.md)
- [Instance review](instance_review.md)
- [Invalidate Markdown cache](invalidate_markdown_cache.md)
- [Issue closing pattern](issue_closing_pattern.md)
- [Labels](labels.md)
- [Load balancer](load_balancer.md)
- [Log system](logs/_index.md)
- [Merge request approvals](merge_requests_approvals.md)
- [Merge request diffs storage](merge_request_diffs.md)
- [NFS](nfs.md)
- [Object storage](object_storage.md)
- [Packages](packages/_index.md)
- [Postfix](reply_by_email_postfix_setup.md)
- [PostgreSQL](postgresql/_index.md)
- [Redis](redis/_index.md)
- [Reply by email](reply_by_email.md)
- [Repository storage](repository_storage_paths.md)
- [Server hooks](server_hooks.md)
- [Sidekiq](sidekiq/_index.md)
- [Snippets](snippets/_index.md)
- [S/MIME signing](smime_signing_email.md)
- [Static objects external storage](static_objects_external_storage.md)
- [Terraform limits](settings/terraform_limits.md)
- [Terraform state](terraform_state.md)
- [Time zone](timezone.md)
- [Uploads](uploads.md)
- [Web terminals](integration/terminal.md)
- [What's new](whats-new.md)
- [Wikis](wikis/_index.md)
