---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GCP OAuth client secret'
---

## Description

The response body contains content that matches the pattern of a GCP OAuth client secret was identified. Client secret are used when allowing users to Sign in to your application. Depending on the scopes requested, a malicious actor with access to the secret can impersonate the service to access users information.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke the OAuth client secret:

- Sign in to your GCP account and go to <https://console.cloud.google.com/apis/credentials>
- Under the "Name" column of "OAuth 2.0 Client IDs" table, select the name of the client of the identified key
- Under the "Client secrets" section, you must first add a new secret, select "Add Secret"
- For the identified key, select "Disable"
- When prompted, select "Disable" in the "Disable this secret?" dialog
- You may now select the trash icon to delete the disabled key

For more information, please see [Googles authentication documentation on setting up OAuth 2.0](https://support.google.com/cloud/answer/6158849?hl=en)

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.138 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
