/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIIPropertyListWriter;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import com.dd.plist.XMLPropertyListWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class PropertyListConverter {
    private PropertyListConverter() {
    }

    public static void convertToASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        if (root instanceof NSDictionary) {
            ASCIIPropertyListWriter.write((NSDictionary)root, out);
        } else if (root instanceof NSArray) {
            ASCIIPropertyListWriter.write((NSArray)root, out);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array.");
        }
    }

    public static void convertToASCII(Path in, Path out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        if (root instanceof NSDictionary) {
            ASCIIPropertyListWriter.write((NSDictionary)root, out);
        } else if (root instanceof NSArray) {
            ASCIIPropertyListWriter.write((NSArray)root, out);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array.");
        }
    }

    public static void convertToGnuStepASCII(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        if (root instanceof NSDictionary) {
            ASCIIPropertyListWriter.writeGnuStep((NSDictionary)root, out);
        } else if (root instanceof NSArray) {
            ASCIIPropertyListWriter.writeGnuStep((NSArray)root, out);
        } else {
            throw new PropertyListFormatException("The root of the given input property list is neither a Dictionary nor an Array.");
        }
    }

    public static void convertToBinary(File in, File out) throws IOException, ParserConfigurationException, ParseException, SAXException, PropertyListFormatException {
        NSObject root = PropertyListParser.parse(in);
        BinaryPropertyListWriter.write(root, out, true);
    }

    public static void convertToBinary(Path in, Path out) throws IOException, ParserConfigurationException, ParseException, SAXException, PropertyListFormatException {
        NSObject root = PropertyListParser.parse(in);
        BinaryPropertyListWriter.write(root, out);
    }

    public static void convertToXml(File in, File out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        XMLPropertyListWriter.write(root, out);
    }

    public static void convertToXml(Path in, Path out) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        NSObject root = PropertyListParser.parse(in);
        XMLPropertyListWriter.write(root, out);
    }
}

