/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.internal.MutableReference;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.execution.ExecutionProblemHandler;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.steps.BeforeExecutionContext;
import org.gradle.internal.execution.steps.ExecutionRequestContext;
import org.gradle.internal.execution.steps.IdentityContext;
import org.gradle.internal.execution.steps.Result;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.ValidationFinishedContext;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.gradle.internal.snapshot.impl.UnknownImplementationSnapshot;
import org.gradle.util.internal.TextUtil;

public class ValidateStep<C extends BeforeExecutionContext, R extends Result>
implements Step<C, R> {
    private final ExecutionProblemHandler problemHandler;
    private final Step<? super ValidationFinishedContext, ? extends R> delegate;
    private static final String UNKNOWN_IMPLEMENTATION_NESTED = "UNKNOWN_IMPLEMENTATION_NESTED";
    private static final String UNKNOWN_IMPLEMENTATION = "UNKNOWN_IMPLEMENTATION";

    public ValidateStep(ExecutionProblemHandler problemHandler, Step<? super ValidationFinishedContext, ? extends R> delegate) {
        this.problemHandler = problemHandler;
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        WorkValidationContext validationContext = ((ExecutionRequestContext)context).getValidationContext();
        work.validate(validationContext);
        work.checkOutputDependencies(validationContext);
        ((BeforeExecutionContext)context).getBeforeExecutionState().ifPresent(beforeExecutionState -> ValidateStep.validateImplementations(work, beforeExecutionState, validationContext));
        this.problemHandler.handleReportedProblems(((IdentityContext)context).getIdentity(), work, validationContext);
        return this.delegate.execute(work, new ValidationFinishedContext((BeforeExecutionContext)context, (List<? extends Problem>)validationContext.getProblems()));
    }

    private static void validateImplementations(UnitOfWork work, BeforeExecutionState beforeExecutionState, WorkValidationContext validationContext) {
        final MutableReference workClass = MutableReference.empty();
        work.visitImplementations(new UnitOfWork.ImplementationVisitor(){

            @Override
            public void visitImplementation(Class<?> implementation) {
                workClass.set((Object)GeneratedSubclasses.unpack(implementation));
            }

            @Override
            public void visitAdditionalImplementation(ImplementationSnapshot implementation) {
            }
        });
        Class workType = Objects.requireNonNull((Class)workClass.get());
        TypeValidationContext workValidationContext = validationContext.forType(workType, true);
        ValidateStep.validateImplementation(workValidationContext, beforeExecutionState.getImplementation(), "Implementation of ", work);
        beforeExecutionState.getAdditionalImplementations().forEach(additionalImplementation -> ValidateStep.validateImplementation(workValidationContext, additionalImplementation, "Additional action of ", work));
        beforeExecutionState.getInputProperties().forEach((propertyName, valueSnapshot) -> {
            if (valueSnapshot instanceof ImplementationSnapshot) {
                ImplementationSnapshot implementationSnapshot = (ImplementationSnapshot)valueSnapshot;
                ValidateStep.validateNestedInput(workValidationContext, propertyName, implementationSnapshot);
            }
        });
    }

    private static void validateNestedInput(TypeValidationContext workValidationContext, String propertyName, ImplementationSnapshot implementation) {
        if (implementation instanceof UnknownImplementationSnapshot) {
            UnknownImplementationSnapshot unknownImplSnapshot = (UnknownImplementationSnapshot)implementation;
            workValidationContext.visitPropertyProblem(problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)UNKNOWN_IMPLEMENTATION_NESTED), "Unknown property implementation", GradleCoreProblemGroup.validation().property()).contextualLabel(unknownImplSnapshot.getProblemDescription()).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"implementation_unknown")).details(unknownImplSnapshot.getReasonDescription()).solution(unknownImplSnapshot.getSolutionDescription()).severity(Severity.ERROR));
        }
    }

    private static void validateImplementation(TypeValidationContext workValidationContext, ImplementationSnapshot implementation, String descriptionPrefix, UnitOfWork work) {
        if (implementation instanceof UnknownImplementationSnapshot) {
            UnknownImplementationSnapshot unknownImplSnapshot = (UnknownImplementationSnapshot)implementation;
            workValidationContext.visitPropertyProblem(problem -> problem.id(TextUtil.screamingSnakeToKebabCase((String)UNKNOWN_IMPLEMENTATION), "Unknown property implementation", GradleCoreProblemGroup.validation().property()).contextualLabel(descriptionPrefix + work + " " + unknownImplSnapshot.getProblemDescription()).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"implementation_unknown")).details(unknownImplSnapshot.getReasonDescription()).solution(unknownImplSnapshot.getSolutionDescription()).severity(Severity.ERROR));
        }
    }

    @ServiceScope(value={Scope.Global.class})
    public static interface ValidationWarningRecorder {
        public void recordValidationWarnings(UnitOfWork.Identity var1, UnitOfWork var2, Collection<? extends InternalProblem> var3);
    }
}

