/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.jspecify.annotations.Nullable;

public class Description {
    public static final Description JAVA = new Description(Language.JAVA, BuildInitTestFramework.JUNIT_JUPITER, Arrays.asList(BuildInitTestFramework.JUNIT, BuildInitTestFramework.JUNIT_JUPITER, BuildInitTestFramework.TESTNG, BuildInitTestFramework.SPOCK), null, null, null);
    public static final Description GROOVY = new Description(Language.GROOVY, BuildInitTestFramework.SPOCK, Collections.singletonList(BuildInitTestFramework.SPOCK), "groovy", null, null);
    public static final Description SCALA = new Description(Language.SCALA, BuildInitTestFramework.SCALATEST, Collections.singletonList(BuildInitTestFramework.SCALATEST), "scala", null, null);
    public static final Description KOTLIN = new Description(Language.KOTLIN, BuildInitTestFramework.KOTLINTEST, Arrays.asList(BuildInitTestFramework.KOTLINTEST, BuildInitTestFramework.JUNIT_JUPITER), "org.jetbrains.kotlin.jvm", "kotlin", "kotlin-jvm");
    private final Language language;
    private final BuildInitTestFramework defaultTestFramework;
    private final Set<BuildInitTestFramework> supportedTestFrameworks;
    private final @Nullable String pluginName;
    private final @Nullable String pluginVersionProperty;
    private final @Nullable String explicitPluginAlias;

    private Description(Language language, BuildInitTestFramework defaultTestFramework, List<BuildInitTestFramework> supportedTestFrameworks, @Nullable String pluginName, @Nullable String pluginVersionProperty, @Nullable String explicitPluginAlias) {
        this.language = language;
        this.defaultTestFramework = defaultTestFramework;
        this.supportedTestFrameworks = new TreeSet<BuildInitTestFramework>(supportedTestFrameworks);
        this.pluginName = pluginName;
        this.pluginVersionProperty = pluginVersionProperty;
        this.explicitPluginAlias = explicitPluginAlias;
    }

    public Language getLanguage() {
        return this.language;
    }

    public BuildInitTestFramework getDefaultTestFramework() {
        return this.defaultTestFramework;
    }

    public Set<BuildInitTestFramework> getSupportedTestFrameworks() {
        return this.supportedTestFrameworks;
    }

    public Optional<String> getPluginName() {
        return Optional.ofNullable(this.pluginName);
    }

    public @Nullable String getPluginVersionProperty() {
        return this.pluginVersionProperty;
    }

    public @Nullable String getExplicitPluginAlias() {
        return this.explicitPluginAlias;
    }
}

