/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.PreResolvedResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.internal.component.local.model.TransformedComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueFactory;
import org.jspecify.annotations.Nullable;

public class DefaultResolvableArtifact
implements ResolvableArtifact {
    private final ModuleVersionIdentifier owner;
    private final IvyArtifactName artifact;
    private final ComponentArtifactIdentifier artifactId;
    private final TaskDependencyContainer buildDependencies;
    private final CalculatedValue<File> fileSource;
    private final WorkNodeAction resolvedArtifactDependency;
    private final CalculatedValueFactory calculatedValueFactory;
    private final ResolvedArtifact publicView;

    public DefaultResolvableArtifact(@Nullable ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, TaskDependencyContainer builtBy, CalculatedValue<File> fileSource, CalculatedValueFactory calculatedValueFactory) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = builtBy;
        this.fileSource = fileSource;
        this.resolvedArtifactDependency = this.isProjectArtifact() ? new ResolveAction(this) : null;
        this.calculatedValueFactory = calculatedValueFactory;
        this.publicView = new DefaultResolvedArtifact(artifactId, fileSource, owner, artifact);
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.buildDependencies);
        if (this.resolvedArtifactDependency != null) {
            context.add((Object)this.resolvedArtifactDependency);
        }
    }

    @Override
    public IvyArtifactName getArtifactName() {
        return this.artifact;
    }

    @Override
    public ComponentArtifactIdentifier getId() {
        return this.artifactId;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultResolvableArtifact other = (DefaultResolvableArtifact)obj;
        return other.artifactId.equals(this.artifactId);
    }

    public int hashCode() {
        return this.artifactId.hashCode();
    }

    @Override
    public ResolvedArtifact toPublicView() {
        return this.publicView;
    }

    @Override
    public ResolvableArtifact transformedTo(File file) {
        DefaultIvyArtifactName artifactName = DefaultIvyArtifactName.forFile(file, this.artifact.getClassifier());
        String originalFileName = this.artifactId instanceof TransformedComponentFileArtifactIdentifier ? ((TransformedComponentFileArtifactIdentifier)this.artifactId).getOriginalFileName() : ((File)this.fileSource.get()).getName();
        TransformedComponentFileArtifactIdentifier newId = new TransformedComponentFileArtifactIdentifier(this.artifactId.getComponentIdentifier(), file.getName(), originalFileName);
        return new PreResolvedResolvableArtifact(this.owner, artifactName, (ComponentArtifactIdentifier)newId, file, TaskDependencyContainer.EMPTY, this.calculatedValueFactory);
    }

    @Override
    public boolean isResolveSynchronously() {
        if (this.isProjectArtifact()) {
            return true;
        }
        return this.fileSource.isFinalized();
    }

    private boolean isProjectArtifact() {
        return this.artifactId.getComponentIdentifier() instanceof ProjectComponentIdentifier;
    }

    @Override
    public CalculatedValue<File> getFileSource() {
        return this.fileSource;
    }

    @Override
    public File getFile() {
        this.fileSource.finalizeIfNotAlready();
        return (File)this.fileSource.get();
    }

    public static class ResolveAction
    implements WorkNodeAction {
        private final DefaultResolvableArtifact artifact;

        public ResolveAction(DefaultResolvableArtifact artifact) {
            this.artifact = artifact;
        }

        public String toString() {
            return "resolve " + this.artifact.artifactId;
        }

        public DefaultResolvableArtifact getArtifact() {
            return this.artifact;
        }

        public boolean usesMutableProjectState() {
            return true;
        }

        public @Nullable Project getOwningProject() {
            if (this.artifact.fileSource.getResourceToLock() instanceof ProjectState) {
                return ((ProjectState)this.artifact.fileSource.getResourceToLock()).getMutableModel();
            }
            return null;
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add((Object)this.artifact.buildDependencies);
        }

        public void run(NodeExecutionContext context) {
            this.artifact.fileSource.finalizeIfNotAlready();
        }
    }
}

