/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.util.HashMap;
import java.util.Map;
import org.apache.ivy.util.StringUtils;

public class PatternHelper {
    public static final String TYPE_KEY = "type";
    public static final String EXT_KEY = "ext";
    public static final String ARTIFACT_KEY = "artifact";
    public static final String REVISION_KEY = "revision";
    public static final String MODULE_KEY = "module";
    public static final String ORGANISATION_KEY = "organisation";
    public static final String ORGANISATION_KEY2 = "organization";
    public static final String ORGANISATION_PATH_KEY = "orgPath";

    public static String substituteTokens(String pattern, Map<String, String> attributes) {
        HashMap<String, String> tokens = new HashMap<String, String>(attributes);
        if (tokens.containsKey(ORGANISATION_KEY) && !tokens.containsKey(ORGANISATION_KEY2)) {
            tokens.put(ORGANISATION_KEY2, (String)tokens.get(ORGANISATION_KEY));
        }
        if (tokens.containsKey(ORGANISATION_KEY) && !tokens.containsKey(ORGANISATION_PATH_KEY)) {
            String org = (String)tokens.get(ORGANISATION_KEY);
            tokens.put(ORGANISATION_PATH_KEY, org == null ? "" : org.replace('.', '/'));
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder optionalPart = null;
        StringBuilder tokenBuffer = null;
        boolean insideOptionalPart = false;
        boolean insideToken = false;
        boolean tokenSeen = false;
        boolean tokenHadValue = false;
        block6: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '(': {
                    if (insideOptionalPart) {
                        throw new IllegalArgumentException("invalid start of optional part at position " + i + " in pattern " + pattern);
                    }
                    optionalPart = new StringBuilder();
                    insideOptionalPart = true;
                    tokenSeen = false;
                    tokenHadValue = false;
                    continue block6;
                }
                case ')': {
                    if (!insideOptionalPart || insideToken) {
                        throw new IllegalArgumentException("invalid end of optional part at position " + i + " in pattern " + pattern);
                    }
                    if (tokenHadValue) {
                        buffer.append(optionalPart.toString());
                    } else if (!tokenSeen) {
                        buffer.append('(').append(optionalPart.toString()).append(')');
                    }
                    insideOptionalPart = false;
                    continue block6;
                }
                case '[': {
                    if (insideToken) {
                        throw new IllegalArgumentException("invalid start of token at position " + i + " in pattern " + pattern);
                    }
                    tokenBuffer = new StringBuilder();
                    insideToken = true;
                    continue block6;
                }
                case ']': {
                    String value;
                    if (!insideToken) {
                        throw new IllegalArgumentException("invalid end of token at position " + i + " in pattern " + pattern);
                    }
                    String token = tokenBuffer.toString();
                    Object tokenValue = tokens.get(token);
                    String string = value = tokenValue == null ? null : tokenValue.toString();
                    if (insideOptionalPart) {
                        tokenHadValue = !StringUtils.isNullOrEmpty((String)value);
                        optionalPart.append(value);
                    } else {
                        if (value == null) {
                            value = "[" + token + "]";
                        }
                        buffer.append(value);
                    }
                    insideToken = false;
                    tokenSeen = true;
                    continue block6;
                }
                default: {
                    if (insideToken) {
                        tokenBuffer.append(ch);
                        continue block6;
                    }
                    if (insideOptionalPart) {
                        optionalPart.append(ch);
                        continue block6;
                    }
                    buffer.append(ch);
                }
            }
        }
        if (insideToken) {
            throw new IllegalArgumentException("last token hasn't been closed in pattern " + pattern);
        }
        if (insideOptionalPart) {
            throw new IllegalArgumentException("optional part hasn't been closed in pattern " + pattern);
        }
        return buffer.toString();
    }

    public static String getTokenString(String token) {
        return "[" + token + "]";
    }
}

