/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.resolution.failure.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.catalog.problems.ResolutionFailureProblemId;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.interfaces.GraphNodesValidationFailure;
import org.gradle.internal.component.resolution.failure.type.AbstractResolutionFailure;

public final class IncompatibleMultipleNodesValidationFailure
extends AbstractResolutionFailure
implements GraphNodesValidationFailure {
    private final ComponentGraphResolveMetadata selectedComponent;
    private final Set<VariantGraphResolveMetadata> incompatibleNodes;
    private final ImmutableList<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates;

    public IncompatibleMultipleNodesValidationFailure(ComponentGraphResolveMetadata selectedComponent, Set<VariantGraphResolveMetadata> incompatibleNodes, List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates) {
        super(ResolutionFailureProblemId.INCOMPATIBLE_MULTIPLE_NODES);
        this.selectedComponent = selectedComponent;
        this.incompatibleNodes = ImmutableSet.copyOf(incompatibleNodes);
        this.assessedCandidates = ImmutableList.copyOf(assessedCandidates);
    }

    @Override
    public String describeRequestTarget() {
        return this.selectedComponent.getModuleVersionId().toString();
    }

    @Override
    public ComponentGraphResolveMetadata getFailingComponent() {
        return this.selectedComponent;
    }

    @Override
    public Set<VariantGraphResolveMetadata> getFailingNodes() {
        return this.incompatibleNodes;
    }

    public ImmutableList<ResolutionCandidateAssessor.AssessedCandidate> getAssessedCandidates() {
        return this.assessedCandidates;
    }
}

