/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.cached;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.gradle.internal.resource.cached.CachedExternalResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;

public class DefaultCachedExternalResource
implements CachedExternalResource,
Serializable {
    private final File cachedFile;
    private final long cachedAt;
    private final ExternalResourceMetaData externalResourceMetaData;

    public DefaultCachedExternalResource(File cachedFile, long cachedAt, ExternalResourceMetaData externalResourceMetaData) {
        this.cachedFile = cachedFile;
        this.cachedAt = cachedAt;
        this.externalResourceMetaData = externalResourceMetaData;
    }

    public DefaultCachedExternalResource(long cachedAt) {
        this.cachedAt = cachedAt;
        this.cachedFile = null;
        this.externalResourceMetaData = null;
    }

    @Override
    public boolean isMissing() {
        return this.cachedFile == null;
    }

    @Override
    public File getCachedFile() {
        return this.cachedFile;
    }

    @Override
    public long getCachedAt() {
        return this.cachedAt;
    }

    @Override
    public ExternalResourceMetaData getExternalResourceMetaData() {
        return this.externalResourceMetaData;
    }

    @Override
    public Date getExternalLastModified() {
        return this.externalResourceMetaData != null ? this.externalResourceMetaData.getLastModified() : null;
    }

    @Override
    public long getContentLength() {
        return this.isMissing() ? -1L : this.cachedFile.length();
    }
}

