/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildconfiguration.tasks;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildconfiguration.tasks.DaemonJvmPropertiesUtils;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.platform.BuildPlatform;
import org.gradle.util.internal.GFileUtils;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Project.class})
public class DaemonJvmPropertiesModifier {
    public void updateJvmCriteria(File propertiesFile, JavaLanguageVersion toolchainVersion, @Nullable String toolchainVendor, boolean nativeImageCapable, Map<BuildPlatform, URI> downloadUrlsByPlatform) {
        DaemonJvmPropertiesModifier.validateToolchainVersion(toolchainVersion);
        Properties daemonJvmProperties = new Properties();
        daemonJvmProperties.put("toolchainVersion", toolchainVersion.toString());
        if (toolchainVendor != null) {
            daemonJvmProperties.put("toolchainVendor", toolchainVendor);
        }
        if (nativeImageCapable) {
            daemonJvmProperties.put("toolchainNativeImageCapable", "true");
        }
        downloadUrlsByPlatform.forEach((buildPlatform, uri) -> {
            String toolchainUrlProperty = DaemonJvmPropertiesUtils.getToolchainUrlPropertyForPlatform(buildPlatform);
            daemonJvmProperties.put(toolchainUrlProperty, uri.toString());
        });
        GFileUtils.parentMkdirs((File)propertiesFile);
        try {
            PropertiesUtils.store((Properties)daemonJvmProperties, (File)propertiesFile, (String)"This file is generated by updateDaemonJvm");
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static void validateToolchainVersion(JavaLanguageVersion version) {
        int minimalSupportedVersion = 8;
        if (!version.canCompileOrRun(minimalSupportedVersion)) {
            String exceptionMessage = String.format("Unsupported Java version '%s' provided for the 'jvm-version' option. Gradle can only run with Java %d and above.", version, minimalSupportedVersion);
            throw new IllegalArgumentException(exceptionMessage);
        }
    }
}

