/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.console;

import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.console.TestConsoleMetadata;
import org.jspecify.annotations.Nullable;

public class TestOverrideConsoleDetector
implements ConsoleDetector {
    public static final String INTERACTIVE_TOGGLE = "org.gradle.internal.interactive";
    public static final String TEST_CONSOLE_PROPERTY = "org.gradle.internal.console.test-console";
    private final ConsoleDetector detector;

    public TestOverrideConsoleDetector(ConsoleDetector detector) {
        this.detector = detector;
    }

    @Override
    public @Nullable ConsoleMetaData getConsole() {
        String testConsole = System.getProperty(TEST_CONSOLE_PROPERTY);
        if (testConsole != null) {
            return TestConsoleMetadata.valueOf(testConsole);
        }
        return this.detector.getConsole();
    }

    @Override
    public boolean isConsoleInput() {
        if (Boolean.getBoolean(INTERACTIVE_TOGGLE)) {
            return true;
        }
        return this.detector.isConsoleInput();
    }
}

