/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.BuildToolingModelController;
import org.gradle.internal.buildtree.BuildTreeModelAction;
import org.gradle.internal.buildtree.BuildTreeModelController;
import org.gradle.internal.buildtree.BuildTreeModelCreator;
import org.gradle.internal.buildtree.BuildTreeModelTarget;
import org.gradle.internal.buildtree.IntermediateBuildActionRunner;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.tooling.provider.model.UnknownModelException;
import org.gradle.tooling.provider.model.internal.ToolingModelParameterCarrier;
import org.gradle.tooling.provider.model.internal.ToolingModelScope;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class DefaultBuildTreeModelCreator
implements BuildTreeModelCreator {
    private final BuildState defaultTarget;
    private final IntermediateBuildActionRunner actionRunner;
    private final ToolingModelParameterCarrier.Factory parameterCarrierFactory;
    private final BuildStateRegistry buildStateRegistry;
    private final BuildOperationRunner buildOperationRunner;

    public DefaultBuildTreeModelCreator(BuildState defaultTarget, IntermediateBuildActionRunner actionRunner, ToolingModelParameterCarrier.Factory parameterCarrierFactory, BuildStateRegistry buildStateRegistry, BuildOperationRunner buildOperationRunner) {
        this.defaultTarget = defaultTarget;
        this.actionRunner = actionRunner;
        this.parameterCarrierFactory = parameterCarrierFactory;
        this.buildStateRegistry = buildStateRegistry;
        this.buildOperationRunner = buildOperationRunner;
    }

    @Override
    public <T> void beforeTasks(BuildTreeModelAction<? extends T> action) {
        action.beforeTasks(new DefaultBuildTreeModelController());
    }

    @Override
    public <T> T fromBuildModel(BuildTreeModelAction<? extends T> action) {
        return action.fromBuildModel(new DefaultBuildTreeModelController());
    }

    private class DefaultBuildTreeModelController
    implements BuildTreeModelController {
        private DefaultBuildTreeModelController() {
        }

        @Override
        public GradleInternal getConfiguredModel() {
            return DefaultBuildTreeModelCreator.this.defaultTarget.withToolingModels(BuildToolingModelController::getConfiguredModel);
        }

        @Override
        public @Nullable Object getModel(final BuildTreeModelTarget target, final String modelName, final @Nullable Object parameter) throws UnknownModelException {
            return DefaultBuildTreeModelCreator.this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<Object>(){

                public @Nullable Object call(BuildOperationContext context) {
                    ToolingModelScope scope = DefaultBuildTreeModelController.this.locateBuilderForTarget(target, modelName, parameter != null);
                    return DefaultBuildTreeModelController.this.getModelForScope(scope, modelName, parameter);
                }

                public BuildOperationDescriptor.Builder description() {
                    String targetDescription = DefaultBuildTreeModelController.this.describeTarget(target);
                    return BuildOperationDescriptor.displayName((String)("Fetch model '" + modelName + "' for " + targetDescription)).progressDisplayName("Fetching model '" + modelName + "' for " + targetDescription);
                }
            });
        }

        @Override
        public boolean queryModelActionsRunInParallel() {
            return DefaultBuildTreeModelCreator.this.actionRunner.isParallel();
        }

        @Override
        public <T> List<T> runQueryModelActions(List<Supplier<T>> actions) {
            return DefaultBuildTreeModelCreator.this.actionRunner.run(actions);
        }

        private ToolingModelScope locateBuilderForTarget(BuildTreeModelTarget target, String modelName, boolean parameter) {
            if (target instanceof BuildTreeModelTarget.Default) {
                return this.locateBuilderForDefaultTarget(modelName, parameter);
            }
            if (target instanceof BuildTreeModelTarget.Build) {
                return this.locateBuilderForBuildTarget((BuildTreeModelTarget.Build)target, modelName, parameter);
            }
            if (target instanceof BuildTreeModelTarget.Project) {
                return this.locateBuilderForProjectTarget((BuildTreeModelTarget.Project)target, modelName, parameter);
            }
            throw new IllegalStateException("Unknown target: " + target);
        }

        private ToolingModelScope locateBuilderForDefaultTarget(String modelName, boolean param) {
            return this.locateBuilderForBuildTarget(DefaultBuildTreeModelCreator.this.defaultTarget, modelName, param);
        }

        private ToolingModelScope locateBuilderForProjectTarget(BuildTreeModelTarget.Project projectTarget, String modelName, boolean parameter) {
            BuildState build = this.findBuild(projectTarget.getBuildRootDir());
            ProjectState project = this.findProject(build, projectTarget.getProjectPath());
            return this.locateBuilderForProjectTarget(project, modelName, parameter);
        }

        private ToolingModelScope locateBuilderForBuildTarget(BuildTreeModelTarget.Build buildTarget, String modelName, boolean parameter) {
            BuildState build = this.findBuild(buildTarget.getBuildRootDir());
            return this.locateBuilderForBuildTarget(build, modelName, parameter);
        }

        private ToolingModelScope locateBuilderForBuildTarget(BuildState target, String modelName, boolean param) {
            return target.withToolingModels(controller -> controller.locateBuilderForTarget(modelName, param));
        }

        private ToolingModelScope locateBuilderForProjectTarget(ProjectState target, String modelName, boolean param) {
            return target.getOwner().withToolingModels(controller -> controller.locateBuilderForTarget(target, modelName, param));
        }

        private @Nullable Object getModelForScope(ToolingModelScope scope, String modelName, @Nullable Object parameter) {
            if (parameter == null) {
                return scope.getModel(modelName, null);
            }
            return scope.getModel(modelName, DefaultBuildTreeModelCreator.this.parameterCarrierFactory.createCarrier(parameter));
        }

        private String describeTarget(BuildTreeModelTarget target) {
            if (target instanceof BuildTreeModelTarget.Default) {
                return "default scope";
            }
            if (target instanceof BuildTreeModelTarget.Build) {
                return "build scope";
            }
            if (target instanceof BuildTreeModelTarget.Project) {
                return "project scope";
            }
            throw new IllegalStateException("Unknown target: " + target);
        }

        private BuildState findBuild(File targetBuildRootDir) {
            AtomicReference match = new AtomicReference();
            DefaultBuildTreeModelCreator.this.buildStateRegistry.visitBuilds(buildState -> {
                if (buildState.isImportableBuild() && buildState.getBuildRootDir().equals(targetBuildRootDir)) {
                    match.set(buildState);
                }
            });
            if (match.get() != null) {
                return (BuildState)match.get();
            }
            throw new IllegalArgumentException(targetBuildRootDir + " is not included in this build");
        }

        private ProjectState findProject(BuildState build, Path projectPath) {
            build.ensureProjectsLoaded();
            return build.getProjects().getProject(projectPath);
        }
    }
}

