/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.internal.Try;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.jspecify.annotations.NullMarked;

public class IntermediateBuildActionRunner {
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildModelParameters buildModelParameters;
    private final String buildOperationDescription;

    public IntermediateBuildActionRunner(BuildOperationExecutor buildOperationExecutor, BuildModelParameters buildModelParameters, String buildOperationDescription) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildModelParameters = buildModelParameters;
        this.buildOperationDescription = buildOperationDescription;
    }

    public boolean isParallel() {
        return this.buildModelParameters.isParallelToolingApiActions();
    }

    public <T> List<T> run(List<Supplier<T>> actions) {
        ArrayList<NestedAction<T>> wrappers = new ArrayList<NestedAction<T>>(actions.size());
        for (Supplier<T> action : actions) {
            wrappers.add(new NestedAction<T>(this.buildOperationDescription, action));
        }
        this.runActions(wrappers);
        ArrayList<Object> results = new ArrayList<Object>(actions.size());
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        for (NestedAction nestedAction : wrappers) {
            Try value = nestedAction.value();
            if (value.isSuccessful()) {
                results.add(value.get());
                continue;
            }
            failures.add((Throwable)value.getFailure().get());
        }
        if (!failures.isEmpty()) {
            throw new MultipleBuildOperationFailures(failures, null);
        }
        return results;
    }

    private <T> void runActions(Collection<NestedAction<T>> actions) {
        if (this.isParallel()) {
            this.buildOperationExecutor.runAllWithAccessToProjectState(buildOperationQueue -> {
                for (RunnableBuildOperation action : actions) {
                    buildOperationQueue.add((BuildOperation)action);
                }
            });
        } else {
            for (RunnableBuildOperation runnableBuildOperation : actions) {
                try {
                    runnableBuildOperation.run(null);
                }
                catch (Exception e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        }
    }

    @NullMarked
    private static class NestedAction<T>
    implements RunnableBuildOperation {
        private final String displayName;
        private final Supplier<T> action;
        private Try<T> result;

        public NestedAction(String displayName, Supplier<T> action) {
            this.displayName = displayName;
            this.action = action;
        }

        public void run(BuildOperationContext context) {
            try {
                T value = this.action.get();
                this.result = Try.successful(value);
            }
            catch (Throwable t) {
                this.result = Try.failure((Throwable)t);
            }
        }

        public Try<T> value() {
            return this.result;
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.displayName);
        }
    }
}

