/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems.failure;

import java.io.IOException;
import java.util.List;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailurePrinterListener;
import org.gradle.internal.problems.failure.StackTraceRelevance;
import org.jspecify.annotations.Nullable;

public class FailurePrinter {
    public static String printToString(Failure failure) {
        StringBuilder output = new StringBuilder();
        FailurePrinter.print(output, failure, FailurePrinterListener.NO_OP);
        return output.toString();
    }

    public static void print(Appendable output, Failure failure, FailurePrinterListener listener) {
        new Job(output, listener).print(failure);
    }

    private static final class Job {
        private final FailurePrinterListener listener;
        private final Appendable builder;
        private final String lineSeparator = SystemProperties.getInstance().getLineSeparator();

        private Job(Appendable builder, FailurePrinterListener listener) {
            this.listener = listener;
            this.builder = builder;
        }

        public void print(Failure failure) {
            try {
                this.printRecursively("", "", null, failure);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        private void printRecursively(String caption, String prefix, @Nullable Failure parent, Failure failure) throws IOException {
            this.builder.append(prefix).append(caption).append(failure.getHeader()).append(this.lineSeparator);
            this.listener.beforeFrames();
            this.appendFrames(prefix, parent, failure);
            this.listener.afterFrames();
            this.appendSuppressed(prefix, failure);
            this.appendCauses(prefix, failure);
        }

        private void appendSuppressed(String prefix, Failure failure) throws IOException {
            for (Failure suppressed : failure.getSuppressed()) {
                this.printRecursively("Suppressed: ", prefix + "\t", failure, suppressed);
            }
        }

        private void appendCauses(String prefix, Failure failure) throws IOException {
            List causes = failure.getCauses();
            if (causes.size() == 1) {
                this.printRecursively("Caused by: ", prefix, failure, (Failure)causes.get(0));
            } else {
                for (int i = 0; i < causes.size(); ++i) {
                    this.printRecursively(String.format("Cause %s: ", i + 1), prefix, failure, (Failure)causes.get(i));
                }
            }
        }

        private void appendFrames(String prefix, @Nullable Failure parent, Failure failure) throws IOException {
            List stackTrace = failure.getStackTrace();
            int commonTailSize = parent == null ? 0 : Job.countCommonTailFrames(stackTrace, parent.getStackTrace());
            int end = stackTrace.size() - commonTailSize;
            for (int i = 0; i < end; ++i) {
                StackTraceElement stackTraceElement = (StackTraceElement)stackTrace.get(i);
                StackTraceRelevance rel = failure.getStackTraceRelevance(i);
                this.appendFrame(prefix, stackTraceElement, rel);
            }
            if (commonTailSize > 0) {
                this.builder.append(prefix).append("\t... ").append(String.valueOf(commonTailSize)).append(" more").append(this.lineSeparator);
            }
        }

        private void appendFrame(String prefix, StackTraceElement frame, StackTraceRelevance relevance) throws IOException {
            this.listener.beforeFrame(frame, relevance);
            this.builder.append(prefix).append("\tat ").append(frame.toString()).append(this.lineSeparator);
        }

        private static int countCommonTailFrames(List<StackTraceElement> frames1, List<StackTraceElement> frames2) {
            int j1 = frames1.size() - 1;
            for (int j2 = frames2.size() - 1; j1 >= 0 && j2 >= 0 && frames1.get(j1).equals(frames2.get(j2)); --j1, --j2) {
            }
            return frames1.size() - (j1 + 1);
        }
    }
}

