/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.List;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.reporters.Files;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BannerPanel;
import org.testng.reporters.jq.ChronologicalPanel;
import org.testng.reporters.jq.GroupPanel;
import org.testng.reporters.jq.INavigatorPanel;
import org.testng.reporters.jq.IgnoredMethodsPanel;
import org.testng.reporters.jq.Model;
import org.testng.reporters.jq.NavigatorPanel;
import org.testng.reporters.jq.ReporterPanel;
import org.testng.reporters.jq.SuitePanel;
import org.testng.reporters.jq.TestNgXmlPanel;
import org.testng.reporters.jq.TestPanel;
import org.testng.reporters.jq.TimesPanel;
import org.testng.xml.XmlSuite;

public class Main
implements IReporter {
    private static final String TESTNG_RESOURCE_PREFIX = "/org/testng/";
    private static final String[] RESOURCES = new String[]{"jquery-3.6.0.min.js", "testng-reports.css", "testng-reports.js", "testng-reports1.css", "testng-reports2.js", "passed.png", "failed.png", "skipped.png", "navigator-bullet.png", "bullet_point.png", "collapseall.gif"};
    public static final String REPORT_HEADER_FILE = "header";

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        Model m_model = new Model(suites);
        XMLStringBuffer xsb = new XMLStringBuffer("    ");
        new BannerPanel(m_model).generate(xsb);
        List<INavigatorPanel> panels = Arrays.asList(new TestNgXmlPanel(m_model), new TestPanel(m_model), new GroupPanel(m_model), new TimesPanel(m_model), new ReporterPanel(m_model), new IgnoredMethodsPanel(m_model), new ChronologicalPanel(m_model));
        new NavigatorPanel(m_model, panels).generate(xsb);
        xsb.push("div", "class", "wrapper");
        xsb.push("div", "class", "main-panel-root");
        new SuitePanel(m_model).generate(xsb);
        for (INavigatorPanel panel : panels) {
            panel.generate(xsb);
        }
        xsb.pop("div");
        xsb.pop("div");
        xsb.addString("  </body>\n");
        xsb.addString("<script type=\"text/javascript\" src=\"testng-reports2.js\"></script>\n");
        xsb.addString("</html>\n");
        try (InputStream header = this.getClass().getResourceAsStream("/org/testng/header");){
            if (header == null) {
                throw new RuntimeException("Couldn't find resource header");
            }
            for (String fileName : RESOURCES) {
                try (InputStream is = this.load(fileName);){
                    if (is == null) {
                        throw new AssertionError((Object)("Couldn't find resource: " + fileName));
                    }
                    File fileToCopy = new File(outputDirectory, fileName);
                    fileToCopy.getParentFile().mkdirs();
                    java.nio.file.Files.copy(is, fileToCopy.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            String all = Files.readFile(header);
            Utils.writeUtf8File(outputDirectory, "index.html", xsb, all);
        }
        catch (IOException e) {
            Logger.getLogger(Main.class).error(e.getMessage(), e);
        }
    }

    private InputStream load(String fileName) {
        String path = TESTNG_RESOURCE_PREFIX + fileName;
        return this.getClass().getResourceAsStream(path);
    }
}

