/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactionalobjects;

import org.multiverse.api.IsolationLevel;
import org.multiverse.api.LockMode;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnThreadLocal;
import org.multiverse.api.blocking.RetryLatch;
import org.multiverse.api.exceptions.LockedException;
import org.multiverse.api.exceptions.TxnMandatoryException;
import org.multiverse.api.functions.BooleanFunction;
import org.multiverse.api.functions.DoubleFunction;
import org.multiverse.api.functions.Function;
import org.multiverse.api.functions.IntFunction;
import org.multiverse.api.functions.LongFunction;
import org.multiverse.stms.gamma.GammaObjectPool;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.GammaStmUtils;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.ThreadLocalGammaObjectPool;
import org.multiverse.stms.gamma.transactionalobjects.AbstractGammaObject;
import org.multiverse.stms.gamma.transactionalobjects.CallableNode;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;
import org.multiverse.stms.gamma.transactions.GammaTxnConfig;
import org.multiverse.stms.gamma.transactions.fat.FatFixedLengthGammaTxn;
import org.multiverse.stms.gamma.transactions.fat.FatMonoGammaTxn;
import org.multiverse.stms.gamma.transactions.fat.FatVariableLengthGammaTxn;
import org.multiverse.stms.gamma.transactions.lean.LeanFixedLengthGammaTxn;
import org.multiverse.stms.gamma.transactions.lean.LeanMonoGammaTxn;
import org.multiverse.utils.Bugshaker;

public abstract class BaseGammaTxnRef
extends AbstractGammaObject {
    public final int type;
    public volatile long long_value;
    public volatile Object ref_value;

    protected BaseGammaTxnRef(GammaStm stm, int type) {
        super(stm);
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean flattenCommute(GammaTxn tx, Tranlocal tranlocal, int lockMode) {
        assert (tranlocal.mode == 3);
        GammaTxnConfig config = tx.config;
        tx.initLocalConflictCounter();
        if (!this.load(tx, tranlocal, lockMode, config.spinCount, tx.richmansMansConflictScan)) {
            return false;
        }
        tranlocal.setDirty(!config.dirtyCheck);
        tranlocal.mode = 2;
        if (!tx.isReadConsistent(tranlocal)) {
            return false;
        }
        boolean abort = true;
        try {
            CallableNode node = tranlocal.headCallable;
            while (node != null) {
                this.evaluate(tranlocal, tx, node.function);
                CallableNode newNext = node.next;
                tx.pool.putCallableNode(node);
                node = newNext;
            }
            tranlocal.headCallable = null;
            abort = false;
        }
        finally {
            if (abort) {
                tx.abort();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void evaluate(Tranlocal tranlocal, GammaTxn tx, Function function) {
        tx.evaluatingCommute = true;
        try {
            switch (this.type) {
                case 5: {
                    tranlocal.ref_value = function.call(tranlocal.ref_value);
                    return;
                }
                case 1: {
                    IntFunction intFunction = (IntFunction)function;
                    tranlocal.long_value = intFunction.call((int)tranlocal.long_value);
                    return;
                }
                case 2: {
                    LongFunction longFunction = (LongFunction)function;
                    tranlocal.long_value = longFunction.call(tranlocal.long_value);
                    return;
                }
                case 3: {
                    DoubleFunction doubleFunction = (DoubleFunction)function;
                    double doubleResult = doubleFunction.call(GammaStmUtils.longAsDouble(tranlocal.long_value));
                    tranlocal.long_value = GammaStmUtils.doubleAsLong(doubleResult);
                    return;
                }
                case 4: {
                    BooleanFunction booleanFunction = (BooleanFunction)function;
                    boolean booleanResult = booleanFunction.call(GammaStmUtils.longAsBoolean(tranlocal.long_value));
                    tranlocal.long_value = GammaStmUtils.booleanAsLong(booleanResult);
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            tx.evaluatingCommute = false;
        }
    }

    public final Listeners commit(Tranlocal tranlocal, GammaObjectPool pool) {
        if (!tranlocal.isDirty) {
            this.releaseAfterReading(tranlocal, pool);
            return null;
        }
        if (this.type == 5) {
            this.ref_value = tranlocal.ref_value;
            tranlocal.ref_value = null;
            tranlocal.ref_oldValue = null;
        } else {
            this.long_value = tranlocal.long_value;
        }
        this.version = tranlocal.version + 1L;
        Listeners listenerAfterWrite = this.listeners;
        if (listenerAfterWrite != null) {
            listenerAfterWrite = this.___removeListenersAfterWrite();
        }
        this.releaseAfterUpdate(tranlocal, pool);
        return listenerAfterWrite;
    }

    public final Listeners leanCommit(Tranlocal tranlocal) {
        assert (this.type == 5);
        if (tranlocal.mode == 4) {
            tranlocal.ref_value = null;
            tranlocal.owner = null;
            return null;
        }
        this.ref_value = tranlocal.ref_value;
        this.version = tranlocal.version + 1L;
        Listeners listenerAfterWrite = this.listeners;
        if (listenerAfterWrite != null) {
            listenerAfterWrite = this.___removeListenersAfterWrite();
        }
        this.departAfterUpdateAndUnlock();
        tranlocal.ref_value = null;
        tranlocal.lockMode = 0;
        tranlocal.owner = null;
        tranlocal.hasDepartObligation = false;
        return listenerAfterWrite;
    }

    public final boolean prepare(GammaTxn tx, Tranlocal tranlocal) {
        int mode = tranlocal.getMode();
        if (mode == 1) {
            return true;
        }
        if (mode == 4) {
            if (!tranlocal.writeSkewCheck) {
                return true;
            }
            return this.tryLockAndCheckConflict(tx, tranlocal, tx.config.spinCount, 1);
        }
        if (mode == 3 && !this.flattenCommute(tx, tranlocal, 3)) {
            return false;
        }
        if (!tranlocal.isDirty) {
            boolean isDirty;
            boolean bl = this.type == 5 ? tranlocal.ref_value != tranlocal.ref_oldValue : (isDirty = tranlocal.long_value != tranlocal.long_oldValue);
            if (!isDirty) {
                if (!tranlocal.writeSkewCheck) {
                    return true;
                }
                return this.tryLockAndCheckConflict(tx, tranlocal, tx.config.spinCount, 1);
            }
            tranlocal.isDirty = true;
        }
        return this.tryLockAndCheckConflict(tx, tranlocal, tx.config.spinCount, 3);
    }

    public final void releaseAfterFailure(Tranlocal tranlocal, GammaObjectPool pool) {
        if (this.type == 5) {
            tranlocal.ref_value = null;
            tranlocal.ref_oldValue = null;
        }
        if (tranlocal.headCallable != null) {
            CallableNode next;
            CallableNode node = tranlocal.headCallable;
            do {
                next = node.next;
                pool.putCallableNode(node);
            } while ((node = next) != null);
            tranlocal.headCallable = null;
        }
        if (tranlocal.hasDepartObligation()) {
            if (tranlocal.isConstructing()) {
                tranlocal.setLockMode(0);
            } else if (tranlocal.getLockMode() != 0) {
                this.departAfterFailureAndUnlock();
                tranlocal.setLockMode(0);
            } else {
                this.departAfterFailure();
            }
            tranlocal.setDepartObligation(false);
        } else if (tranlocal.getLockMode() != 0) {
            this.unlockByUnregistered();
            tranlocal.setLockMode(0);
        }
        tranlocal.owner = null;
    }

    public final void releaseAfterUpdate(Tranlocal tranlocal, GammaObjectPool pool) {
        if (this.type == 5) {
            tranlocal.ref_value = null;
            tranlocal.ref_oldValue = null;
        }
        this.departAfterUpdateAndUnlock();
        tranlocal.lockMode = 0;
        tranlocal.owner = null;
        tranlocal.hasDepartObligation = false;
    }

    public final void releaseAfterReading(Tranlocal tranlocal, GammaObjectPool pool) {
        if (this.type == 5) {
            tranlocal.ref_value = null;
            tranlocal.ref_oldValue = null;
        }
        if (tranlocal.hasDepartObligation()) {
            if (tranlocal.getLockMode() != 0) {
                this.departAfterReadingAndUnlock();
                tranlocal.setLockMode(0);
            } else {
                this.departAfterReading();
            }
            tranlocal.setDepartObligation(false);
        } else if (tranlocal.getLockMode() != 0) {
            this.unlockByUnregistered();
            tranlocal.setLockMode(0);
        }
        tranlocal.owner = null;
    }

    public final boolean load(GammaTxn tx, Tranlocal tranlocal, int lockMode, int spinCount, boolean arriveNeeded) {
        if (lockMode != 0) {
            int result = this.arriveAndLock(spinCount, lockMode);
            if (result == 0) {
                return false;
            }
            tranlocal.owner = this;
            tranlocal.version = this.version;
            if (this.type == 5) {
                Object value = this.ref_value;
                tranlocal.ref_value = value;
                tranlocal.ref_oldValue = value;
            } else {
                long value;
                tranlocal.long_value = value = this.long_value;
                tranlocal.long_oldValue = value;
            }
            tranlocal.lockMode = lockMode;
            tranlocal.hasDepartObligation = (result & 2) == 0;
            tx.commitConflict = (result & 4) != 0;
            return true;
        }
        while (true) {
            int arriveStatus;
            long readVersion;
            long readLong = 0L;
            Object readRef = null;
            if (this.type == 5) {
                do {
                    readVersion = this.version;
                    readRef = this.ref_value;
                    if (!SHAKE_BUGS) continue;
                    Bugshaker.shakeBugs();
                } while (readVersion != this.version);
            } else {
                do {
                    readVersion = this.version;
                    readLong = this.long_value;
                    if (!SHAKE_BUGS) continue;
                    Bugshaker.shakeBugs();
                } while (readVersion != this.version);
            }
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if ((arriveStatus = arriveNeeded ? this.arrive(spinCount) : (this.waitForExclusiveLockToBecomeFree(spinCount) ? 3 : 0)) == 0) {
                return false;
            }
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if (this.version == readVersion) {
                tranlocal.owner = this;
                tranlocal.version = readVersion;
                tranlocal.lockMode = 0;
                boolean bl = tranlocal.hasDepartObligation = (arriveStatus & 2) == 0;
                if (this.type == 5) {
                    tranlocal.ref_value = readRef;
                    tranlocal.ref_oldValue = readRef;
                } else {
                    tranlocal.long_value = readLong;
                    tranlocal.long_oldValue = readLong;
                }
                return true;
            }
            if ((arriveStatus & 2) != 0) continue;
            this.departAfterFailure();
        }
    }

    public final Tranlocal openForConstruction(GammaTxn tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        int type = tx.transactionType;
        if (type == 3) {
            return this.openForConstruction((FatMonoGammaTxn)tx);
        }
        if (type == 4) {
            return this.openForConstruction((FatFixedLengthGammaTxn)tx);
        }
        if (type == 5) {
            return this.openForConstruction((FatVariableLengthGammaTxn)tx);
        }
        throw tx.abortOpenForConstructionRequired(this);
    }

    private void initTranlocalForConstruction(Tranlocal tranlocal) {
        tranlocal.isDirty = true;
        tranlocal.mode = 1;
        tranlocal.setLockMode(3);
        tranlocal.setDepartObligation(true);
        if (this.type == 5) {
            tranlocal.ref_value = null;
            tranlocal.ref_oldValue = null;
        } else {
            tranlocal.long_value = 0L;
            tranlocal.long_oldValue = 0L;
        }
    }

    public final Tranlocal openForConstruction(FatMonoGammaTxn tx) {
        if (tx.status != 1) {
            throw tx.abortOpenForConstructionOnBadStatus(this);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortOpenForConstructionOnBadStm(this);
        }
        if (config.readonly) {
            throw tx.abortOpenForConstructionOnReadonly(this);
        }
        if (tx.evaluatingCommute) {
            throw tx.abortOnOpenForConstructionWhileEvaluatingCommute(this);
        }
        Tranlocal tranlocal = tx.tranlocal;
        if (tranlocal.owner == this) {
            if (!tranlocal.isConstructing()) {
                throw tx.abortOpenForConstructionOnBadReference(this);
            }
            return tranlocal;
        }
        if (tranlocal.owner != null) {
            throw tx.abortOnTransactionTooSmall(2);
        }
        tx.hasWrites = true;
        tranlocal.owner = this;
        this.initTranlocalForConstruction(tranlocal);
        return tranlocal;
    }

    public final Tranlocal openForConstruction(FatVariableLengthGammaTxn tx) {
        if (tx.status != 1) {
            throw tx.abortOpenForConstructionOnBadStatus(this);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortOpenForConstructionOnBadStm(this);
        }
        if (config.readonly) {
            throw tx.abortOpenForConstructionOnReadonly(this);
        }
        if (tx.evaluatingCommute) {
            throw tx.abortOnOpenForConstructionWhileEvaluatingCommute(this);
        }
        int identityHash = this.identityHashCode();
        int indexOf = tx.indexOf(this, identityHash);
        if (indexOf > -1) {
            Tranlocal tranlocal = tx.array[indexOf];
            if (!tranlocal.isConstructing()) {
                throw tx.abortOpenForConstructionOnBadReference(this);
            }
            return tranlocal;
        }
        Tranlocal tranlocal = tx.pool.take(this);
        tranlocal.owner = this;
        this.initTranlocalForConstruction(tranlocal);
        tx.hasWrites = true;
        tx.attach(tranlocal, identityHash);
        ++tx.size;
        return tranlocal;
    }

    public final Tranlocal openForConstruction(FatFixedLengthGammaTxn tx) {
        if (tx.status != 1) {
            throw tx.abortOpenForConstructionOnBadStatus(this);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortOpenForConstructionOnBadStm(this);
        }
        if (config.readonly) {
            throw tx.abortOpenForConstructionOnReadonly(this);
        }
        if (tx.evaluatingCommute) {
            throw tx.abortOnOpenForConstructionWhileEvaluatingCommute(this);
        }
        Tranlocal found = null;
        Tranlocal newNode = null;
        Tranlocal node = tx.head;
        while (node != null) {
            if (node.owner == this) {
                found = node;
                break;
            }
            if (node.owner == null) {
                newNode = node;
                break;
            }
            node = node.next;
        }
        if (found != null) {
            if (!found.isConstructing()) {
                throw tx.abortOpenForConstructionOnBadReference(this);
            }
            tx.shiftInFront(found);
            return found;
        }
        if (newNode == null) {
            throw tx.abortOnTransactionTooSmall(config.maxFixedLengthTransactionSize + 1);
        }
        newNode.owner = this;
        this.initTranlocalForConstruction(newNode);
        ++tx.size;
        tx.shiftInFront(newNode);
        tx.hasWrites = true;
        return newNode;
    }

    public final Tranlocal openForRead(GammaTxn tx, int lockMode) {
        if (tx == null) {
            throw new NullPointerException();
        }
        int type = tx.transactionType;
        if (type == 1) {
            return this.openForRead((LeanMonoGammaTxn)tx, lockMode);
        }
        if (type == 2) {
            return this.openForRead((LeanFixedLengthGammaTxn)tx, lockMode);
        }
        if (type == 3) {
            return this.openForRead((FatMonoGammaTxn)tx, lockMode);
        }
        if (type == 4) {
            return this.openForRead((FatFixedLengthGammaTxn)tx, lockMode);
        }
        return this.openForRead((FatVariableLengthGammaTxn)tx, lockMode);
    }

    /*
     * Unable to fully structure code
     */
    public final Tranlocal openForRead(LeanMonoGammaTxn tx, int lockMode) {
        if (tx.status != 1) {
            throw tx.abortOpenForReadOnBadStatus(this);
        }
        if (lockMode != 0) {
            throw tx.abortOpenForReadOrWriteOnExplicitLockingDetected(this);
        }
        tranlocal = tx.tranlocal;
        if (tranlocal.owner == this) {
            return tranlocal;
        }
        if (tranlocal.owner != null) {
            throw tx.abortOnTransactionTooSmall(2);
        }
        config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortOpenForReadOnBadStm(this);
        }
        if (this.type != 5) {
            throw tx.abortOpenForReadOnNonRefTypeDetected(this);
        }
        tranlocal.mode = 4;
        tranlocal.owner = this;
        do lbl-1000:
        // 3 sources

        {
            block10: {
                readVersion = this.version;
                readRef = this.ref_value;
                if (BaseGammaTxnRef.SHAKE_BUGS) {
                    Bugshaker.shakeBugs();
                }
                if (readVersion != this.version) ** GOTO lbl-1000
                spinCount = 64;
                do {
                    if (BaseGammaTxnRef.SHAKE_BUGS) {
                        Bugshaker.shakeBugs();
                    }
                    if (!this.hasExclusiveLock()) break block10;
                } while (--spinCount >= 0);
                throw tx.abortOnReadWriteConflict(this);
            }
            if (!BaseGammaTxnRef.SHAKE_BUGS) continue;
            Bugshaker.shakeBugs();
        } while (readVersion != this.version);
        tranlocal.version = readVersion;
        tranlocal.ref_value = readRef;
        return tranlocal;
    }

    public final Tranlocal openForRead(LeanFixedLengthGammaTxn tx, int lockMode) {
        Object readRef;
        long readVersion;
        if (tx.status != 1) {
            throw tx.abortOpenForReadOnBadStatus(this);
        }
        if (lockMode != 0) {
            throw tx.abortOpenForReadOrWriteOnExplicitLockingDetected(this);
        }
        if (tx.head.owner == this) {
            return tx.head;
        }
        Tranlocal found = null;
        Tranlocal newNode = null;
        Tranlocal node = tx.head;
        while (node != null) {
            if (node.owner == this) {
                found = node;
                break;
            }
            if (node.owner == null) {
                newNode = node;
                break;
            }
            node = node.next;
        }
        if (found != null) {
            tx.shiftInFront(found);
            return found;
        }
        if (newNode == null) {
            throw tx.abortOnTransactionTooSmall(tx.config.maxFixedLengthTransactionSize + 1);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortOpenForReadOnBadStm(this);
        }
        if (this.type != 5) {
            throw tx.abortOpenForReadOnNonRefTypeDetected(this);
        }
        int size = tx.size;
        if (size > config.maximumPoorMansConflictScanLength) {
            throw tx.abortOnRichmanConflictScanDetected();
        }
        newNode.mode = 4;
        newNode.isDirty = false;
        newNode.owner = this;
        while (true) {
            block22: {
                readVersion = this.version;
                readRef = this.ref_value;
                if (SHAKE_BUGS) {
                    Bugshaker.shakeBugs();
                }
                if (readVersion != this.version) continue;
                int spinCount = 64;
                do {
                    if (SHAKE_BUGS) {
                        Bugshaker.shakeBugs();
                    }
                    if (!this.hasExclusiveLock()) break block22;
                } while (--spinCount >= 0);
                throw tx.abortOnReadWriteConflict(this);
            }
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if (readVersion == this.version && readRef == this.ref_value) break;
        }
        newNode.version = readVersion;
        newNode.ref_value = readRef;
        tx.size = size + 1;
        if (tx.size > 1) {
            tx.shiftInFront(newNode);
        }
        if (tx.hasReads) {
            BaseGammaTxnRef owner;
            node = tx.head;
            while ((owner = node.owner) != null) {
                if (SHAKE_BUGS) {
                    Bugshaker.shakeBugs();
                }
                if (node != newNode && (owner.hasExclusiveLock() || owner.version != node.version)) {
                    throw tx.abortOnReadWriteConflict(this);
                }
                node = node.next;
                if (node != null) continue;
                break;
            }
        } else {
            tx.hasReads = true;
        }
        return newNode;
    }

    private static void initTranlocalForRead(GammaTxnConfig config, Tranlocal tranlocal) {
        tranlocal.isDirty = false;
        tranlocal.mode = 4;
        tranlocal.writeSkewCheck = config.isolationLevel == IsolationLevel.Serializable;
        tranlocal.version = -1L;
    }

    public final Tranlocal openForRead(FatMonoGammaTxn tx, int lockMode) {
        if (tx.status != 1) {
            throw tx.abortOpenForReadOnBadStatus(this);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortOpenForReadOnBadStm(this);
        }
        if (tx.evaluatingCommute) {
            throw tx.abortOnOpenForReadWhileEvaluatingCommute(this);
        }
        lockMode = config.readLockModeAsInt <= lockMode ? lockMode : config.readLockModeAsInt;
        Tranlocal tranlocal = tx.tranlocal;
        if (tranlocal.owner == this) {
            int mode = tranlocal.mode;
            if (mode == 1) {
                return tranlocal;
            }
            if (mode == 3) {
                if (!this.flattenCommute(tx, tranlocal, lockMode)) {
                    throw tx.abortOnReadWriteConflict(this);
                }
                return tranlocal;
            }
            if (lockMode > tranlocal.getLockMode() && !this.tryLockAndCheckConflict(tx, tranlocal, config.spinCount, lockMode)) {
                throw tx.abortOnReadWriteConflict(this);
            }
            return tranlocal;
        }
        if (tranlocal.owner != null) {
            throw tx.abortOnTransactionTooSmall(2);
        }
        BaseGammaTxnRef.initTranlocalForRead(config, tranlocal);
        if (!this.load(tx, tranlocal, lockMode, config.spinCount, tx.richmansMansConflictScan)) {
            throw tx.abortOnReadWriteConflict(this);
        }
        return tranlocal;
    }

    public final Tranlocal openForRead(FatFixedLengthGammaTxn tx, int desiredLockMode) {
        if (tx.status != 1) {
            throw tx.abortOpenForReadOnBadStatus(this);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortOpenForReadOnBadStm(this);
        }
        if (tx.evaluatingCommute) {
            throw tx.abortOnOpenForReadWhileEvaluatingCommute(this);
        }
        Tranlocal found = null;
        Tranlocal newNode = null;
        Tranlocal node = tx.head;
        while (node != null) {
            if (node.owner == this) {
                found = node;
                break;
            }
            if (node.owner == null) {
                newNode = node;
                break;
            }
            node = node.next;
        }
        int n = desiredLockMode = config.readLockModeAsInt <= desiredLockMode ? desiredLockMode : config.readLockModeAsInt;
        if (found != null) {
            int mode = found.mode;
            if (mode == 1) {
                return found;
            }
            if (mode == 3) {
                if (!this.flattenCommute(tx, found, desiredLockMode)) {
                    throw tx.abortOnReadWriteConflict(this);
                }
                return found;
            }
            if (desiredLockMode > found.getLockMode() && !this.tryLockAndCheckConflict(tx, found, config.spinCount, desiredLockMode)) {
                throw tx.abortOnReadWriteConflict(this);
            }
            tx.shiftInFront(found);
            return found;
        }
        if (newNode == null) {
            throw tx.abortOnTransactionTooSmall(config.maxFixedLengthTransactionSize + 1);
        }
        ++tx.size;
        BaseGammaTxnRef.initTranlocalForRead(config, newNode);
        boolean hasReadsBeforeLoading = tx.hasReads;
        if (!hasReadsBeforeLoading) {
            tx.localConflictCount = config.globalConflictCounter.count();
            tx.hasReads = true;
        }
        if (!this.load(tx, newNode, desiredLockMode, config.spinCount, tx.richmansMansConflictScan)) {
            throw tx.abortOnReadWriteConflict(this);
        }
        if (!tx.isReadConsistent(newNode)) {
            throw tx.abortOnReadWriteConflict(this);
        }
        tx.shiftInFront(newNode);
        return newNode;
    }

    public final Tranlocal openForRead(FatVariableLengthGammaTxn tx, int desiredLockMode) {
        if (tx.status != 1) {
            throw tx.abortOpenForReadOnBadStatus(this);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortOpenForReadOnBadStm(this);
        }
        if (tx.evaluatingCommute) {
            throw tx.abortOnOpenForReadWhileEvaluatingCommute(this);
        }
        desiredLockMode = config.readLockModeAsInt <= desiredLockMode ? desiredLockMode : config.readLockModeAsInt;
        int identityHash = this.identityHashCode();
        int indexOf = tx.indexOf(this, identityHash);
        if (indexOf > -1) {
            Tranlocal tranlocal = tx.array[indexOf];
            int mode = tranlocal.mode;
            if (mode == 1) {
                return tranlocal;
            }
            if (mode == 3) {
                if (!this.flattenCommute(tx, tranlocal, desiredLockMode)) {
                    throw tx.abortOnReadWriteConflict(this);
                }
                return tranlocal;
            }
            if (desiredLockMode > tranlocal.getLockMode() && !this.tryLockAndCheckConflict(tx, tranlocal, config.spinCount, desiredLockMode)) {
                throw tx.abortOnReadWriteConflict(this);
            }
            return tranlocal;
        }
        Tranlocal tranlocal = tx.pool.take(this);
        BaseGammaTxnRef.initTranlocalForRead(config, tranlocal);
        tx.attach(tranlocal, identityHash);
        ++tx.size;
        boolean hasReadsBeforeLoading = tx.hasReads;
        if (!hasReadsBeforeLoading) {
            tx.hasReads = true;
            tx.localConflictCount = config.globalConflictCounter.count();
        }
        if (!this.load(tx, tranlocal, desiredLockMode, config.spinCount, tx.richmansMansConflictScan)) {
            throw tx.abortOnReadWriteConflict(this);
        }
        if (!tx.isReadConsistent(tranlocal)) {
            throw tx.abortOnReadWriteConflict(this);
        }
        return tranlocal;
    }

    public final Tranlocal openForWrite(GammaTxn tx, int lockMode) {
        if (tx == null) {
            throw new NullPointerException();
        }
        int type = tx.transactionType;
        if (type == 1) {
            return this.openForWrite((LeanMonoGammaTxn)tx, lockMode);
        }
        if (type == 2) {
            return this.openForWrite((LeanFixedLengthGammaTxn)tx, lockMode);
        }
        if (type == 3) {
            return this.openForWrite((FatMonoGammaTxn)tx, lockMode);
        }
        if (type == 4) {
            return this.openForWrite((FatFixedLengthGammaTxn)tx, lockMode);
        }
        return this.openForWrite((FatVariableLengthGammaTxn)tx, lockMode);
    }

    public final Tranlocal openForWrite(LeanMonoGammaTxn tx, int lockMode) {
        Tranlocal tranlocal = this.openForRead(tx, lockMode);
        if (!tx.hasWrites) {
            tx.hasWrites = true;
        }
        if (tranlocal.mode == 4) {
            tranlocal.mode = 2;
        }
        return tranlocal;
    }

    public final Tranlocal openForWrite(LeanFixedLengthGammaTxn tx, int lockMode) {
        Tranlocal tranlocal = this.openForRead(tx, lockMode);
        if (!tx.hasWrites) {
            tx.hasWrites = true;
        }
        if (tranlocal.mode == 4) {
            tranlocal.mode = 2;
        }
        return tranlocal;
    }

    public final Tranlocal openForWrite(FatMonoGammaTxn tx, int desiredLockMode) {
        GammaTxnConfig config = tx.config;
        Tranlocal tranlocal = this.openForRead(tx, Math.max(desiredLockMode, config.writeLockModeAsInt));
        if (config.readonly) {
            throw tx.abortOpenForWriteOnReadonly(this);
        }
        if (!tx.hasWrites) {
            tx.hasWrites = true;
        }
        if (tranlocal.mode == 4) {
            tranlocal.mode = 2;
            tranlocal.writeSkewCheck = config.isolationLevel == IsolationLevel.Serializable;
            tranlocal.setDirty(!config.dirtyCheck);
        }
        return tranlocal;
    }

    public final Tranlocal openForWrite(FatFixedLengthGammaTxn tx, int lockMode) {
        GammaTxnConfig config = tx.config;
        Tranlocal tranlocal = this.openForRead(tx, Math.max(lockMode, config.writeLockModeAsInt));
        if (config.readonly) {
            throw tx.abortOpenForWriteOnReadonly(this);
        }
        if (!tx.hasWrites) {
            tx.hasWrites = true;
        }
        if (tranlocal.mode == 4) {
            tranlocal.mode = 2;
            tranlocal.writeSkewCheck = config.isolationLevel == IsolationLevel.Serializable;
            tranlocal.setDirty(!config.dirtyCheck);
        }
        return tranlocal;
    }

    public final Tranlocal openForWrite(FatVariableLengthGammaTxn tx, int lockMode) {
        GammaTxnConfig config = tx.config;
        Tranlocal tranlocal = this.openForRead(tx, Math.max(lockMode, config.writeLockModeAsInt));
        if (config.readonly) {
            throw tx.abortOpenForWriteOnReadonly(this);
        }
        if (!tx.hasWrites) {
            tx.hasWrites = true;
        }
        if (tranlocal.mode == 4) {
            tranlocal.mode = 2;
            tranlocal.writeSkewCheck = config.isolationLevel == IsolationLevel.Serializable;
            tranlocal.setDirty(!config.dirtyCheck);
        }
        return tranlocal;
    }

    public final void openForCommute(GammaTxn tx, Function function) {
        if (tx == null) {
            throw new NullPointerException("txn can't be null");
        }
        int type = tx.transactionType;
        if (type == 3) {
            this.openForCommute((FatMonoGammaTxn)tx, function);
        } else if (type == 4) {
            this.openForCommute((FatFixedLengthGammaTxn)tx, function);
        } else if (type == 5) {
            this.openForCommute((FatVariableLengthGammaTxn)tx, function);
        } else {
            throw tx.abortCommuteOnCommuteDetected(this);
        }
    }

    private void initTranlocalForCommute(GammaTxnConfig config, Tranlocal tranlocal) {
        tranlocal.owner = this;
        tranlocal.mode = 3;
        tranlocal.isDirty = !config.dirtyCheck;
        tranlocal.writeSkewCheck = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void openForCommute(FatMonoGammaTxn tx, Function function) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (tx.status != 1) {
            throw tx.abortCommuteOnBadStatus(this, function);
        }
        if (function == null) {
            throw tx.abortCommuteOnNullFunction(this);
        }
        if (tx.evaluatingCommute) {
            throw tx.abortOnOpenForCommuteWhileEvaluatingCommute(this);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortCommuteOnBadStm(this);
        }
        if (config.isReadonly()) {
            throw tx.abortCommuteOnReadonly(this);
        }
        if (config.writeLockModeAsInt > 0) {
            // empty if block
        }
        Tranlocal tranlocal = tx.tranlocal;
        if (tranlocal.owner == this) {
            if (tranlocal.isCommuting()) {
                tranlocal.addCommutingFunction(tx.pool, function);
                return;
            }
            if (tranlocal.isRead()) {
                tranlocal.mode = 2;
                tx.hasWrites = true;
            }
            boolean abort = true;
            try {
                this.evaluate(tranlocal, tx, function);
                abort = false;
            }
            finally {
                if (abort) {
                    tx.abort();
                }
            }
            return;
        }
        if (tranlocal.owner != null) {
            throw tx.abortOnTransactionTooSmall(2);
        }
        tx.hasWrites = true;
        this.initTranlocalForCommute(config, tranlocal);
        tranlocal.addCommutingFunction(tx.pool, function);
        int writeLockMode = config.writeLockModeAsInt;
        if (writeLockMode > 0) {
            this.flattenCommute(tx, tranlocal, writeLockMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void openForCommute(FatFixedLengthGammaTxn tx, Function function) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (tx.status != 1) {
            throw tx.abortCommuteOnBadStatus(this, function);
        }
        if (function == null) {
            throw tx.abortCommuteOnNullFunction(this);
        }
        if (tx.evaluatingCommute) {
            throw tx.abortOnOpenForCommuteWhileEvaluatingCommute(this);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortCommuteOnBadStm(this);
        }
        if (config.isReadonly()) {
            throw tx.abortCommuteOnReadonly(this);
        }
        Tranlocal found = null;
        Tranlocal newNode = null;
        Tranlocal node = tx.head;
        if (config.writeLockModeAsInt > 0) {
            found = this.openForWrite(tx, config.writeLockModeAsInt);
        } else {
            while (node != null) {
                if (node.owner == this) {
                    found = node;
                    break;
                }
                if (node.owner == null) {
                    newNode = node;
                    break;
                }
                node = node.next;
            }
        }
        if (found != null) {
            if (found.isCommuting()) {
                found.addCommutingFunction(tx.pool, function);
                return;
            }
            if (found.isRead()) {
                found.mode = 2;
                tx.hasWrites = true;
            }
            boolean abort = true;
            try {
                this.evaluate(found, tx, function);
                abort = false;
            }
            finally {
                if (abort) {
                    tx.abort();
                }
            }
            return;
        }
        if (newNode == null) {
            throw tx.abortOnTransactionTooSmall(config.maxFixedLengthTransactionSize + 1);
        }
        ++tx.size;
        tx.shiftInFront(newNode);
        tx.hasWrites = true;
        this.initTranlocalForCommute(config, newNode);
        newNode.addCommutingFunction(tx.pool, function);
        int writeLockMode = config.writeLockModeAsInt;
        if (writeLockMode > 0) {
            this.flattenCommute(tx, newNode, writeLockMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void openForCommute(FatVariableLengthGammaTxn tx, Function function) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (tx.status != 1) {
            throw tx.abortCommuteOnBadStatus(this, function);
        }
        if (function == null) {
            throw tx.abortCommuteOnNullFunction(this);
        }
        if (tx.evaluatingCommute) {
            throw tx.abortOnOpenForCommuteWhileEvaluatingCommute(this);
        }
        GammaTxnConfig config = tx.config;
        if (config.stm != this.stm) {
            throw tx.abortCommuteOnBadStm(this);
        }
        if (config.isReadonly()) {
            throw tx.abortCommuteOnReadonly(this);
        }
        int identityHash = this.identityHashCode();
        int indexOf = tx.indexOf(this, identityHash);
        if (indexOf > -1) {
            Tranlocal tranlocal = tx.array[indexOf];
            if (tranlocal.isCommuting()) {
                tranlocal.addCommutingFunction(tx.pool, function);
                return;
            }
            if (tranlocal.isRead()) {
                tranlocal.mode = 2;
                tx.hasWrites = true;
            }
            boolean abort = true;
            try {
                this.evaluate(tranlocal, tx, function);
                abort = false;
            }
            finally {
                if (abort) {
                    tx.abort();
                }
            }
            return;
        }
        Tranlocal tranlocal = tx.pool.take(this);
        this.initTranlocalForCommute(config, tranlocal);
        tx.hasWrites = true;
        tx.attach(tranlocal, identityHash);
        ++tx.size;
        tranlocal.addCommutingFunction(tx.pool, function);
        int writeLockMode = config.writeLockModeAsInt;
        if (writeLockMode > 0) {
            this.flattenCommute(tx, tranlocal, writeLockMode);
        }
    }

    public final void ensure() {
        this.ensure(GammaStmUtils.getRequiredThreadLocalGammaTxn());
    }

    public final void ensure(Txn self) {
        this.ensure(GammaStmUtils.asGammaTxn(self));
    }

    public final void ensure(GammaTxn tx) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (tx.status != 1) {
            throw tx.abortEnsureOnBadStatus(this);
        }
        if (tx.isLean()) {
            throw tx.abortEnsureOnEnsureDetected(this);
        }
        if (tx.config.readonly) {
            return;
        }
        Tranlocal tranlocal = this.openForRead(tx, 0);
        tranlocal.writeSkewCheck = true;
    }

    protected final long getLong(GammaTxn tx, LockMode lockMode) {
        assert (this.type != 5);
        if (tx == null) {
            throw new NullPointerException();
        }
        if (tx.status != 1) {
            throw tx.abortOpenForReadOnBadStatus(this);
        }
        if (lockMode == null) {
            throw tx.abortOpenForReadOnNullLockMode(this);
        }
        return this.openForRead((GammaTxn)tx, (int)lockMode.asInt()).long_value;
    }

    protected final Object getObject(GammaTxn tx, LockMode lockMode) {
        assert (this.type == 5);
        if (tx == null) {
            throw new NullPointerException();
        }
        if (tx.status != 1) {
            throw tx.abortOpenForReadOnBadStatus(this);
        }
        if (lockMode == null) {
            throw tx.abortOpenForReadOnNullLockMode(this);
        }
        return this.openForRead((GammaTxn)tx, (int)lockMode.asInt()).ref_value;
    }

    protected final long setLong(GammaTxn tx, LockMode lockMode, long newValue, boolean returnOld) {
        assert (this.type != 5);
        if (tx == null) {
            throw new NullPointerException();
        }
        if (tx.status != 1) {
            throw tx.abortOpenForReadOnBadStatus(this);
        }
        if (lockMode == null) {
            throw tx.abortOpenForReadOnNullLockMode(this);
        }
        Tranlocal tranlocal = this.openForWrite(tx, lockMode.asInt());
        long oldValue = tranlocal.long_value;
        tranlocal.long_value = newValue;
        return returnOld ? oldValue : newValue;
    }

    protected final Object setObject(GammaTxn tx, LockMode lockMode, Object newValue, boolean returnOld) {
        assert (this.type == 5);
        if (tx == null) {
            throw new NullPointerException();
        }
        if (tx.status != 1) {
            throw tx.abortOpenForReadOnBadStatus(this);
        }
        if (lockMode == null) {
            throw tx.abortOpenForReadOnNullLockMode(this);
        }
        Tranlocal tranlocal = this.openForWrite(tx, lockMode.asInt());
        Object oldValue = tranlocal.ref_value;
        tranlocal.ref_value = newValue;
        return returnOld ? oldValue : newValue;
    }

    public final long atomicGetLong() {
        assert (this.type != 5);
        int attempt = 1;
        do {
            if (!this.hasExclusiveLock()) {
                long read = this.long_value;
                if (!this.hasExclusiveLock()) {
                    return read;
                }
            }
            this.stm.defaultBackoffPolicy.delayUninterruptible(attempt);
        } while (++attempt <= this.stm.spinCount);
        throw new LockedException();
    }

    public final Object atomicObjectGet() {
        assert (this.type == 5);
        int attempt = 1;
        do {
            if (!this.hasExclusiveLock()) {
                Object read = this.ref_value;
                if (!this.hasExclusiveLock()) {
                    return read;
                }
            }
            this.stm.defaultBackoffPolicy.delayUninterruptible(attempt);
        } while (++attempt <= this.stm.spinCount);
        throw new LockedException();
    }

    public final long atomicSetLong(long newValue, boolean returnOld) {
        assert (this.type != 5);
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        long oldValue = this.long_value;
        if (oldValue == newValue) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return newValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.long_value = newValue;
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            GammaObjectPool pool = ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool();
            listeners.openAll(pool);
        }
        return returnOld ? oldValue : newValue;
    }

    public final Object atomicSetObject(Object newValue, boolean returnOld) {
        assert (this.type == 5);
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        Object oldValue = this.ref_value;
        if (oldValue == newValue) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return newValue;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.ref_value = newValue;
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            GammaObjectPool pool = ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool();
            listeners.openAll(pool);
        }
        return returnOld ? oldValue : newValue;
    }

    public final boolean atomicCompareAndSetLong(long expectedValue, long newValue) {
        int arriveStatus = this.arriveAndExclusiveLockOrBackoff();
        if (arriveStatus == 0) {
            throw new LockedException();
        }
        long currentValue = this.long_value;
        if (currentValue != expectedValue) {
            this.departAfterFailureAndUnlock();
            return false;
        }
        if (expectedValue == newValue) {
            if ((arriveStatus & 2) != 0) {
                this.unlockByUnregistered();
            } else {
                this.departAfterReadingAndUnlock();
            }
            return true;
        }
        if ((arriveStatus & 4) != 0) {
            this.stm.globalConflictCounter.signalConflict();
        }
        this.long_value = newValue;
        ++this.version;
        Listeners listeners = this.___removeListenersAfterWrite();
        this.departAfterUpdateAndUnlock();
        if (listeners != null) {
            listeners.openAll(ThreadLocalGammaObjectPool.getThreadLocalGammaObjectPool());
        }
        return true;
    }

    @Override
    public final void acquire(LockMode desiredLockMode) {
        GammaTxn tx = (GammaTxn)TxnThreadLocal.getThreadLocalTxn();
        if (tx == null) {
            throw new TxnMandatoryException();
        }
        this.acquire(tx, desiredLockMode);
    }

    @Override
    public final void acquire(Txn tx, LockMode desiredLockMode) {
        this.acquire((GammaTxn)tx, desiredLockMode);
    }

    public final void acquire(GammaTxn tx, LockMode lockMode) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (lockMode == null) {
            throw tx.abortAcquireOnNullLockMode(this);
        }
        this.openForRead(tx, lockMode.asInt());
    }

    public final boolean tryLockAndCheckConflict(GammaTxn tx, Tranlocal tranlocal, int spinCount, int desiredLockMode) {
        int currentLockMode = tranlocal.getLockMode();
        if (currentLockMode >= desiredLockMode) {
            return true;
        }
        if (currentLockMode == 0) {
            long expectedVersion = tranlocal.version;
            if (expectedVersion != this.version) {
                return false;
            }
            if (tranlocal.hasDepartObligation()) {
                int result = this.lockAfterArrive(spinCount, desiredLockMode);
                if (result == 0) {
                    return false;
                }
                if ((result & 4) != 0) {
                    tx.commitConflict = true;
                }
                if (this.version != expectedVersion) {
                    tranlocal.setDepartObligation(false);
                    this.departAfterFailureAndUnlock();
                    return false;
                }
            } else {
                int result = this.arriveAndLock(spinCount, desiredLockMode);
                if (result == 0) {
                    return false;
                }
                tranlocal.setLockMode(desiredLockMode);
                if ((result & 2) == 0) {
                    tranlocal.hasDepartObligation = true;
                }
                if ((result & 4) != 0) {
                    tx.commitConflict = true;
                }
                if (this.version != expectedVersion) {
                    return false;
                }
            }
            tranlocal.setLockMode(desiredLockMode);
            return true;
        }
        if (currentLockMode == 1) {
            int result = this.upgradeReadLock(spinCount, desiredLockMode == 3);
            if (result == 0) {
                return false;
            }
            if ((result & 4) != 0) {
                tx.commitConflict = true;
            }
            tranlocal.setLockMode(desiredLockMode);
            return true;
        }
        if (this.upgradeWriteLock()) {
            tx.commitConflict = true;
        }
        tranlocal.setLockMode(3);
        return true;
    }

    public final int registerChangeListener(RetryLatch latch, Tranlocal tranlocal, GammaObjectPool pool, long listenerEra) {
        boolean removed;
        Listeners current;
        boolean registered;
        if (tranlocal.isCommuting() || tranlocal.isConstructing()) {
            return 2;
        }
        long version = tranlocal.version;
        if (version != this.version) {
            latch.open(listenerEra);
            return 1;
        }
        Listeners update = pool.takeListeners();
        update.listener = latch;
        update.listenerEra = listenerEra;
        do {
            if (version != this.version) {
                latch.open(listenerEra);
                return 1;
            }
            update.next = current = this.listeners;
        } while (!(registered = ___unsafe.compareAndSwapObject(this, listenersOffset, current, update)));
        if (version == this.version) {
            return 0;
        }
        while (!(removed = ___unsafe.compareAndSwapObject(this, listenersOffset, update = this.listeners, null))) {
        }
        if (update != null) {
            update.openAll(pool);
        }
        return 1;
    }

    public final boolean hasReadConflict(Tranlocal tranlocal) {
        if (tranlocal.lockMode != 0) {
            return false;
        }
        if (this.hasExclusiveLock()) {
            return true;
        }
        return tranlocal.version != this.version;
    }

    protected final int arriveAndExclusiveLockOrBackoff() {
        int maxRetries = this.stm.defaultMaxRetries;
        int spinCount = this.stm.spinCount;
        for (int k = 0; k <= maxRetries; ++k) {
            int arriveStatus = this.arriveAndExclusiveLock(spinCount);
            if (arriveStatus != 0) {
                return arriveStatus;
            }
            this.stm.defaultBackoffPolicy.delayUninterruptible(k + 1);
        }
        return 0;
    }
}

