#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 JuicyPixels
version:              3.3.9
visibility:           public
id:                   JuicyPixels-3.3.9-BkJ3hrjFWCxL5bxkwbN20o
key:                  JuicyPixels-3.3.9-BkJ3hrjFWCxL5bxkwbN20o
license:              BSD-3-Clause
maintainer:           vincent.berthoux@gmail.com
author:               Vincent Berthoux
stability:            Stable
homepage:             https://github.com/Twinside/Juicy.Pixels
synopsis:
    Picture loading/serialization (in png, jpeg, bitmap, gif, tga, tiff and radiance)

description:
    <<data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAMAAAADABAMAAACg8nE0AAAAElBMVEUAAABJqDSTWEL/qyb///8AAABH/1GTAAAAAXRSTlMAQObYZgAAAN5JREFUeF7s1sEJgFAQxFBbsAV72v5bEVYWPwT/XDxmCsi7zvHXavYREBDI3XP2GgICqBBYuwIC+/rVayPUAyAg0HvIXBcQoDFDGnUBgWQQ2Bx3AYFaRoBpAQHWb3bt2ARgGAiCYFFuwf3X5HA/McgGJWI2FdykCv4aBYzmKwDwvl6NVmUAAK2vlwEALK7fo88GANB6HQsAAAAAAAAA7P94AQCzswEAAAAAAAAAAAAAAAAAAICzh4UAO4zWAYBfRutHA4Bn5C69JhowAMGoBaMWDG0wCkbBKBgFo2AUAACPmegUST/IJAAAAABJRU5ErkJggg==>>

    This library can load and store images in PNG,Bitmap, Jpeg, Radiance, Tiff and Gif images.

category:             Codec, Graphics, Image
abi:                  c7c5ccc28bd66cfa6676fc18b1ff79e8
exposed:              True
exposed-modules:
    Codec.Picture Codec.Picture.Bitmap Codec.Picture.ColorQuant
    Codec.Picture.Gif Codec.Picture.Gif.Internal.LZW
    Codec.Picture.Gif.Internal.LZWEncoding Codec.Picture.HDR
    Codec.Picture.Jpg Codec.Picture.Jpg.Internal.Common
    Codec.Picture.Jpg.Internal.DefaultTable
    Codec.Picture.Jpg.Internal.FastDct
    Codec.Picture.Jpg.Internal.FastIdct
    Codec.Picture.Jpg.Internal.Metadata
    Codec.Picture.Jpg.Internal.Progressive
    Codec.Picture.Jpg.Internal.Types Codec.Picture.Metadata
    Codec.Picture.Metadata.Exif Codec.Picture.Png
    Codec.Picture.Png.Internal.Export
    Codec.Picture.Png.Internal.Metadata Codec.Picture.Png.Internal.Type
    Codec.Picture.Saving Codec.Picture.Tga Codec.Picture.Tiff
    Codec.Picture.Tiff.Internal.Metadata
    Codec.Picture.Tiff.Internal.Types Codec.Picture.Types

hidden-modules:
    Codec.Picture.BitWriter Codec.Picture.InternalHelper
    Codec.Picture.VectorByteConversion

import-dirs:          /usr/lib/ghc-9.4.8/site-local/JuicyPixels-3.3.9
library-dirs:         /usr/lib/ghc-9.4.8/site-local/JuicyPixels-3.3.9
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/JuicyPixels-3.3.9
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-juicypixels
hs-libraries:         HSJuicyPixels-3.3.9-BkJ3hrjFWCxL5bxkwbN20o
include-dirs:         /usr/lib/ghc-9.4.8/site-local/JuicyPixels-3.3.9/include
depends:
    base-4.17.2.1 binary-0.8.9.1 bytestring-0.11.5.3 containers-0.6.7
    deepseq-1.4.8.0 mtl-2.2.2 primitive-0.9.1.0-2xanABVx1x5I4qjrdAPB07
    transformers-0.5.6.2 vector-0.13.2.0-EKABDCAVgb42yYEtp4rYAX
    zlib-0.7.0.0-9LTVaTQCVSRLjipNGe0Z99

haddock-interfaces:   /usr/share/doc/haskell-juicypixels/html/JuicyPixels.haddock
haddock-html:         /usr/share/doc/haskell-juicypixels/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

