/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.FxmlPresenceListener;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.packaging.JavaFxApplicationArtifactType;

public final class JavaFxModuleUtil {
    public static boolean isInJavaFxProject(@NotNull PsiFile file) {
        Project project;
        if (file == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(0);
        }
        if (JavaFxModuleUtil.hasJavaFxArtifacts(project = file.getProject())) {
            return true;
        }
        return JavaFxModuleUtil.isInJavaFxModule(file);
    }

    private static boolean isInJavaFxModule(@NotNull PsiFile file) {
        Project project;
        Module fileModule;
        VirtualFile virtualFile;
        if (file == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(1);
        }
        if ((virtualFile = file.getVirtualFile()) != null && (fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)(project = file.getProject()))) != null) {
            return JavaFxModuleUtil.getCachedJavaFxModules(project).contains(fileModule);
        }
        return false;
    }

    @NotNull
    static Set<Module> getCachedJavaFxModules(@NotNull Project project) {
        if (project == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(2);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            HashSet modules = new HashSet();
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
            FileTypeIndex.processFiles((FileType)JavaFxFileTypeFactory.getFileType(), file -> {
                if (JavaFxFileTypeFactory.isFxml(file)) {
                    modules.add(projectFileIndex.getModuleForFile(file));
                }
                return true;
            }, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
            return CachedValueProvider.Result.create(modules, (Object[])new Object[]{FxmlPresenceListener.getModificationTracker(project)});
        });
        if (set == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(3);
        }
        return set;
    }

    static boolean hasJavaFxArtifacts(@NotNull Project project) {
        if (project == null) {
            JavaFxModuleUtil.$$$reportNull$$$0(4);
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
            Collection artifacts = artifactManager.getArtifactsByType((ArtifactType)JavaFxApplicationArtifactType.getInstance());
            return CachedValueProvider.Result.create((Object)(!artifacts.isEmpty() ? 1 : 0), (Object[])new Object[]{artifactManager.getModificationTracker()});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/JavaFxModuleUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedJavaFxModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInJavaFxProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInJavaFxModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCachedJavaFxModules";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasJavaFxArtifacts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

