/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter implements a zero-crossing based edge detector.


The zero-crossing based edge detector looks for pixels in the
Laplacian of an image where the value of the Laplacian passes through
zero points where the Laplacian changes sign. Such points often occur
at "edges" in images i.e. points where the intensity of the image
changes rapidly, but they also occur at places that are not as easy to
associate with edges. It is best to think of the zero crossing
detector as some sort of feature detector rather than as a specific
edge detector.


Zero crossings always lie on closed contours and so the output from
the zero crossing detector is usually a binary image with single pixel
thickness lines showing the positions of the zero crossing points.

In this implementation, the input image is first smoothed with a
Gaussian filter, then the LaplacianImageFilter is applied to smoothed image. Finally the zero-crossing of the
Laplacian of the smoothed image is detected. The output is a binary
image.
Inputs and Outputs
The input to the filter should be a scalar, itk::Image of arbitrary dimension. The output image is a binary, labeled image.
See itkZeroCrossingImageFilter for more information on requirements of
the data type of the output.

To use this filter, first set the parameters (variance and maximum
error) needed by the embedded DiscreteGaussianImageFilter , i.e. See DiscreteGaussianImageFilter for information about these parameters. Optionally, you may also set
foreground and background values for the zero-crossing filter. The
default label values are Zero for the background and One for the
foreground, as defined in NumericTraits for the data type of the output image.

See:
 DiscreteGaussianImageFilter

 LaplacianImageFilter

 ZeroCrossingImageFilter

 itk::simple::ZeroCrossingBasedEdgeDetection for the procedural interface

 itk::ZeroCrossingBasedEdgeDetectionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkZeroCrossingBasedEdgeDetectionImageFilter.h
*/
public class ZeroCrossingBasedEdgeDetectionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ZeroCrossingBasedEdgeDetectionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ZeroCrossingBasedEdgeDetectionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ZeroCrossingBasedEdgeDetectionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::~ZeroCrossingBasedEdgeDetectionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ZeroCrossingBasedEdgeDetectionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::ZeroCrossingBasedEdgeDetectionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ZeroCrossingBasedEdgeDetectionImageFilter() {
    this(SimpleITKJNI.new_ZeroCrossingBasedEdgeDetectionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::SetVariance(double Variance)

Set the variance parameter needed by the embedded gaussian filter

*/
public  void setVariance(double Variance) {
    SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_setVariance(swigCPtr, this, Variance);
  }

  /**
double itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::GetVariance() const

Standard get/set macros for Gaussian filter parameters.

*/
public  double getVariance() {
    return SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_getVariance(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::SetForegroundValue(uint8_t ForegroundValue)

Get/Set the label values for the ZeroCrossingImageFilter

*/
public  void setForegroundValue(short ForegroundValue) {
    SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
uint8_t itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::GetForegroundValue() const

Get/Set the label values for the ZeroCrossingImageFilter

*/
public  short getForegroundValue() {
    return SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::SetBackgroundValue(uint8_t BackgroundValue)

Get/Set the label values for the ZeroCrossingImageFilter

*/
public  void setBackgroundValue(short BackgroundValue) {
    SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
uint8_t itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::GetBackgroundValue() const

Get/Set the label values for the ZeroCrossingImageFilter

*/
public  short getBackgroundValue() {
    return SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::SetMaximumError(double MaximumError)

Set the MaximumError parameter needed by the embedded gaussian filter
This value is used to set the desired maximum error of the gaussian
approximation. Maximum error is the difference between the area under
the discrete Gaussian curve and the area under the continuous
Gaussian. Maximum error affects the Gaussian operator size. The value
must be between 0.0 and 1.0.

*/
public  void setMaximumError(double MaximumError) {
    SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_setMaximumError(swigCPtr, this, MaximumError);
  }

  /**
double itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::GetMaximumError() const

Standard get/set macros for Gaussian filter parameters.

*/
public  double getMaximumError() {
    return SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_getMaximumError(swigCPtr, this);
  }

  /**
std::string itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ZeroCrossingBasedEdgeDetectionImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ZeroCrossingBasedEdgeDetectionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
