/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javajs.util.Rdr;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jme.JMEmol;
import jme.MultiBox;
import jme.QueryBox;

public class JME
extends JPanel
implements MouseListener,
KeyListener,
MouseMotionListener {
    public JFrame myFrame;
    Point aboutBoxPoint = new Point(500, 10);
    Point smilesBoxPoint = new Point(200, 50);
    Point atomxBoxPoint = new Point(150, 420);
    JTextField atomicSymbol = new JTextField("H");
    int action;
    int active_an;
    protected boolean application = false;
    static final String separator = "\n";
    static final String version = "2023.01";
    protected String infoText = "JME Molecular Editor by Peter Ertl";
    int sd = 24;
    int arrowWidth = 48;
    static Color bgColor = Color.lightGray;
    static Color brightColor = bgColor.brighter();
    Font font;
    Font fontBold;
    Font fontSmall;
    FontMetrics fontMet;
    FontMetrics fontBoldMet;
    FontMetrics fontSmallMet;
    int fontSize;
    protected boolean bwMode = false;
    protected boolean runsmi = false;
    String depictcgi = null;
    String depictservlet = null;
    protected boolean canonize = true;
    protected boolean stereo = true;
    protected boolean multipart = false;
    protected boolean xButton = true;
    protected boolean rButton = false;
    protected boolean showHydrogens = true;
    protected boolean query = false;
    protected boolean reaction = false;
    protected boolean autoez = false;
    protected boolean writesmi = false;
    protected boolean writemi = false;
    protected boolean writemol = false;
    protected boolean number = false;
    protected boolean star = false;
    protected boolean autonumber = false;
    protected boolean jmeh = false;
    protected boolean depict = false;
    protected boolean depictBorder = false;
    protected boolean keepHydrogens = true;
    Color canvasBg = Color.white;
    String atomColors = null;
    String atomBgColors = null;
    double depictScale = 1.0;
    protected boolean nocenter = false;
    protected boolean polarnitro = false;
    protected boolean showAtomNumbers = false;
    static final Color[] color = new Color[23];
    static final String[] zlabel = new String[23];
    String smiles = null;
    String jmeString = null;
    String molString = null;
    Dimension dimension;
    BufferedImage topMenu;
    BufferedImage leftMenu;
    BufferedImage infoArea;
    BufferedImage molecularArea;
    protected boolean doMenu = true;
    protected boolean movePossible;
    static final int ACTIONX = 12;
    static int ACTIONA = 10;
    static final int ACTION_DELETE = 104;
    static final int ACTION_MARK = 105;
    static final int ACTION_DELGROUP = 106;
    static final int ACTION_SMI = 101;
    static final int ACTION_END = 111;
    static final int ACTION_QRY = 107;
    static final int ACTION_UNDO = 110;
    static final int ACTION_REACP = 109;
    static final int ACTION_CLEAR = 102;
    static final int ACTION_NEW = 103;
    static final int ACTION_JME = 112;
    static final int ACTION_PGUP = 151;
    static final int ACTION_PGDN = 152;
    static final int ACTION_ROT90 = 156;
    static final int ACTION_CHARGE_PLUS = 157;
    static final int ACTION_CHARGE_MINUS = 158;
    static final int ACTION_CHARGE = 108;
    static final int ACTION_STEREO = 201;
    static final int ACTION_BOND_SINGLE = 202;
    static final int ACTION_BOND_DOUBLE = 203;
    static final int ACTION_BOND_TRIPLE = 204;
    static final int ACTION_CHAIN = 205;
    static final int ACTION_RING_3 = 206;
    static final int ACTION_RING_4 = 207;
    static final int ACTION_RING_5 = 208;
    static final int ACTION_RING_PH = 209;
    static final int ACTION_RING_6 = 210;
    static final int ACTION_RING_7 = 211;
    static final int ACTION_RING_8 = 212;
    static final int ACTION_RING_FURANE = 221;
    static final int ACTION_RING_3FURYL = 223;
    static final int ACTION_RING_9 = 229;
    static final int ACTION_TEMPLATE = 230;
    static final int ACTION_GROUP_TBU = 233;
    static final int ACTION_GROUP_NITRO = 234;
    static final int ACTION_GROUP_COO = 235;
    static final int ACTION_GROUP_CF3 = 236;
    static final int ACTION_GROUP_CCL3 = 237;
    static final int ACTION_GROUP_CC = 238;
    static final int ACTION_GROUP_SULFO = 239;
    static final int ACTION_GROUP_COOME = 240;
    static final int ACTION_GROUP_OCOME = 241;
    static final int ACTION_GROUP_CYANO = 242;
    static final int ACTION_GROUP_NME2 = 243;
    static final int ACTION_GROUP_NHSO2ME = 244;
    static final int ACTION_GROUP_CCC = 245;
    static final int ACTION_GROUP_C2 = 246;
    static final int ACTION_GROUP_C3 = 247;
    static final int ACTION_GROUP_C4 = 248;
    static final int ACTION_GROUP_COH = 249;
    static final int ACTION_GROUP_dO = 250;
    static final int ACTION_GROUP_PO3H2 = 251;
    static final int ACTION_GROUP_SO2NH2 = 252;
    static final int ACTION_GROUP_TEMPLATE = 253;
    static final int ACTION_GROUP_CF = 254;
    static final int ACTION_GROUP_CL = 255;
    static final int ACTION_GROUP_CB = 256;
    static final int ACTION_GROUP_CI = 257;
    static final int ACTION_GROUP_CN = 258;
    static final int ACTION_GROUP_CO = 259;
    static final int ACTION_GROUP_MAX = 260;
    static final int ACTION_AN_C = 301;
    static final int ACTION_AN_N = 401;
    static final int ACTION_AN_O = 501;
    static final int ACTION_AN_S = 601;
    static final int ACTION_AN_F = 701;
    static final int ACTION_AN_CL = 801;
    static final int ACTION_AN_BR = 901;
    static final int ACTION_AN_I = 1001;
    static final int ACTION_AN_P = 1101;
    static final int ACTION_AN_X = 1201;
    static final int ACTION_AN_H = 1300;
    static final int ACTION_AN_R = 1301;
    static final int ACTION_AN_R1 = 1302;
    static final int ACTION_AN_R2 = 1303;
    static final int ACTION_AN_R3 = 1304;
    static final int AN_H = 1;
    static final int AN_B = 2;
    static final int AN_C = 3;
    static final int AN_N = 4;
    static final int AN_O = 5;
    static final int AN_SI = 6;
    static final int AN_P = 7;
    static final int AN_S = 8;
    static final int AN_F = 9;
    static final int AN_CL = 10;
    static final int AN_BR = 11;
    static final int AN_I = 12;
    static final int AN_SE = 13;
    static final int AN_X = 18;
    static final int AN_R = 19;
    static final int AN_R1 = 20;
    static final int AN_R2 = 21;
    static final int AN_R3 = 22;
    int lastAction = 0;
    static final int LA_BOND = 1;
    static final int LA_RING = 2;
    static final int LA_GROUP = 3;
    static final int LA_MOVE = 5;
    static final int LA_FAILED = 9;
    protected boolean newMolecule = false;
    int xold;
    int yold;
    protected boolean afterClear = false;
    protected boolean mouseShift = false;
    MultiBox smilesBox = null;
    MultiBox atomxBox = null;
    MultiBox aboutBox = null;
    QueryBox queryBox;
    Point point = new Point(20, 200);
    JButton c;
    JButton n;
    JButton o;
    JButton s;
    JButton p;
    JButton f;
    JButton cl;
    JButton br;
    JButton i;
    JButton any;
    JButton anyec;
    JButton halogen;
    JButton aromatic;
    JButton nonaromatic;
    JButton ring;
    JButton nonring;
    JButton anyBond;
    JButton aromaticBond;
    JButton ringBond;
    JButton nonringBond;
    JButton sdBond;
    JComboBox<String> choiced;
    JComboBox<String> choiceh;
    protected boolean dyMode = true;
    String molText = null;
    public JMEmol mol;
    public int nmols = 0;
    int actualMolecule = 0;
    int saved = 0;
    String template = null;
    JMEmol tmol = null;
    protected JMEmol[] mols = new JMEmol[99];
    JMEmol smol;
    Color[] psColor = new Color[7];
    List<JMEmol> molStack = new ArrayList<JMEmol>();
    int stackPointer = -1;
    protected boolean doTags = false;
    protected boolean webme = false;
    public int[] apointx;
    public int[] apointy;
    public int[] bpointx;
    public int[] bpointy;
    protected boolean revertStereo = false;
    protected boolean relativeStereo = false;
    protected boolean allHs = false;
    protected boolean markUsed = true;
    int currentMark = 1;
    Image infoImage;
    Image clearImage;
    Image deleteImage;
    Image deleterImage;
    Image chargeImage;
    Image templatesImage;
    Image rtemplatesImage;
    Image undoImage;
    Image endImage;
    Image smiImage;
    Image smitImage;
    Image smartsImage;
    Image stereoImage;
    Image stereoxImage;
    protected boolean embedded;

    public JME() {
        this((JFrame)null, true);
    }

    public JME(JFrame frame, boolean embedded) {
        if (frame != null) {
            this.setFrame(frame);
        }
        this.embedded = embedded;
        this.mol = new JMEmol(this);
        this.psColor[0] = Color.gray;
        this.psColor[1] = new Color(255, 153, 153);
        this.psColor[2] = new Color(255, 204, 102);
        this.psColor[3] = new Color(255, 255, 153);
        this.psColor[4] = new Color(102, 255, 255);
        this.psColor[5] = new Color(51, 204, 255);
        this.psColor[6] = new Color(255, 153, 255);
        this.initialize();
        this.start();
    }

    public void setFrame(JFrame frame) {
        this.myFrame = frame;
        frame.add("Center", this);
        frame.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.application = true;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("JME 2D Molecular Editor");
        frame.setDefaultCloseOperation(3);
        JME jme = new JME(frame, false);
        int w = 432;
        int h = 384;
        frame.setBounds(300, 200, w, h);
        if (args.length == 1) {
            jme.options(args[0]);
        }
        frame.setVisible(true);
        String fileName = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-embedded".equals(args[i])) {
                jme.embedded = true;
                continue;
            }
            if ("-s".equals(args[i])) continue;
            if (args[i].startsWith("-f")) {
                fileName = args[++i];
                continue;
            }
            if (!args[i].startsWith("-o")) continue;
            jme.options(args[++i]);
        }
        if (fileName != null) {
            jme.dimension = jme.getSize();
            try {
                jme.readMolecule(Rdr.streamToString(new FileInputStream(fileName)));
            }
            catch (IOException e) {
                System.err.println("File " + fileName + " could not be read");
            }
        }
    }

    public Color getColor() {
        return bgColor;
    }

    public void activateQuery() {
        if (this.action != 107) {
            this.action = 107;
            this.repaint();
        }
    }

    protected void initialize() {
        this.dimension = this.getSize();
        this.setLayout(null);
        this.fontSize = 12;
        if (this.font == null) {
            this.font = new Font("Helvetica", 0, this.fontSize);
            this.fontMet = this.getFontMetrics(this.font);
        }
        if (this.fontBold == null) {
            this.fontBold = new Font("Helvetica", 1, this.fontSize);
            this.fontBoldMet = this.getFontMetrics(this.fontBold);
        }
        int fs = this.fontSize;
        if (this.fontSmall == null) {
            this.fontSmall = new Font("Helvetica", 0, fs);
            this.fontSmallMet = this.getFontMetrics(this.fontSmall);
        }
        this.query = false;
        this.reaction = false;
        this.autoez = false;
        this.stereo = true;
        this.canonize = true;
        this.xButton = true;
        this.rButton = false;
        ACTIONA = 10;
        this.showHydrogens = true;
        this.action = 202;
        JME.atomicData();
        this.validate();
    }

    public void start() {
        this.dimension = this.getSize();
        if (this.jmeString != null) {
            this.readMolecule(this.jmeString);
        } else if (this.molString != null) {
            this.readMolFile(this.molString);
        }
    }

    public void stop() {
        if (this.smilesBox != null) {
            this.smilesBox.dispose();
        }
        if (this.atomxBox != null) {
            this.atomxBox.dispose();
        }
        if (this.aboutBox != null) {
            this.aboutBox.dispose();
        }
        if (this.queryBox != null) {
            this.queryBox.dispose();
        }
        this.mols = null;
    }

    public void ping() {
    }

    public String smiles() {
        String smiles = this.Smiles();
        this.repaint();
        return smiles;
    }

    public String nonisomericSmiles() {
        boolean originalStereo = this.stereo;
        this.stereo = false;
        String smiles = this.Smiles();
        this.stereo = originalStereo;
        this.repaint();
        return smiles;
    }

    String Smiles() {
        String s;
        if (this.reaction) {
            s = this.partSmiles(1) + ">" + this.partSmiles(2) + ">" + this.partSmiles(3);
        } else {
            s = this.partSmiles(0);
            if (s.length() > 0) {
                this.molStack.add(new JMEmol(this.mol));
                this.stackPointer = this.molStack.size() - 1;
            }
        }
        return s;
    }

    String partSmiles(int pp) {
        String s = "";
        for (int m = 1; m <= this.nmols; ++m) {
            String smiles;
            int p;
            if (pp > 0 && (p = this.mols[m].reactionPart()) != pp || (smiles = this.mols[m].createSmiles()).length() <= 0) continue;
            if (s.length() > 0) {
                s = s + ".";
            }
            s = s + smiles;
        }
        return s;
    }

    public void reset() {
        this.action = 202;
        this.newMolecule = false;
        this.nmols = 0;
        this.actualMolecule = 0;
        this.mol = new JMEmol(this);
        this.mol.maxMark = 0;
        this.molText = null;
        this.depictScale = 1.0;
        this.repaint();
    }

    public void clear() {
        this.action = 202;
        this.newMolecule = false;
        if (this.nmols == 0) {
            return;
        }
        this.mol.save();
        this.afterClear = true;
        for (int i = this.actualMolecule; i < this.nmols; ++i) {
            this.mols[i] = this.mols[i + 1];
        }
        --this.nmols;
        this.actualMolecule = this.nmols;
        if (this.nmols > 0) {
            this.mol = this.mols[this.actualMolecule];
        } else {
            this.mol = new JMEmol(this);
            this.mol.maxMark = 0;
        }
    }

    public String jmeFile() {
        String s = "";
        s = this.reaction ? this.partJme(1) + ">" + this.partJme(2) + ">" + this.partJme(3) : this.partJme(0);
        return s;
    }

    String partJme(int pp) {
        String s = "";
        for (int m = 1; m <= this.nmols; ++m) {
            String jme;
            int p;
            if (pp > 0 && (p = this.mols[m].reactionPart()) != pp || (jme = this.mols[m].createJME()).length() <= 0) continue;
            if (s.length() > 0) {
                s = s + "|";
            }
            s = s + jme;
        }
        return s;
    }

    int[][] getReactionParts() {
        int[][] part = new int[4][this.nmols + 1];
        for (int p = 1; p <= 3; ++p) {
            int np = 0;
            for (int m = 1; m <= this.nmols; ++m) {
                if (this.mols[m].reactionPart() != p) continue;
                part[p][++np] = m;
            }
            part[p][0] = np;
        }
        return part;
    }

    public void readMolecule(String molecule) {
        this.reset();
        int lastReactant = 0;
        int firstProduct = 0;
        StringTokenizer st = new StringTokenizer(molecule, "|>", true);
        boolean isReaction = molecule.indexOf(">") > -1;
        int rx = 1;
        int nt = st.countTokens();
        this.nmols = 0;
        for (int i = 1; i <= nt; ++i) {
            String s = st.nextToken();
            s.trim();
            if (s.equals("|")) continue;
            if (s.equals(">")) {
                if (++rx == 2) {
                    lastReactant = this.nmols;
                    continue;
                }
                if (rx != 3) continue;
                firstProduct = this.nmols + 1;
                continue;
            }
            this.mol = new JMEmol(this, s, true);
            if (this.mol.natoms == 0) {
                this.info("ERROR - problems in reading/processing molecule !");
                System.err.println("ERROR while processing\n" + s);
                continue;
            }
            this.actualMolecule = ++this.nmols;
            this.mols[this.nmols] = this.mol;
            this.smol = null;
        }
        if (rx == 2) {
            firstProduct = lastReactant + 1;
            this.info("ERROR - strange reaction - fixing !");
            System.err.println("ERROR - reactant and product should be separated by >>\n");
        } else if (rx > 3) {
            this.info("ERROR - strange reaction !");
            System.err.println("ERROR - strange reaction !\n");
            return;
        }
        if (this.nmols > 1 && !isReaction) {
            this.options("multipart");
        }
        if (isReaction && !this.reaction) {
            this.options("reaction");
        }
        if (!isReaction && this.reaction) {
            this.options("noreaction");
        }
        if (!isReaction) {
            this.alignMolecules(1, this.nmols, 0);
        } else {
            this.alignMolecules(1, lastReactant, 1);
            this.alignMolecules(lastReactant + 1, firstProduct - 1, 2);
            this.alignMolecules(firstProduct, this.nmols, 3);
        }
        this.setMol(false);
        this.repaint();
    }

    public void setTemplate(String t, String name) {
        this.afterClear = false;
        this.tmol = new JMEmol(this, t, true);
        this.tmol.complete();
        this.action = 253;
        this.info(name);
        this.repaint();
    }

    void alignMolecules(int m1, int m2, int part) {
        if (this.nocenter) {
            return;
        }
        int nm = m2 - m1 + 1;
        if (nm <= 0 || m1 > this.nmols || m2 > this.nmols) {
            return;
        }
        double[] center = new double[4];
        int RBOND = 25;
        double[] share = new double[99];
        double sumx = 0.0;
        double sumy = 0.0;
        double maxy = 0.0;
        for (int i = m1; i <= m2; ++i) {
            this.mols[i].centerPoint(center);
            sumx += center[2];
            sumy += center[3];
            if (center[3] > maxy) {
                maxy = center[3];
            }
            share[i] = center[2];
            if (part != 2) continue;
            share[i] = center[3];
        }
        if (this.depict) {
            sumx += (double)(RBOND * (nm + 1));
            sumy += (double)(RBOND * (nm + 1));
            maxy += (double)RBOND;
        }
        if (this.dimension.width == 0 || this.dimension.height == 0) {
            this.dimension = this.getSize();
        }
        if (this.dimension.width == 0) {
            this.dimension.width = 400;
        }
        if (this.dimension.height == 0) {
            this.dimension.height = 300;
        }
        double scalex = 1.0;
        double scaley = 1.0;
        int xsize = this.dimension.width;
        int ysize = this.dimension.height;
        if (!this.depict) {
            xsize -= this.sd;
            ysize -= 3 * this.sd;
        }
        if (part == 1 || part == 3) {
            xsize = (xsize - this.arrowWidth) / 2;
        } else if (part == 2) {
            ysize /= 2;
        }
        if (sumx >= (double)xsize) {
            scalex = (double)xsize / sumx;
        }
        if (maxy >= (double)ysize) {
            scaley = (double)ysize / maxy;
        }
        double medzera = 0.0;
        if (this.depict) {
            this.depictScale = Math.min(scalex, scaley);
            medzera = (double)(RBOND * xsize) / sumx;
            if (part == 2) {
                medzera = (double)(RBOND * ysize) / sumy;
            }
        }
        for (int i = m1; i <= m2; ++i) {
            share[i] = part == 2 ? share[i] * (double)ysize / sumy : share[i] * (double)xsize / sumx;
        }
        double shiftx = (double)(-xsize) / 2.0;
        double shifty = 0.0;
        if (part == 1) {
            shiftx = (double)(-xsize) - (double)this.arrowWidth / 2.0;
        } else if (part == 3) {
            shiftx = (double)this.arrowWidth / 2.0;
        } else if (part == 2) {
            shiftx = 0.0;
            shifty = -ysize;
        }
        for (int i = m1; i <= m2; ++i) {
            int a;
            if (this.depict) {
                a = 1;
                while (a <= this.mols[i].natoms) {
                    int n = a;
                    this.mols[i].x[n] = this.mols[i].x[n] * this.depictScale;
                    int n2 = a++;
                    this.mols[i].y[n2] = this.mols[i].y[n2] * this.depictScale;
                }
                this.mols[i].center();
            }
            if (part == 2) {
                shifty += share[i] / 2.0 + medzera;
            } else {
                shiftx += share[i] / 2.0 + medzera;
            }
            a = 1;
            while (a <= this.mols[i].natoms) {
                int n = a;
                this.mols[i].x[n] = this.mols[i].x[n] + shiftx;
                int n3 = a++;
                this.mols[i].y[n3] = this.mols[i].y[n3] + shifty;
            }
            if (part == 2) {
                shifty += share[i] / 2.0;
            } else {
                shiftx += share[i] / 2.0;
            }
            if (this.depict) continue;
            this.mols[i].findBondCenters();
        }
    }

    public String molFile() {
        String s = "";
        if (this.reaction) {
            int i;
            int[][] part = this.getReactionParts();
            s = s + "$RXN\n\n\nJME Molecular Editor\n";
            s = s + JMEmol.iformat(part[1][0], 3) + JMEmol.iformat(part[3][0], 3) + separator;
            for (i = 1; i <= part[1][0]; ++i) {
                s = s + "$MOL\n" + this.mols[part[1][i]].createMolFile(this.smiles);
            }
            for (i = 1; i <= part[3][0]; ++i) {
                s = s + "$MOL\n" + this.mols[part[3][i]].createMolFile(this.smiles);
            }
        } else {
            if (this.nmols > 1) {
                this.mol = new JMEmol(this, this.mols, this.nmols);
            }
            if (this.mol.natoms > 0) {
                s = this.mol.createMolFile("");
            }
            if (this.nmols > 1) {
                this.mol = this.mols[this.actualMolecule];
            }
        }
        return s;
    }

    public void readMolFile(String s) {
        this.reset();
        if (s.startsWith("$RXN")) {
            this.reaction = true;
            this.multipart = true;
            String separator = JMEmol.findSeparator(s);
            StringTokenizer st = new StringTokenizer(s, separator, true);
            String line = "";
            for (int i = 1; i <= 5; ++i) {
                line = JMEmol.nextData(st, separator);
            }
            int nr = Integer.valueOf(line.substring(0, 3).trim());
            int np = Integer.valueOf(line.substring(3, 6).trim());
            JMEmol.nextData(st, separator);
            for (int p = 1; p <= nr + np; ++p) {
                String ns;
                String m = "";
                while ((ns = JMEmol.nextData(st, separator)) != null && !ns.equals("$MOL")) {
                    m = m + ns + separator;
                }
                this.mols[++this.nmols] = new JMEmol(this, m);
            }
            this.alignMolecules(1, nr, 1);
            this.alignMolecules(nr + 1, nr + np, 3);
        } else {
            this.reaction = false;
            this.mol = new JMEmol(this, s);
            this.setMol(true);
        }
        this.repaint();
    }

    protected boolean setMol(boolean checkMultipart) {
        if (this.mol == null || this.mol.natoms == 0) {
            return true;
        }
        if (this.atomBgColors != null && this.mol != null) {
            this.mol.setAtomColors(this.atomBgColors, true);
        }
        if (this.atomColors != null && this.mol != null) {
            this.mol.setAtomColors(this.atomColors, false);
        }
        if (!checkMultipart) {
            return false;
        }
        int nparts = this.mol.checkMultipart(false);
        if (nparts == 1) {
            this.mols[++this.nmols] = this.mol;
        } else {
            this.multipart = true;
            for (int p = 1; p <= nparts; ++p) {
                this.mols[++this.nmols] = new JMEmol(this, this.mol, p);
            }
        }
        this.actualMolecule = 1;
        this.mol = this.mols[this.actualMolecule];
        this.smol = null;
        this.alignMolecules(1, nparts, 0);
        return true;
    }

    public void setSubstituent(String s) {
        int pressed = -1;
        if (s.equals("Select substituent")) {
            pressed = 202;
            s = "";
        } else if (s.equals("-C(=O)OH")) {
            pressed = 235;
        } else if (s.equals("-C(=O)OMe")) {
            pressed = 240;
        } else if (s.equals("-OC(=O)Me")) {
            pressed = 241;
        } else if (s.equals("-CMe3")) {
            pressed = 233;
        } else if (s.equals("-CF3")) {
            pressed = 236;
        } else if (s.equals("-CCl3")) {
            pressed = 237;
        } else if (s.equals("-NO2")) {
            pressed = 234;
        } else if (s.equals("-NMe2")) {
            pressed = 243;
        } else if (s.equals("-SO2-NH2")) {
            pressed = 252;
        } else if (s.equals("-NH-SO2-Me")) {
            pressed = 244;
        } else if (s.equals("-SO3H")) {
            pressed = 239;
        } else if (s.equals("-PO3H2")) {
            pressed = 251;
        } else if (s.equals("-C#N")) {
            pressed = 242;
        } else if (s.equals("-C#C-Me")) {
            pressed = 245;
        } else if (s.equals("-C#CH")) {
            pressed = 238;
        }
        if (pressed > 0) {
            this.menuAction(pressed);
        } else {
            s = "Not known group!";
        }
        this.info(s);
        this.repaint();
    }

    public void options(String parameters) {
        if ((parameters = parameters.toLowerCase()).indexOf("norbutton") > -1) {
            this.rButton = false;
        } else if (parameters.indexOf("rbutton") > -1) {
            this.rButton = true;
        }
        if (parameters.indexOf("nohydrogens") > -1) {
            this.showHydrogens = false;
        } else if (parameters.indexOf("hydrogens") > -1) {
            this.showHydrogens = true;
        }
        if (parameters.indexOf("keephs") > -1) {
            this.keepHydrogens = true;
        }
        if (parameters.indexOf("removehs") > -1) {
            this.keepHydrogens = false;
        }
        if (parameters.indexOf("noquery") > -1) {
            this.query = false;
        } else if (parameters.indexOf("query") > -1) {
            this.query = true;
        }
        if (parameters.indexOf("noreaction") > -1) {
            this.reaction = false;
        } else if (parameters.indexOf("reaction") > -1) {
            this.reaction = true;
        }
        if (parameters.indexOf("noautoez") > -1) {
            this.autoez = false;
        } else if (parameters.indexOf("autoez") > -1) {
            this.autoez = true;
        }
        if (parameters.indexOf("nostereo") > -1) {
            this.stereo = false;
        } else if (parameters.indexOf("stereo") > -1) {
            this.stereo = true;
        }
        if (parameters.indexOf("nocanonize") > -1) {
            this.canonize = false;
        } else if (parameters.indexOf("canonize") > -1) {
            this.canonize = true;
        }
        if (parameters.indexOf("nomultipart") > -1) {
            this.multipart = false;
        } else if (parameters.indexOf("multipart") > -1) {
            this.multipart = true;
        }
        if (parameters.indexOf("nonumber") > -1) {
            this.number = false;
            this.autonumber = false;
        } else if (parameters.indexOf("number") > -1) {
            this.number = true;
            this.autonumber = false;
        }
        if (parameters.indexOf("autonumber") > -1) {
            this.autonumber = true;
            this.number = true;
        }
        if (parameters.indexOf("star") > -1) {
            this.star = true;
            this.number = true;
        }
        if (parameters.indexOf("polarnitro") > -1) {
            this.polarnitro = true;
        }
        if (parameters.indexOf("depict") > -1) {
            this.depict = true;
            this.sd = 0;
            this.molecularArea = null;
            this.alignMolecules(1, this.nmols, 0);
        }
        if (parameters.indexOf("nodepict") > -1) {
            this.depict = false;
            for (int i = 1; i <= this.nmols; ++i) {
                this.mols[i].scaling();
                this.mols[i].center();
            }
            this.depictScale = 1.0;
            this.sd = 24;
            if (this.mol != null) {
                this.mol.needRecentering = true;
            }
        }
        if (parameters.indexOf("border") > -1) {
            this.depictBorder = true;
        }
        if (parameters.indexOf("writesmi") > -1) {
            this.writesmi = true;
        }
        if (parameters.indexOf("writemi") > -1) {
            this.writemi = true;
        }
        if (parameters.indexOf("writemol") > -1) {
            this.writemol = true;
        }
        if (parameters.indexOf("nocenter") > -1) {
            this.nocenter = true;
        }
        if (parameters.indexOf("jmeh") > -1) {
            this.jmeh = true;
        }
        if (parameters.indexOf("showan") > -1) {
            this.showAtomNumbers = true;
        }
        if (this.reaction) {
            this.number = true;
            this.multipart = true;
        }
        if (!this.depict) {
            this.depictBorder = false;
        }
        if (this.rButton) {
            ++ACTIONA;
        }
        this.repaint();
    }

    public void setText(String text) {
        this.molText = text;
        this.repaint();
    }

    public void showAtomNumbers() {
        if (this.mol != null) {
            this.mol.numberAtoms();
        }
    }

    public boolean hasPrevious() {
        return this.molStack.size() != 0 && this.stackPointer != 0;
    }

    public void getPreviousMolecule() {
        this.getFromStack(-1);
    }

    void getFromStack(int n) {
        this.info("");
        this.clear();
        this.stackPointer += n;
        this.mol = new JMEmol(this.molStack.get(this.stackPointer));
        this.mol.complete();
        this.mol.center();
        this.nmols = 1;
        this.actualMolecule = 1;
        this.mols[1] = this.mol;
        this.repaint();
        this.smol = null;
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.dimension == null || d.width != this.dimension.width || d.height != this.dimension.height || this.molecularArea == null || this.infoArea == null) {
            this.dimension = d;
            int imagew = d.width - this.sd;
            int imageh = d.height - this.sd * 3;
            if (imagew < 1) {
                imagew = 1;
            }
            if (imageh < 1) {
                imageh = 1;
            }
            this.molecularArea = (BufferedImage)this.createImage(imagew, imageh);
            this.drawMolecularArea(g);
            if (this.depict) {
                return;
            }
            this.topMenu = (BufferedImage)this.createImage(d.width, this.sd * 2);
            this.drawTopMenu(g);
            imageh = d.height - this.sd * 2;
            if (imageh < 1) {
                imageh = 1;
            }
            this.leftMenu = (BufferedImage)this.createImage(this.sd, imageh);
            this.drawLeftMenu(g);
            this.infoArea = (BufferedImage)this.createImage(imagew, this.sd);
            this.drawInfo(g);
        } else {
            this.drawMolecularArea(g);
            if (this.depict) {
                return;
            }
            this.drawInfo(g);
            if (this.doMenu) {
                this.drawTopMenu(g);
                this.drawLeftMenu(g);
            }
            this.doMenu = true;
        }
    }

    static void atomicData() {
        for (int i = 0; i < 23; ++i) {
            JME.color[i] = Color.orange;
            JME.zlabel[i] = "X";
        }
        JME.zlabel[1] = "H";
        JME.color[1] = Color.darkGray;
        JME.zlabel[2] = "B";
        JME.color[2] = Color.orange;
        JME.zlabel[3] = "C";
        JME.color[3] = Color.darkGray;
        JME.zlabel[4] = "N";
        JME.color[4] = Color.blue;
        JME.zlabel[5] = "O";
        JME.color[5] = Color.red;
        JME.zlabel[9] = "F";
        JME.color[9] = Color.magenta;
        JME.zlabel[10] = "Cl";
        JME.color[10] = Color.magenta;
        JME.zlabel[11] = "Br";
        JME.color[11] = Color.magenta;
        JME.zlabel[12] = "I";
        JME.color[12] = Color.magenta;
        JME.zlabel[8] = "S";
        JME.color[8] = Color.yellow.darker();
        JME.zlabel[7] = "P";
        JME.color[7] = Color.orange;
        JME.zlabel[6] = "Si";
        JME.color[6] = Color.darkGray;
        JME.zlabel[13] = "Se";
        JME.color[13] = Color.darkGray;
        JME.zlabel[18] = "X";
        JME.color[18] = Color.darkGray;
        JME.zlabel[19] = "R";
        JME.color[19] = Color.darkGray;
        JME.zlabel[20] = "R1";
        JME.color[20] = Color.darkGray;
        JME.zlabel[21] = "R2";
        JME.color[21] = Color.darkGray;
        JME.zlabel[22] = "R3";
        JME.color[22] = Color.darkGray;
    }

    void drawMolecularArea(Graphics g) {
        this.paintMolecularArea(this.molecularArea);
        g.drawImage(this.molecularArea, this.sd, this.sd * 2, this);
    }

    protected void paintMolecularArea(BufferedImage img) {
        Graphics2D og = (Graphics2D)img.getGraphics();
        og.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        og.setColor(this.canvasBg);
        og.fillRect(0, 0, imgWidth, imgHeight);
        for (int m = 1; m <= this.nmols; ++m) {
            this.mols[m].draw(og);
        }
        if (!this.depict) {
            og.setColor(bgColor.darker());
            og.drawLine(imgWidth - 1, 0, imgWidth - 1, imgHeight - 1);
            og.setColor(bgColor);
            og.drawLine(imgWidth - 2, 0, imgWidth - 2, imgHeight - 1);
            og.setColor(brightColor);
            og.drawLine(imgWidth - 3, 0, imgWidth - 3, imgHeight - 1);
        }
        if (this.reaction) {
            int pWidth = this.arrowWidth;
            int pStart = (imgWidth - pWidth) / 2;
            int m = this.arrowWidth / 8;
            og.setColor(Color.magenta);
            og.drawLine(pStart, imgHeight / 2, pStart + pWidth, imgHeight / 2);
            og.drawLine(pStart + pWidth, imgHeight / 2, pStart + pWidth - m, imgHeight / 2 + m);
            og.drawLine(pStart + pWidth, imgHeight / 2, pStart + pWidth - m, imgHeight / 2 - m);
        }
        if (this.depict) {
            this.font = new Font("Helvetica", 0, this.fontSize);
            this.fontMet = this.getFontMetrics(this.font);
            if (this.molText != null) {
                int w = this.fontMet.stringWidth(this.molText);
                int xstart = (int)Math.round((double)(imgWidth - w) / 2.0);
                int ystart = imgHeight - this.fontSize;
                og.setColor(Color.black);
                og.setFont(this.font);
                og.drawString(this.molText, xstart, ystart);
            }
        }
    }

    void drawTopMenu(Graphics g) {
        Graphics og = this.topMenu.getGraphics();
        int imgWidth = this.dimension.width;
        int imgHeight = this.sd * 2;
        og.setColor(bgColor);
        og.fillRect(0, 0, imgWidth, imgHeight);
        og.setColor(bgColor.darker());
        og.drawLine(imgWidth - 1, 0, imgWidth - 1, imgHeight - 1);
        og.drawLine(0, imgHeight - 1, imgWidth - 1 - 2, imgHeight - 1);
        og.setColor(brightColor);
        og.drawLine(0, 0, imgWidth - 1, 0);
        og.drawLine(12 * this.sd, 0, 12 * this.sd, imgHeight - 1);
        for (int i = 1; i <= 12; ++i) {
            this.createSquare(og, i, 1);
            this.createSquare(og, i, 2);
        }
        g.drawImage(this.topMenu, 0, 0, this);
    }

    void drawLeftMenu(Graphics g) {
        Graphics og = this.leftMenu.getGraphics();
        int imgWidth = this.sd;
        int imgHeight = this.dimension.height - this.sd * 2;
        og.setColor(bgColor);
        og.fillRect(0, 0, imgWidth, imgHeight);
        og.setColor(brightColor);
        og.drawLine(0, 0, 0, imgHeight - 1);
        og.drawLine(0, ACTIONA * this.sd, imgHeight - 1, ACTIONA * this.sd);
        og.setColor(bgColor.darker());
        og.drawLine(imgWidth - 1, 0, imgWidth - 1, imgHeight - 1 - this.sd);
        og.drawLine(0, imgHeight - 1, imgWidth - 1, imgHeight - 1);
        for (int i = 3; i <= ACTIONA + 2; ++i) {
            this.createSquare(og, 1, i);
        }
        g.drawImage(this.leftMenu, 0, this.sd * 2, this);
    }

    void drawInfo(Graphics g) {
        Graphics og = this.infoArea.getGraphics();
        int imgWidth = this.dimension.width - this.sd;
        int imgHeight = this.sd;
        og.setColor(bgColor);
        og.fillRect(0, 0, imgWidth, imgHeight);
        og.setColor(brightColor);
        og.drawLine(0, 0, imgWidth - 1 - 2, 0);
        og.setColor(bgColor.darker());
        og.drawLine(0, imgHeight - 1, imgWidth - 1, imgHeight - 1);
        og.drawLine(imgWidth - 1, 0, imgWidth - 1, imgHeight - 1);
        og.setFont(this.fontSmall);
        og.setColor(Color.black);
        if (this.infoText.startsWith("E")) {
            og.setColor(Color.red);
        }
        og.drawString(this.infoText, 10, 15);
        g.drawImage(this.infoArea, this.sd, this.dimension.height - this.sd, this);
    }

    void menuAction(int pressed) {
        if (pressed == 0) {
            return;
        }
        int action_old = this.action;
        this.action = pressed;
        if (pressed <= 300) {
            switch (pressed) {
                case 102: {
                    this.clear();
                    break;
                }
                case 110: {
                    this.action = action_old;
                    if (this.smol == null) {
                        this.actualMolecule = this.nmols;
                        this.clear();
                    } else if (this.afterClear) {
                        this.saved = ++this.nmols;
                        this.actualMolecule = this.nmols;
                        this.afterClear = false;
                    }
                    if (this.smol == null) break;
                    this.mol = new JMEmol(this.smol);
                    this.mol.complete();
                    this.mols[this.saved] = this.mol;
                    break;
                }
                case 152: {
                    int ssize = this.molStack.size();
                    this.action = action_old;
                    if (ssize == 0) {
                        this.info("No molecules in molstack");
                        break;
                    }
                    if (this.stackPointer == 0) {
                        this.info("Bottom of molstack reached");
                        break;
                    }
                    this.getFromStack(-1);
                    break;
                }
                case 151: {
                    int ssize = this.molStack.size();
                    this.action = action_old;
                    if (ssize == 0) {
                        this.info("No molecules in molstack");
                        break;
                    }
                    if (this.stackPointer == ssize - 1) {
                        this.info("Top of molstack reached");
                        break;
                    }
                    this.getFromStack(1);
                    break;
                }
                case 101: {
                    if (this.smilesBox != null && this.smilesBox.isVisible()) {
                        this.smilesBoxPoint = this.smilesBox.getLocationOnScreen();
                        this.smilesBox.dispose();
                        this.smilesBox = null;
                    }
                    this.smilesBox = new MultiBox(1, this);
                    this.action = action_old;
                    break;
                }
                case 107: {
                    if (this.queryBox != null && this.queryBox.isVisible()) {
                        this.point = this.queryBox.getLocationOnScreen();
                        this.queryBox.dispose();
                        this.queryBox = null;
                    }
                    this.queryBox = new QueryBox(this);
                    break;
                }
                case 112: {
                    if (this.aboutBox != null && this.aboutBox.isVisible()) {
                        this.aboutBoxPoint = this.aboutBox.getLocationOnScreen();
                        this.aboutBox.dispose();
                        this.aboutBox = null;
                    }
                    this.aboutBox = new MultiBox(0, this);
                    this.action = action_old;
                    break;
                }
                case 103: {
                    this.newMolecule = true;
                    this.action = action_old;
                    break;
                }
                case 105: {
                    if (this.autonumber && this.mouseShift) {
                        this.mouseShift = false;
                        this.mol.numberAtoms();
                        this.action = action_old;
                    }
                    this.currentMark = 1;
                    break;
                }
                case 111: {
                    if (this.embedded) {
                        if (this.myFrame != null) {
                            this.myFrame.setVisible(false);
                        }
                        return;
                    }
                    System.exit(0);
                    break;
                }
                case 109: {
                    this.action = action_old;
                    int part = this.mol.reactionPart();
                    if (part == 2) {
                        this.info("Copying the agent not possible !");
                        break;
                    }
                    double[] center = new double[4];
                    this.mol.centerPoint(center);
                    this.mol = new JMEmol(this.mol);
                    int dx = (int)((double)((this.dimension.width - this.sd) / 2) - center[0]);
                    int i = 1;
                    while (i <= this.mol.natoms) {
                        int n = i++;
                        this.mol.x[n] = this.mol.x[n] + (double)(dx * 2);
                    }
                    this.mol.complete();
                    this.mols[++this.nmols] = this.mol;
                    this.actualMolecule = this.nmols;
                    break;
                }
                case 104: {
                    if (this.mol.touchedAtom > 0) {
                        this.mol.save();
                        this.mol.deleteAtom(this.mol.touchedAtom);
                        this.mol.touchedAtom = 0;
                    } else if (this.mol.touchedBond > 0) {
                        this.mol.save();
                        this.mol.deleteBond(this.mol.touchedBond);
                        this.mol.touchedBond = 0;
                    }
                    this.mol.valenceState();
                    break;
                }
            }
        } else {
            switch (pressed) {
                case 301: {
                    this.active_an = 3;
                    break;
                }
                case 401: {
                    this.active_an = 4;
                    break;
                }
                case 501: {
                    this.active_an = 5;
                    break;
                }
                case 701: {
                    this.active_an = 9;
                    break;
                }
                case 801: {
                    this.active_an = 10;
                    break;
                }
                case 901: {
                    this.active_an = 11;
                    break;
                }
                case 1001: {
                    this.active_an = 12;
                    break;
                }
                case 601: {
                    this.active_an = 8;
                    break;
                }
                case 1101: {
                    this.active_an = 7;
                    break;
                }
                case 1300: {
                    this.active_an = 1;
                    break;
                }
                case 1201: {
                    if (!this.webme) {
                        if (this.atomxBox != null && this.atomxBox.isVisible()) {
                            this.atomxBoxPoint = this.atomxBox.getLocationOnScreen();
                            this.atomxBox.dispose();
                            this.atomxBox = null;
                        }
                        if (this.mol.touchedAtom == 0) {
                            this.atomxBox = new MultiBox(2, this);
                        }
                    }
                    this.active_an = 18;
                    break;
                }
                case 1301: {
                    this.active_an = 19;
                    break;
                }
                case 1302: {
                    this.active_an = 20;
                    break;
                }
                case 1303: {
                    this.active_an = 21;
                    break;
                }
                case 1304: {
                    this.active_an = 22;
                }
            }
            if (this.mol.touchedAtom > 0) {
                if (this.active_an != this.mol.an[this.mol.touchedAtom] && this.active_an != 18) {
                    this.mol.save();
                    this.mol.an[this.mol.touchedAtom] = this.active_an;
                    this.mol.q[this.mol.touchedAtom] = 0;
                    this.mol.nh[this.mol.touchedAtom] = 0;
                }
                if (this.active_an == 18) {
                    String xx = this.atomicSymbol.getText();
                    this.mol.setAtom(this.mol.touchedAtom, xx);
                }
                this.mol.valenceState();
            }
        }
        this.repaint();
    }

    void createSquare(Graphics g, int xpos, int ypos) {
        int square = ypos * 100 + xpos;
        int xstart = (xpos - 1) * this.sd;
        int ystart = (ypos - 1) * this.sd;
        if (xpos == 1 && ypos > 2) {
            ystart -= 2 * this.sd;
        }
        g.setColor(bgColor);
        if (square == this.action) {
            g.fill3DRect(xstart + 1, ystart + 1, this.sd, this.sd, false);
        } else {
            g.fill3DRect(xstart, ystart, this.sd, this.sd, true);
        }
        if (square == 1301 && !this.rButton) {
            return;
        }
        if (square == 111 && !this.application) {
            return;
        }
        if (square == 107 && !this.query) {
            return;
        }
        if (square == 201 && !this.stereo) {
            return;
        }
        if (square == 103 && !this.multipart) {
            return;
        }
        if (square == 105 && !this.number && !this.autonumber) {
            return;
        }
        if (square == 109 && !this.reaction) {
            return;
        }
        int m = this.sd / 4;
        if (ypos < 3) {
            g.setColor(Color.black);
            switch (square) {
                case 101: {
                    if (!this.bwMode) {
                        g.setColor(Color.yellow);
                        g.fillOval(xstart + 3, ystart + 3, this.sd - 6, this.sd - 6);
                        g.setColor(Color.black);
                    }
                    g.drawOval(xstart + 3, ystart + 3, this.sd - 6, this.sd - 6);
                    g.drawArc(xstart + 6, ystart + 6, this.sd - 12, this.sd - 12, -35, -110);
                    g.fillRect(xstart + 9, ystart + 9, 2, 4);
                    g.fillRect(xstart + this.sd - 10, ystart + 9, 2, 4);
                    if (Math.random() < 0.04) {
                        g.setColor(Color.red);
                        g.fillRect(xstart + 10, ystart + 18, 4, 4);
                    }
                    if (!(Math.random() > 0.96)) break;
                    g.setColor(Color.yellow);
                    g.fillRect(xstart + this.sd - 10, ystart + 8, 2, 3);
                    break;
                }
                case 111: {
                    this.squareText(g, xstart, ystart, "END");
                    break;
                }
                case 107: {
                    g.setColor(Color.orange);
                    g.fillRect(xstart + 4, ystart + 4, this.sd - 8, this.sd - 8);
                    g.setColor(Color.black);
                    g.drawRect(xstart + 4, ystart + 4, this.sd - 8, this.sd - 8);
                    g.drawArc(xstart + 6, ystart + 6, this.sd - 11, this.sd - 12, -35, -110);
                    g.fillRect(xstart + 9, ystart + 9, 2, 4);
                    g.fillRect(xstart + this.sd - 10, ystart + 9, 2, 4);
                    break;
                }
                case 108: {
                    this.squareText(g, xstart, ystart, "+ /  ");
                    g.drawLine(xstart + 15, ystart + 13, xstart + 19, ystart + 13);
                    break;
                }
                case 110: {
                    g.drawArc(xstart + 6, ystart + 7, this.sd - 12, this.sd - 14, 270, 270);
                    g.drawLine(xstart + 6, ystart + 13, xstart + 3, ystart + 10);
                    g.drawLine(xstart + 6, ystart + 13, xstart + 9, ystart + 10);
                    break;
                }
                case 109: {
                    g.drawLine(xstart + m, ystart + this.sd / 2, xstart + this.sd - m, ystart + this.sd / 2);
                    g.drawLine(xstart + this.sd - m, ystart + this.sd / 2, xstart + this.sd - m * 3 / 2, ystart + this.sd / 2 + m / 2);
                    g.drawLine(xstart + this.sd - m, ystart + this.sd / 2, xstart + this.sd - m * 3 / 2, ystart + this.sd / 2 - m / 2);
                    break;
                }
                case 102: {
                    g.setColor(Color.white);
                    g.fillRect(xstart + 3, ystart + 5, this.sd - 7, this.sd - 11);
                    g.setColor(Color.black);
                    g.drawRect(xstart + 3, ystart + 5, this.sd - 7, this.sd - 11);
                    break;
                }
                case 103: {
                    g.setColor(bgColor);
                    if (this.newMolecule) {
                        g.fill3DRect(xstart + 1, ystart + 1, this.sd, this.sd, false);
                    }
                    g.setColor(Color.black);
                    this.squareText(g, xstart, ystart, "NEW");
                    break;
                }
                case 106: {
                    g.setColor(Color.red);
                    g.drawLine(xstart + 7, ystart + 7, xstart + this.sd - 7, ystart + this.sd - 7);
                    g.drawLine(xstart + 8, ystart + 7, xstart + this.sd - 6, ystart + this.sd - 7);
                    g.drawLine(xstart + 7, ystart + this.sd - 7, xstart + this.sd - 7, ystart + 7);
                    g.drawLine(xstart + 8, ystart + this.sd - 7, xstart + this.sd - 6, ystart + 7);
                    g.setColor(Color.black);
                    g.drawLine(xstart + m, ystart + this.sd / 2, xstart + 12, ystart + this.sd / 2);
                    this.squareText(g, xstart + 6, ystart, "R");
                    break;
                }
                case 104: {
                    g.setColor(Color.red);
                    g.drawLine(xstart + 7, ystart + 7, xstart + this.sd - 7, ystart + this.sd - 7);
                    g.drawLine(xstart + 8, ystart + 7, xstart + this.sd - 6, ystart + this.sd - 7);
                    g.drawLine(xstart + 7, ystart + this.sd - 7, xstart + this.sd - 7, ystart + 7);
                    g.drawLine(xstart + 8, ystart + this.sd - 7, xstart + this.sd - 6, ystart + 7);
                    g.setColor(Color.black);
                    break;
                }
                case 105: {
                    if (this.star) {
                        g.setColor(Color.cyan);
                        g.drawLine(xstart + 11, ystart + 5, xstart + 9, ystart + 9);
                        g.drawLine(xstart + 9, ystart + 9, xstart + 4, ystart + 9);
                        g.drawLine(xstart + 4, ystart + 9, xstart + 8, ystart + 12);
                        g.drawLine(xstart + 8, ystart + 12, xstart + 6, ystart + 18);
                        g.drawLine(xstart + 6, ystart + 18, xstart + 11, ystart + 15);
                        g.drawLine(xstart + 12, ystart + 5, xstart + 14, ystart + 9);
                        g.drawLine(xstart + 14, ystart + 9, xstart + 19, ystart + 9);
                        g.drawLine(xstart + 19, ystart + 9, xstart + 15, ystart + 12);
                        g.drawLine(xstart + 15, ystart + 12, xstart + 17, ystart + 18);
                        g.drawLine(xstart + 17, ystart + 18, xstart + 12, ystart + 15);
                        g.setColor(Color.black);
                        break;
                    }
                    this.squareText(g, xstart, ystart, "123");
                    break;
                }
                case 112: {
                    g.setColor(Color.blue);
                    g.fillRect(xstart + 4, ystart + 4, this.sd - 8, this.sd - 8);
                    g.setColor(Color.black);
                    g.drawRect(xstart + 4, ystart + 4, this.sd - 8, this.sd - 8);
                    this.squareTextBold(g, xstart + 1, ystart - 1, Color.white, "i");
                    break;
                }
                case 201: {
                    g.drawLine(xstart + m, ystart + this.sd / 2, xstart + this.sd - m, ystart + this.sd / 2 + 2);
                    g.drawLine(xstart + m, ystart + this.sd / 2, xstart + this.sd - m, ystart + this.sd / 2 - 2);
                    g.drawLine(xstart + this.sd - m, ystart + this.sd / 2 + 2, xstart + this.sd - m, ystart + this.sd / 2 - 2);
                    break;
                }
                case 202: {
                    g.drawLine(xstart + m, ystart + this.sd / 2, xstart + this.sd - m, ystart + this.sd / 2);
                    break;
                }
                case 203: {
                    g.drawLine(xstart + m, ystart + this.sd / 2 - 2, xstart + this.sd - m, ystart + this.sd / 2 - 2);
                    g.drawLine(xstart + m, ystart + this.sd / 2 + 2, xstart + this.sd - m, ystart + this.sd / 2 + 2);
                    break;
                }
                case 204: {
                    g.drawLine(xstart + m, ystart + this.sd / 2, xstart + this.sd - m, ystart + this.sd / 2);
                    g.drawLine(xstart + m, ystart + this.sd / 2 - 2, xstart + this.sd - m, ystart + this.sd / 2 - 2);
                    g.drawLine(xstart + m, ystart + this.sd / 2 + 2, xstart + this.sd - m, ystart + this.sd / 2 + 2);
                    break;
                }
                case 205: {
                    g.drawLine(xstart + m / 2, ystart + m * 2 + m / 3, xstart + m / 2 * 3, ystart + m * 2 - m / 3);
                    g.drawLine(xstart + m / 2 * 3, ystart + m * 2 - m / 3, xstart + m / 2 * 5, ystart + m * 2 + m / 3);
                    g.drawLine(xstart + m / 2 * 5, ystart + m * 2 + m / 3, xstart + m / 2 * 7, ystart + m * 2 - m / 3);
                    break;
                }
                case 206: {
                    this.drawRingIcon(g, xstart, ystart + 2, 3);
                    break;
                }
                case 207: {
                    this.drawRingIcon(g, xstart, ystart, 4);
                    break;
                }
                case 208: {
                    this.drawRingIcon(g, xstart, ystart, 5);
                    break;
                }
                case 209: {
                    this.drawRingIcon(g, xstart, ystart, 1);
                    break;
                }
                case 210: {
                    this.drawRingIcon(g, xstart, ystart, 6);
                    break;
                }
                case 211: {
                    this.drawRingIcon(g, xstart, ystart, 7);
                    break;
                }
                case 212: {
                    this.drawRingIcon(g, xstart, ystart, 8);
                }
            }
        } else {
            int dan = 3;
            if (square == 301) {
                dan = 3;
            } else if (square == 401) {
                dan = 4;
            } else if (square == 501) {
                dan = 5;
            } else if (square == 601) {
                dan = 8;
            } else if (square == 701) {
                dan = 9;
            } else if (square == 801) {
                dan = 10;
            } else if (square == 901) {
                dan = 11;
            } else if (square == 1001) {
                dan = 12;
            } else if (square == 1101) {
                dan = 7;
            } else if (square == 1201) {
                dan = 18;
            } else if (square == 1301) {
                dan = 19;
            }
            this.squareTextBold(g, xstart, ystart, color[dan], zlabel[dan]);
        }
    }

    void squareText(Graphics g, int xstart, int ystart, String text) {
        g.setFont(this.fontSmall);
        int hSmall = this.fontSmallMet.getAscent();
        int w = this.fontSmallMet.stringWidth(text);
        g.drawString(text, xstart + (this.sd - w) / 2, ystart + (this.sd - hSmall) / 2 + hSmall);
    }

    void squareTextBold(Graphics g, int xstart, int ystart, Color col, String text) {
        int h = this.fontBoldMet.getAscent();
        int w = this.fontBoldMet.stringWidth(text);
        g.setFont(this.fontBold);
        g.setColor(col);
        if (this.bwMode) {
            g.setColor(Color.black);
        }
        g.drawString(text, xstart + (this.sd - w) / 2, ystart + (this.sd - h) / 2 + h);
    }

    void drawRingIcon(Graphics g, int xstart, int ystart, int n) {
        double uhol;
        int i;
        int m = this.sd / 4;
        boolean ph = false;
        int[] xp = new int[9];
        int[] yp = new int[9];
        double xcenter = xstart + this.sd / 2;
        double ycenter = ystart + this.sd / 2;
        int rc = this.sd / 2 - m / 2;
        if (n == 1) {
            n = 6;
            ph = true;
        }
        for (i = 0; i <= n; ++i) {
            uhol = Math.PI * 2 / (double)n * ((double)i - 0.5);
            xp[i] = (int)(xcenter + (double)rc * Math.sin(uhol));
            yp[i] = (int)(ycenter + (double)rc * Math.cos(uhol));
        }
        g.drawPolygon(xp, yp, n + 1);
        if (ph) {
            for (i = 0; i <= n; ++i) {
                uhol = Math.PI * 2 / (double)n * ((double)i - 0.5);
                xp[i] = (int)(xcenter + (double)(rc - 3) * Math.sin(uhol));
                yp[i] = (int)(ycenter + (double)(rc - 3) * Math.cos(uhol));
            }
            g.drawLine(xp[0], yp[0], xp[1], yp[1]);
            g.drawLine(xp[2], yp[2], xp[3], yp[3]);
            g.drawLine(xp[4], yp[4], xp[5], yp[5]);
        }
    }

    void info(String text) {
        this.infoText = text;
    }

    public boolean mouseDown(MouseEvent e, int x, int y) {
        boolean status = true;
        if (this.depict) {
            return true;
        }
        this.xold = x - this.sd;
        this.yold = y - 2 * this.sd;
        this.info("");
        this.mouseShift = e.isShiftDown();
        this.movePossible = false;
        if (x < this.sd || y < this.sd * 2) {
            int xbutton = 0;
            for (int i = 1; i <= 12; ++i) {
                if (x >= i * this.sd) continue;
                xbutton = i;
                break;
            }
            int ybutton = 0;
            for (int i = 1; i <= ACTIONA + 2; ++i) {
                if (y >= i * this.sd) continue;
                ybutton = i;
                break;
            }
            if (xbutton == 0 || ybutton == 0) {
                return true;
            }
            int action = ybutton * 100 + xbutton;
            if (!this.application && action == 111) {
                return true;
            }
            if (!this.query && action == 107) {
                return true;
            }
            if (!this.stereo && action == 201) {
                return true;
            }
            if (!this.multipart && action == 103) {
                return true;
            }
            if (!this.number && !this.autonumber && action == 105) {
                return true;
            }
            if (!this.reaction && action == 109) {
                return true;
            }
            this.menuAction(action);
        } else {
            if (y > this.dimension.height - this.sd - 1) {
                return true;
            }
            this.movePossible = true;
            x -= this.sd;
            y -= 2 * this.sd;
            if (this.doAction()) {
                return false;
            }
            if (this.nmols == 0 || this.newMolecule) {
                if (this.action <= 201) {
                    return true;
                }
                this.doNewMoleculeAction(x, y);
                status = false;
            }
            this.mol.valenceState();
            this.repaint();
        }
        return status;
    }

    protected boolean doAction() {
        if (this.mol.touchedAtom > 0) {
            this.doMouseAtomAction();
        } else if (this.mol.touchedBond > 0) {
            this.doMouseBondAction();
        } else {
            return false;
        }
        this.mol.valenceState();
        this.repaint();
        return true;
    }

    protected void doNewMoleculeAction(int x, int y) {
        ++this.nmols;
        this.actualMolecule = this.nmols;
        this.mols[this.nmols] = new JMEmol(this);
        this.mol = this.mols[this.nmols];
        this.newMolecule = false;
        this.smol = null;
        if (this.action >= 202 && this.action <= 204 || this.action == 205) {
            this.mol.createAtom();
            this.mol.nbonds = 0;
            this.mol.nv[1] = 0;
            this.mol.x[1] = x;
            this.mol.y[1] = y;
            this.mol.touchedAtom = 1;
            this.mol.touched_org = 1;
            this.lastAction = 1;
            this.mol.addBond();
            if (this.action == 205) {
                this.mol.x[2] = (double)x + 21.65;
                this.mol.y[2] = (double)y - 12.5;
                this.mol.chain[0] = 1;
                this.mol.chain[1] = 2;
                this.mol.nchain = 1;
            }
        } else if (this.action >= 206 && this.action <= 229) {
            this.mol.xorg = x;
            this.mol.yorg = y;
            this.lastAction = 2;
            this.mol.addRing();
        } else if (this.action > 300) {
            this.mol.createAtom();
            this.mol.an[1] = this.active_an;
            this.mol.nbonds = 0;
            this.mol.nv[1] = 0;
            this.mol.x[1] = x;
            this.mol.y[1] = y;
            this.mol.touchedAtom = 1;
            if (this.active_an == 18) {
                String xx = this.atomicSymbol.getText();
                if (xx.length() < 1) {
                    xx = "X";
                }
                this.mol.setAtom(1, xx);
            }
        } else if (this.action == 230) {
            this.readMolecule(this.template);
        } else if (this.action >= 233 && this.action < 260) {
            this.mol.createAtom();
            this.mol.nbonds = 0;
            this.mol.nv[1] = 0;
            this.mol.x[1] = x;
            this.mol.y[1] = y;
            this.mol.touchedAtom = 1;
            this.mol.addGroup(true);
        } else {
            System.err.println("error -report fall through bug !");
        }
    }

    protected void doMouseBondAction() {
        if (this.action == 104) {
            this.mol.save();
            this.mol.deleteBond(this.mol.touchedBond);
            this.mol.touchedBond = 0;
        } else if (this.action == 106) {
            this.mol.save();
            this.mol.deleteGroup(this.mol.touchedBond);
            this.mol.touchedBond = 0;
        } else if (this.action == 201) {
            this.mol.stereoBond(this.mol.touchedBond);
        } else if (this.action == 202 || this.action == 205) {
            this.mol.nasv[this.mol.touchedBond] = this.mol.nasv[this.mol.touchedBond] == 1 && this.mol.stereob[this.mol.touchedBond] == 0 ? 2 : 1;
            this.mol.stereob[this.mol.touchedBond] = 0;
        } else if (this.action == 203) {
            this.mol.nasv[this.mol.touchedBond] = 2;
            this.mol.stereob[this.mol.touchedBond] = 0;
        } else if (this.action == 204) {
            this.mol.nasv[this.mol.touchedBond] = 3;
            this.mol.stereob[this.mol.touchedBond] = 0;
        } else if (this.action >= 206 && this.action <= 229) {
            this.mol.save();
            this.lastAction = 2;
            this.mol.addRing();
        } else if (this.action == 107) {
            if (!this.queryBox.isBondQuery()) {
                return;
            }
            String bondQuery = this.queryBox.getSmarts();
            this.mol.nasv[this.mol.touchedBond] = 9;
            this.mol.btag[this.mol.touchedBond] = bondQuery;
        } else if (this.action == 105) {
            this.info("Only atoms may be marked !");
        }
    }

    protected boolean doMouseAtomAction() {
        if (this.action == 104) {
            this.mol.save();
            this.mol.deleteAtom(this.mol.touchedAtom);
            this.mol.touchedAtom = 0;
        } else {
            if (this.action == 106) {
                return true;
            }
            if (this.action == 108) {
                this.mol.changeCharge(this.mol.touchedAtom, 0);
            } else if (this.action == 157) {
                this.mol.changeCharge(this.mol.touchedAtom, 1);
            } else if (this.action == 158) {
                this.mol.changeCharge(this.mol.touchedAtom, -1);
            } else if (this.action == 202 || this.action == 203 || this.action == 204 || this.action == 201 || this.action == 205) {
                this.mol.save();
                this.lastAction = 1;
                this.mol.addBond();
                this.mol.touched_org = this.mol.touchedAtom;
                if (this.action == 205) {
                    this.mol.nchain = 1;
                    this.mol.chain[1] = this.mol.natoms;
                    this.mol.chain[0] = this.mol.touchedAtom;
                    this.mol.touchedBond = 0;
                }
            } else if (this.action >= 206 && this.action <= 229) {
                this.mol.save();
                this.lastAction = 2;
                this.mol.addRing();
            } else if (this.action == 230) {
                this.mol.save();
                this.lastAction = 3;
            } else if (this.action >= 233 && this.action < 260) {
                this.mol.save();
                this.mol.addGroup(false);
                this.lastAction = 3;
            } else if (this.action == 107) {
                if (this.queryBox.isBondQuery()) {
                    return true;
                }
                this.mol.setAtom(this.mol.touchedAtom, this.queryBox.getSmarts());
            } else if (this.action == 105) {
                this.mol.mark();
            } else if (this.action > 300 && (this.active_an != this.mol.an[this.mol.touchedAtom] || this.active_an == 18)) {
                this.mol.save();
                this.mol.an[this.mol.touchedAtom] = this.active_an;
                this.mol.q[this.mol.touchedAtom] = 0;
                this.mol.nh[this.mol.touchedAtom] = 0;
                if (this.active_an == 18) {
                    String xx = this.atomicSymbol.getText();
                    if (xx.length() < 1) {
                        xx = "X";
                    }
                    this.mol.setAtom(this.mol.touchedAtom, xx);
                }
            }
        }
        return false;
    }

    public boolean mouseUp(MouseEvent e, int x, int y) {
        if (this.depict) {
            return true;
        }
        if (this.lastAction == 1) {
            if (this.action == 205) {
                this.mol.checkChain();
            } else {
                this.mol.checkBond();
            }
            this.mol.findBondCenters();
        } else if (this.lastAction == 5) {
            this.mol.findBondCenters();
        }
        if (this.lastAction > 0) {
            this.mol.valenceState();
            this.mol.cleanPolarBonds();
            this.repaint();
            this.lastAction = 0;
            this.afterClear = false;
        }
        return true;
    }

    public boolean mouseDrag(MouseEvent e, int x, int y) {
        if (this.depict) {
            return true;
        }
        if (!this.movePossible) {
            return true;
        }
        int movex = (x -= this.sd) - this.xold;
        int movey = (y -= this.sd * 2) - this.yold;
        if (this.lastAction == 2 || this.lastAction == 3 || this.lastAction == 9) {
            return true;
        }
        if (this.lastAction == 1) {
            this.mol.rubberBanding(x, y);
        } else if (e.isShiftDown() || e.isMetaDown()) {
            this.mol.rotate(movex);
            this.lastAction = 5;
        } else if (this.mol.touchedAtom == 0 && this.mol.touchedBond == 0) {
            this.mol.move(movex, movey);
            this.lastAction = 5;
        }
        this.repaint();
        this.xold = x;
        this.yold = y;
        return true;
    }

    public boolean mouseMove(MouseEvent e, int x, int y) {
        int m;
        if (this.depict) {
            return true;
        }
        x -= this.sd;
        y -= this.sd * 2;
        this.myFrame.requestFocusInWindow();
        boolean repaintFlag = false;
        int newActual = 0;
        for (m = 1; m <= this.nmols; ++m) {
            int a = 0;
            int b = 0;
            a = this.mols[m].testAtomTouch(x, y);
            if (a == 0) {
                b = this.mols[m].testBondTouch(x, y);
            }
            if (a > 0) {
                this.mols[m].touchedAtom = a;
                this.mols[m].touchedBond = 0;
                newActual = m;
                repaintFlag = true;
                break;
            }
            if (b > 0) {
                this.mols[m].touchedAtom = 0;
                this.mols[m].touchedBond = b;
                newActual = m;
                repaintFlag = true;
                break;
            }
            if (this.mols[m].touchedAtom <= 0 && this.mols[m].touchedBond <= 0) continue;
            this.mols[m].touchedAtom = 0;
            this.mols[m].touchedBond = 0;
            repaintFlag = true;
        }
        if (repaintFlag) {
            for (m = this.actualMolecule + 1; m <= this.nmols; ++m) {
                this.mols[m].touchedAtom = 0;
                this.mols[m].touchedBond = 0;
            }
            this.repaint();
        }
        if (newActual != 0 && newActual != this.actualMolecule) {
            this.actualMolecule = newActual;
            this.mol = this.mols[this.actualMolecule];
        }
        return true;
    }

    public boolean keyDown(KeyEvent e, int key) {
        if (this.depict) {
            return true;
        }
        this.info("");
        int pressed = 0;
        boolean alt = e.getModifiers() == 8;
        boolean ctrl = e.getModifiers() == 2;
        char c = (char)key;
        switch (c) {
            case 'C': {
                pressed = 301;
                break;
            }
            case 'N': {
                pressed = 401;
                break;
            }
            case 'O': {
                pressed = 501;
                break;
            }
            case 'S': {
                pressed = 601;
                break;
            }
            case 'P': {
                pressed = 1101;
                break;
            }
            case 'F': {
                pressed = 701;
                break;
            }
            case 'L': {
                pressed = 801;
                break;
            }
            case 'B': {
                pressed = 901;
                break;
            }
            case 'I': {
                pressed = 1001;
                break;
            }
            case 'X': {
                this.info(this.atomicSymbol.getText());
                pressed = 1201;
                this.active_an = 18;
                break;
            }
            case 'H': {
                this.info("H");
                pressed = 1300;
                break;
            }
            case 'R': {
                this.info("R");
                pressed = 1301;
                break;
            }
            case 'T': {
                if (this.action == 701) {
                    pressed = 236;
                    this.info("-CF3");
                    break;
                }
                if (this.action == 801) {
                    pressed = 237;
                    this.info("-CCl3");
                    break;
                }
                pressed = 233;
                this.info("-tBu");
                break;
            }
            case 'Y': {
                pressed = 234;
                this.info("-NO2");
                break;
            }
            case 'Z': {
                if (ctrl) {
                    pressed = 110;
                    this.info("");
                    break;
                }
                pressed = 239;
                this.info("-SO3H");
                break;
            }
            case 'A': {
                pressed = 235;
                this.info("-COOH");
                break;
            }
            case 'E': {
                pressed = 238;
                this.info("-C#CH");
                break;
            }
            case 'U': {
                pressed = 110;
                break;
            }
            case 'Q': {
                pressed = 242;
                this.info("-C#N");
                break;
            }
            case '\u001b': {
                pressed = 202;
                break;
            }
            case '-': {
                if (this.action == 701) {
                    pressed = 254;
                    this.info("-F");
                    break;
                }
                if (this.action == 801) {
                    pressed = 255;
                    this.info("-Cl");
                    break;
                }
                if (this.action == 901) {
                    pressed = 256;
                    this.info("-Br");
                    break;
                }
                if (this.action == 1001) {
                    pressed = 257;
                    this.info("-I");
                    break;
                }
                if (this.action == 501) {
                    pressed = 259;
                    this.info("-OH");
                    break;
                }
                if (this.action == 401) {
                    pressed = 258;
                    this.info("-NH2");
                    break;
                }
                pressed = 202;
                break;
            }
            case '=': {
                if (this.action == 501) {
                    pressed = 250;
                    this.info("=O");
                    break;
                }
                pressed = 203;
                break;
            }
            case '#': {
                pressed = 204;
                break;
            }
            case '0': {
                if (this.action == 105) {
                    this.updateMark(0);
                    break;
                }
                if (!alt) {
                    pressed = 221;
                    this.info("-Furyl");
                    break;
                }
                pressed = 223;
                this.info("-3-Furyl");
                break;
            }
            case '1': {
                if (this.action == 105) {
                    this.updateMark(1);
                    break;
                }
                if (this.action == 1301) {
                    this.info("-R1");
                    pressed = 1302;
                    break;
                }
                int action_old = this.action;
                this.menuAction(202);
                this.doAction();
                this.action = action_old;
                return true;
            }
            case '2': {
                if (this.action == 105) {
                    this.updateMark(2);
                    break;
                }
                if (this.action == 1301) {
                    this.info("-R2");
                    pressed = 1303;
                    break;
                }
                int action_old = this.action;
                this.menuAction(203);
                this.doAction();
                this.action = action_old;
                return true;
            }
            case '3': {
                if (this.action == 105) {
                    this.updateMark(3);
                    break;
                }
                if (this.action == 1301) {
                    this.info("-R3");
                    pressed = 1304;
                    break;
                }
                int action_old = this.action;
                this.menuAction(204);
                this.doAction();
                this.action = action_old;
                return true;
            }
            case '4': {
                if (this.action == 105) {
                    this.updateMark(4);
                    break;
                }
                pressed = 207;
                break;
            }
            case '5': {
                if (this.action == 105) {
                    this.updateMark(5);
                    break;
                }
                pressed = 208;
                break;
            }
            case '6': {
                if (this.action == 105) {
                    this.updateMark(6);
                    break;
                }
                pressed = 210;
                break;
            }
            case '7': {
                if (this.action == 105) {
                    this.updateMark(7);
                    break;
                }
                pressed = 211;
                break;
            }
            case '8': {
                if (this.action == 105) {
                    this.updateMark(8);
                    break;
                }
                pressed = 212;
                break;
            }
            case '9': {
                if (this.action == 105) {
                    this.updateMark(9);
                    break;
                }
                this.info("9 ring");
                pressed = 229;
                break;
            }
            case '\b': 
            case 'D': 
            case 'd': 
            case '\u007f': {
                pressed = 104;
                break;
            }
            case ' ': {
                pressed = 205;
                break;
            }
            case '\u03ea': {
                pressed = 151;
                break;
            }
            case '\u03eb': {
                pressed = 152;
            }
        }
        this.menuAction(pressed);
        return true;
    }

    protected void updateMark(int n) {
        if (this.autonumber) {
            if (n == 0) {
                this.currentMark = -1;
                this.info("click marked atom to delete mark");
                this.repaint();
            }
            return;
        }
        this.currentMark = this.markUsed ? n : (this.currentMark > -1 && this.currentMark < 10 ? this.currentMark * 10 + n : n);
        this.markUsed = false;
        if (this.currentMark == 0) {
            this.currentMark = -1;
            this.info("click marked atom to delete mark");
        } else {
            this.info(this.currentMark + " ");
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDrag(e, e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseMove(e, e.getX(), e.getY());
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyDown(e, e.getKeyCode());
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseDown(e, e.getX(), e.getY());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseUp(e, e.getX(), e.getY());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

