/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javajs.util.SB;
import jspecview.api.JSVZipReader;
import org.jmol.util.Logger;

public class JSVZipFileSequentialReader
extends BufferedReader
implements JSVZipReader {
    private String[] subFileList;
    private ZipInputStream zis;
    private ZipEntry ze;
    private int ptMark;
    private String data;
    private String startCode;
    private int lineCount;
    private byte[] buf = new byte[1024];
    private int len;
    private int pt;
    private char cr = '\u0000';

    public JSVZipFileSequentialReader() {
        super(new StringReader(""));
    }

    @Override
    public JSVZipFileSequentialReader set(InputStream bis, String[] subFileList, String startCode) {
        this.subFileList = subFileList;
        this.zis = new ZipInputStream(bis);
        this.startCode = startCode;
        this.nextEntry();
        return this;
    }

    @Override
    public void close() {
        try {
            this.zis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void mark(int limit) {
        this.ptMark = this.pt;
        if (this.len == 0) {
            this.readLine();
            this.pt = this.ptMark;
        }
    }

    @Override
    public void reset() {
        this.pt = this.ptMark;
    }

    @Override
    public int read(char[] chars, int chPt, int chLen) {
        int l = Math.min(this.len - this.pt, chLen);
        this.data.getChars(0, l, chars, chPt);
        return l;
    }

    @Override
    public String readLine() {
        while (this.ze != null) {
            try {
                String line = this.getEntryLine();
                if (line != null) {
                    return line;
                }
            }
            catch (IOException e) {
                break;
            }
            this.nextEntry();
        }
        return null;
    }

    private void nextEntry() {
        this.pt = 0;
        this.len = 0;
        this.cr = '\u0000';
        this.lineCount = 0;
        try {
            while ((this.ze = this.zis.getNextEntry()) != null) {
                if (!this.isEntryOK(this.ze.getName())) continue;
                return;
            }
        }
        catch (Exception e) {
            this.ze = null;
        }
    }

    private boolean isEntryOK(String name) {
        if (this.subFileList == null || this.subFileList.length == 1) {
            return true;
        }
        int i = this.subFileList.length;
        while (--i >= 0) {
            if (!this.subFileList[i].equals(name)) continue;
            Logger.info("...reading zip entry " + name);
            return true;
        }
        Logger.info("...skipping zip entry " + name);
        return false;
    }

    private String getEntryLine() throws IOException {
        SB line = null;
        while (this.len >= 0 && (this.pt < this.len || this.zis.available() == 1)) {
            int pt0 = this.pt;
            char ch = ' ';
            while (this.pt < this.len && ch != this.cr) {
                ch = this.data.charAt(this.pt++);
                switch (ch) {
                    case '\n': {
                        if (this.cr == '\r') {
                            pt0 = this.pt;
                            break;
                        }
                        this.cr = (char)10;
                        break;
                    }
                    case '\r': {
                        if (this.cr == '\n') break;
                        this.cr = (char)13;
                    }
                }
            }
            if (line == null) {
                line = new SB();
            }
            if (this.pt != pt0) {
                line.append(this.data.substring(pt0, this.pt + (ch == this.cr ? -1 : 0)));
            }
            if (ch == this.cr || this.zis.available() != 1 || (this.len = this.zis.read(this.buf, 0, 1024)) < 0) {
                if (this.lineCount++ == 0 && this.startCode != null && line.indexOf(this.startCode) < 0) {
                    return null;
                }
                return line.toString();
            }
            this.pt = 0;
            this.data = new String(this.buf, 0, this.len);
            if (this.data.indexOf(0) < 0) continue;
            return null;
        }
        return line == null ? null : line.toString();
    }
}

