/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.DF;
import javajs.util.PT;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.Integral;
import jspecview.common.Measurement;
import jspecview.common.Spectrum;
import jspecview.exception.JSVException;
import jspecview.source.JDXHeader;
import org.jmol.util.Logger;

public abstract class JDXDataObject
extends JDXHeader {
    public static final double ERROR = Double.MAX_VALUE;
    public static final int REF_TYPE_UNSPECIFIED = -1;
    public static final int REF_TYPE_STANDARD = 0;
    public static final int REF_TYPE_BRUKER = 1;
    public static final int REF_TYPE_VARIAN = 2;
    public String sourceID = "";
    public boolean isSimulation;
    protected double blockID;
    private String filePath;
    private String filePathForwardSlash;
    private String inlineData;
    private double fileShiftRef = Double.MAX_VALUE;
    private int fileShiftRefType = -1;
    private int fileShiftRefDataPt = -1;
    private double minX = Double.NaN;
    private double minY = Double.NaN;
    private double maxX = Double.NaN;
    private double maxY = Double.NaN;
    private double deltaX = Double.NaN;
    public Coordinate[] xyCoords;
    private boolean continuous;
    private boolean isHZtoPPM = false;
    private boolean xIncreases = true;
    public double fileFirstX = Double.MAX_VALUE;
    public double fileLastX = Double.MAX_VALUE;
    public int fileNPoints = -1;
    public double xFactor = Double.MAX_VALUE;
    public double yFactor = Double.MAX_VALUE;
    public String nucleusX;
    public String nucleusY = "?";
    public double freq2dX = Double.NaN;
    public double freq2dY = Double.NaN;
    public String y2DUnits = "";
    protected Spectrum parent;
    protected String xUnits = "";
    protected String yUnits = "";
    protected String xLabel = null;
    protected String yLabel = null;
    String varName = "";
    private String observedNucl = "";
    private double observedFreq = Double.MAX_VALUE;
    private int numDim = 1;
    private int nH;
    private double y2D = Double.NaN;
    private static final double[] gyroData = new double[]{1.0, 42.5774806, 2.0, 6.53590131, 3.0, 45.4148, 3.0, 32.436, 6.0, 6.2661, 7.0, 16.5483, 9.0, 5.9842, 10.0, 4.5752, 11.0, 13.663, 13.0, 10.70839657, 14.0, 3.07770646, 15.0, 4.3172657, 17.0, 5.7742, 19.0, 40.07757016, 21.0, 3.3631, 23.0, 11.26952167, 25.0, 2.6083, 27.0, 11.1031, 29.0, 8.4655, 31.0, 17.2514409, 33.0, 3.2717, 35.0, 4.1765, 37.0, 3.4765, 37.0, 5.819, 39.0, 3.46, 39.0, 1.9893, 40.0, 2.4737, 41.0, 1.0919, 43.0, 2.8688, 45.0, 10.3591, 47.0, 2.4041, 49.0, 2.4048, 50.0, 4.2505, 51.0, 11.2133, 53.0, 2.4115, 55.0, 10.5763, 57.0, 1.3816, 59.0, 10.077, 61.0, 3.8114, 63.0, 11.2982, 65.0, 12.103, 67.0, 2.6694, 69.0, 10.2478, 71.0, 13.0208, 73.0, 1.4897, 75.0, 7.315, 77.0, 8.1571, 79.0, 10.7042, 81.0, 11.5384, 83.0, 1.6442, 85.0, 4.1254, 87.0, 13.9811, 87.0, 1.8525, 89.0, 2.0949, 91.0, 3.9748, 93.0, 10.4523, 95.0, 2.7874, 97.0, 2.8463, 99.0, 9.6294, 99.0, 1.9553, 101.0, 2.1916, 103.0, 1.3477, 105.0, 1.957, 107.0, 1.7331, 109.0, 1.9924, 111.0, 9.0692, 113.0, 9.4871, 113.0, 9.3655, 115.0, 9.3856, 115.0, 14.0077, 117.0, 15.261, 119.0, 15.966, 121.0, 10.2551, 123.0, 5.5532, 123.0, 11.2349, 125.0, 13.5454, 127.0, 8.5778, 129.0, 11.8604, 131.0, 3.5159, 133.0, 5.6234, 135.0, 4.2582, 137.0, 4.7634, 138.0, 5.6615, 139.0, 6.0612, 137.0, 4.88, 139.0, 5.39, 141.0, 2.37, 141.0, 13.0359, 143.0, 2.319, 145.0, 1.429, 143.0, 11.59, 147.0, 5.62, 147.0, 1.7748, 149.0, 14631.0, 151.0, 10.5856, 153.0, 4.6745, 155.0, 1.312, 157.0, 1.72, 159.0, 10.23, 161.0, 1.4654, 163.0, 2.0508, 165.0, 9.0883, 167.0, 1.2281, 169.0, 3.531, 171.0, 7.5261, 173.0, 2.073, 175.0, 4.8626, 176.0, 3.451, 177.0, 1.7282, 179.0, 1.0856, 180.0, 4.087, 181.0, 5.1627, 183.0, 1.7957, 185.0, 9.7176, 187.0, 9.817, 187.0, 0.9856, 189.0, 3.3536, 191.0, 0.7658, 191.0, 0.8319, 195.0, 9.2922, 197.0, 0.7406, 199.0, 7.7123, 201.0, 2.8469, 203.0, 24.7316, 205.0, 24.9749, 207.0, 9.034, 209.0, 6.963, 209.0, 11.7, 211.0, 9.16, 223.0, 5.95, 223.0, 1.3746, 225.0, 11.187, 227.0, 5.6, 229.0, 1.4, 231.0, 10.2, 235.0, 0.83, 237.0, 9.57, 239.0, 3.09, 243.0, 4.6, 1.0E100};
    private static final Map<String, Double> gyroMap = new Hashtable<String, Double>();

    public void setInlineData(String data) {
        this.inlineData = data;
    }

    public String getInlineData() {
        return this.inlineData;
    }

    public void setFilePath(String filePath) {
        if (filePath != null) {
            this.filePath = filePath.trim();
            this.filePathForwardSlash = this.filePath.replace('\\', '/');
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFilePathForwardSlash() {
        return this.filePathForwardSlash;
    }

    public void setBlockID(double id) {
        this.blockID = id;
    }

    public void checkJDXRequiredTokens() throws JSVException {
        String missingTag;
        String string = this.fileFirstX == Double.MAX_VALUE ? "##FIRSTX" : (this.fileLastX == Double.MAX_VALUE ? "##LASTX" : (this.fileNPoints == -1 ? "##NPOINTS" : (this.xFactor == Double.MAX_VALUE ? "##XFACTOR" : (missingTag = this.yFactor == Double.MAX_VALUE ? "##YFACTOR" : null))));
        if (missingTag != null) {
            throw new JSVException("Error Reading Data Set: " + missingTag + " not found");
        }
    }

    public void setXFactor(double xFactor) {
        this.xFactor = xFactor;
    }

    public double getXFactor() {
        return this.xFactor;
    }

    public void setYFactor(double yFactor) {
        this.yFactor = yFactor;
    }

    public double getYFactor() {
        return this.yFactor;
    }

    public void setVarName(String name) {
        this.varName = name;
    }

    public boolean isImaginary() {
        return this.varName.contains("IMAG");
    }

    public void setXUnits(String xUnits) {
        this.xUnits = xUnits;
    }

    public String getXUnits() {
        return this.xUnits;
    }

    public void setYUnits(String yUnits) {
        if (yUnits.equals("PPM")) {
            yUnits = "ARBITRARY UNITS";
        }
        this.yUnits = yUnits;
    }

    public String getYUnits() {
        return this.yUnits;
    }

    public void setXLabel(String value) {
        this.xLabel = value;
    }

    public void setYLabel(String value) {
        this.yLabel = value;
    }

    public void setObservedNucleus(String value) {
        this.observedNucl = value;
        if (this.is1D()) {
            this.parent.nucleusX = this.nucleusX = this.fixNucleus(value);
        }
    }

    public String getObservedNucleus() {
        return this.observedNucl;
    }

    public void setObservedFreq(double observedFreq) {
        this.observedFreq = observedFreq;
    }

    public double getObservedFreq() {
        return this.observedFreq;
    }

    public void setHydrogenCount(int nH) {
        this.nH = nH;
    }

    public int getHydrogenCount() {
        return this.nH;
    }

    public boolean is1D() {
        return this.numDim == 1;
    }

    public int getNumDim() {
        return this.numDim;
    }

    public void setNumDim(int n) {
        this.numDim = n;
    }

    public void setY2D(double d) {
        this.y2D = d;
    }

    public double getY2D() {
        return this.y2D;
    }

    public void setY2DUnits(String units) {
        this.y2DUnits = units;
    }

    public double getY2DPPM() {
        double d = this.y2D;
        if (this.y2DUnits.equals("HZ")) {
            d /= this.freq2dY;
        }
        return d;
    }

    public void setNucleusAndFreq(String nuc, boolean isX) {
        double freq;
        nuc = this.fixNucleus(nuc);
        if (isX) {
            this.nucleusX = nuc;
        } else {
            this.nucleusY = nuc;
        }
        if (this.observedNucl.indexOf(nuc) >= 0) {
            freq = this.observedFreq;
        } else {
            double g1 = JDXDataObject.getGyromagneticRatio(this.fixNucleus(this.observedNucl));
            double g2 = JDXDataObject.getGyromagneticRatio(nuc);
            freq = this.observedFreq * g2 / g1;
        }
        if (isX) {
            this.freq2dX = freq;
        } else {
            this.freq2dY = freq;
        }
        Logger.info("Freq for " + nuc + " = " + freq);
    }

    private String fixNucleus(String nuc) {
        return PT.rep(PT.trim(nuc, "[]^<>"), "NUC_", "");
    }

    public static int getNominalSpecFreq(String nuc, double freq) {
        double d = JDXDataObject.getSpecFreq(nuc, freq);
        int century = (int)Math.round(d / 100.0) * 100;
        return Double.isNaN(d) ? -1 : (Math.abs(d - (double)century) < 2.0 ? century : (int)Math.round(d));
    }

    public static double getSpecFreq(String nuc, double freq) {
        return freq * JDXDataObject.getGyromagneticRatio("1H") / JDXDataObject.getGyromagneticRatio(nuc);
    }

    public static double getGyromagneticRatio(String nuc) {
        Double v = null;
        try {
            int pt;
            v = gyroMap.get(nuc);
            if (v != null) {
                return v;
            }
            for (pt = 0; pt < nuc.length() && Character.isDigit(nuc.charAt(pt)); ++pt) {
            }
            v = gyroMap.get(nuc.substring(0, pt));
            if (v != null) {
                gyroMap.put(nuc, v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return v == null ? Double.NaN : v;
    }

    public boolean isTransmittance() {
        String s = this.yUnits.toLowerCase();
        return s.equals("transmittance") || s.contains("trans") || s.equals("t");
    }

    public boolean isAbsorbance() {
        String s = this.yUnits.toLowerCase();
        return s.equals("absorbance") || s.contains("abs") || s.equals("a");
    }

    public boolean canSaveAsJDX() {
        return this.getDataClass().equals("XYDATA");
    }

    public boolean canIntegrate() {
        return this.continuous && (this.isHNMR() || this.isGC()) && this.is1D();
    }

    public boolean isAutoOverlayFromJmolClick() {
        return this.isGC();
    }

    public boolean isGC() {
        return this.dataType.startsWith("GC") || this.dataType.startsWith("GAS");
    }

    public boolean isMS() {
        return this.dataType.startsWith("MASS") || this.dataType.startsWith("MS");
    }

    public boolean isStackable() {
        return !this.isMS();
    }

    public boolean isScalable() {
        return true;
    }

    public double getYRef() {
        return !this.isTransmittance() ? 0.0 : (Coordinate.getMaxY(this.xyCoords, 0, this.xyCoords.length - 1) < 2.0 ? 1.0 : 100.0);
    }

    public boolean isInverted() {
        return this.isTransmittance();
    }

    public boolean canConvertTransAbs() {
        return this.continuous && this.yUnits.toLowerCase().contains("abs") || this.yUnits.toLowerCase().contains("trans");
    }

    public boolean canShowSolutionColor() {
        return this.isContinuous() && this.canConvertTransAbs() && (this.xUnits.toLowerCase().contains("nanometer") || this.xUnits.equalsIgnoreCase("nm")) && this.getFirstX() < 401.0 && this.getLastX() > 699.0 && this.xyCoords.length >= 30;
    }

    public boolean isHZtoPPM() {
        return this.isHZtoPPM;
    }

    public void setHZtoPPM(boolean val) {
        this.isHZtoPPM = val;
    }

    public void setIncreasing(boolean val) {
        this.xIncreases = val;
    }

    public boolean isXIncreasing() {
        return this.xIncreases;
    }

    public boolean shouldDisplayXAxisIncreasing() {
        String dt = this.dataType.toUpperCase();
        String xu = this.xUnits.toUpperCase();
        if (dt.contains("NMR") && !dt.contains("FID")) {
            return false;
        }
        if (dt.contains("LINK") && xu.contains("CM")) {
            return false;
        }
        if (dt.startsWith("IR") || dt.contains("INFRA") && xu.contains("CM")) {
            return false;
        }
        if (dt.contains("RAMAN") && xu.contains("CM")) {
            return false;
        }
        if (dt.contains("VIS") && xu.contains("NANOMETERS")) {
            return true;
        }
        return this.xIncreases;
    }

    public void setContinuous(boolean val) {
        this.continuous = val;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public String[][] getHeaderRowDataAsArray() {
        int n = 8;
        if (this.observedFreq != Double.MAX_VALUE) {
            ++n;
        }
        if (this.observedNucl != "") {
            ++n;
        }
        String[][] rowData = this.getHeaderRowDataAsArray(true, n);
        int i = rowData.length - n;
        if (this.observedFreq != Double.MAX_VALUE) {
            rowData[i++] = new String[]{"##.OBSERVE FREQUENCY", "" + this.observedFreq};
        }
        if (this.observedNucl != "") {
            rowData[i++] = new String[]{"##.OBSERVE NUCLEUS", this.observedNucl};
        }
        rowData[i++] = new String[]{"##XUNITS", this.isHZtoPPM ? "HZ" : this.xUnits};
        rowData[i++] = new String[]{"##YUNITS", this.yUnits};
        double x = this.xIncreases ? this.getFirstX() : this.getLastX();
        rowData[i++] = new String[]{"##FIRSTX", String.valueOf(this.isHZtoPPM() ? x * this.observedFreq : x)};
        x = this.xIncreases ? this.getLastX() : this.getFirstX();
        rowData[i++] = new String[]{"##FIRSTY", String.valueOf(this.xIncreases ? this.getFirstY() : this.getLastY())};
        rowData[i++] = new String[]{"##LASTX", String.valueOf(this.isHZtoPPM() ? x * this.observedFreq : x)};
        rowData[i++] = new String[]{"##XFACTOR", String.valueOf(this.getXFactor())};
        rowData[i++] = new String[]{"##YFACTOR", String.valueOf(this.getYFactor())};
        rowData[i++] = new String[]{"##NPOINTS", String.valueOf(this.xyCoords.length)};
        return rowData;
    }

    public int getDefaultUnitPrecision() {
        return 2;
    }

    public String setMeasurementText(Measurement m) {
        double dx = m.getValue();
        if (Double.isNaN(dx)) {
            return "";
        }
        int precision = 1;
        String units = "";
        if (this.isNMR()) {
            if (this.is1D()) {
                boolean isIntegral = m instanceof Integral;
                if (this.isHNMR() || isIntegral) {
                    if (!isIntegral) {
                        dx *= this.observedFreq;
                        units = " Hz";
                    }
                } else {
                    units = " ppm";
                    precision = 2;
                }
            } else {
                return "";
            }
        }
        return dx < 0.1 ? "" : DF.formatDecimalDbl(dx, precision) + units;
    }

    public boolean isNMR() {
        return this.dataType.toUpperCase().indexOf("NMR") >= 0;
    }

    public boolean isHNMR() {
        return this.isNMR() && this.observedNucl.toUpperCase().indexOf("H") >= 0;
    }

    public void setXYCoords(Coordinate[] coords) {
        this.xyCoords = coords;
    }

    public JDXDataObject invertYAxis() {
        int i = this.xyCoords.length;
        while (--i >= 0) {
            this.xyCoords[i].setYVal(-this.xyCoords[i].getYVal());
        }
        double d = this.minY;
        this.minY = -this.maxY;
        this.maxY = -d;
        return this;
    }

    public double getFirstX() {
        return this.xyCoords[0].getXVal();
    }

    public double getFirstY() {
        return this.xyCoords[0].getYVal();
    }

    public double getLastX() {
        return this.xyCoords[this.xyCoords.length - 1].getXVal();
    }

    public double getLastY() {
        return this.xyCoords[this.xyCoords.length - 1].getYVal();
    }

    public double getMinX() {
        return Double.isNaN(this.minX) ? (this.minX = Coordinate.getMinX(this.xyCoords, 0, this.xyCoords.length - 1)) : this.minX;
    }

    public double getMinY() {
        return Double.isNaN(this.minY) ? (this.minY = Coordinate.getMinY(this.xyCoords, 0, this.xyCoords.length - 1)) : this.minY;
    }

    public double getMaxX() {
        return Double.isNaN(this.maxX) ? (this.maxX = Coordinate.getMaxX(this.xyCoords, 0, this.xyCoords.length - 1)) : this.maxX;
    }

    public double getMaxY() {
        return Double.isNaN(this.maxY) ? (this.maxY = Coordinate.getMaxY(this.xyCoords, 0, this.xyCoords.length - 1)) : this.maxY;
    }

    public void normalizeSimulation(double max) {
        if (!this.isNMR() || !this.is1D()) {
            return;
        }
        double f = max / this.getMaxY();
        this.maxY = Double.NaN;
        Coordinate.applyScale(this.xyCoords, 1.0, f);
        Logger.info("Y values have been scaled by a factor of " + f);
    }

    public double getDeltaX() {
        return Double.isNaN(this.deltaX) ? (this.deltaX = Coordinate.deltaX(this.getLastX(), this.getFirstX(), this.xyCoords.length)) : this.deltaX;
    }

    public void copyTo(JDXDataObject newObj) {
        newObj.setTitle(this.title);
        newObj.setJcampdx(this.jcampdx);
        newObj.setOrigin(this.origin);
        newObj.setOwner(this.owner);
        newObj.setDataClass(this.dataClass);
        newObj.setDataType(this.dataType);
        newObj.setHeaderTable(this.headerTable);
        newObj.setXFactor(this.xFactor);
        newObj.setYFactor(this.yFactor);
        newObj.setXUnits(this.xUnits);
        newObj.setYUnits(this.yUnits);
        newObj.setXLabel(this.xLabel);
        newObj.setYLabel(this.yLabel);
        newObj.setXYCoords(this.xyCoords);
        newObj.setContinuous(this.continuous);
        newObj.setIncreasing(this.xIncreases);
        newObj.observedFreq = this.observedFreq;
        newObj.observedNucl = this.observedNucl;
        newObj.fileShiftRef = this.fileShiftRef;
        newObj.fileShiftRefDataPt = this.fileShiftRefDataPt;
        newObj.fileShiftRefType = this.fileShiftRefType;
        newObj.isHZtoPPM = this.isHZtoPPM;
        newObj.numDim = this.numDim;
        newObj.nucleusX = this.nucleusX;
        newObj.nucleusY = this.nucleusY;
        newObj.freq2dX = this.freq2dX;
        newObj.freq2dY = this.freq2dY;
        newObj.setFilePath(this.filePath);
        newObj.nH = this.nH;
    }

    public String getTypeLabel() {
        return this.isNMR() ? this.nucleusX + "NMR" : this.dataType;
    }

    public Object[] getDefaultAnnotationInfo(Annotation.AType type) {
        boolean isNMR = this.isNMR();
        switch (type) {
            case Integration: {
                return new Object[]{null, new int[]{1}, null};
            }
            case Measurements: {
                int[] nArray;
                String[] stringArray;
                if (isNMR) {
                    String[] stringArray2 = new String[2];
                    stringArray2[0] = "Hz";
                    stringArray = stringArray2;
                    stringArray2[1] = "ppm";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "";
                }
                String[] s1 = stringArray;
                if (this.isHNMR()) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = 1;
                    nArray = nArray2;
                    nArray2[1] = 4;
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = 1;
                    nArray = nArray3;
                    nArray3[1] = 3;
                }
                int[] s2 = nArray;
                return new Object[]{s1, s2, 0};
            }
            case PeakList: {
                int[] nArray;
                String[] stringArray;
                if (isNMR) {
                    String[] stringArray4 = new String[2];
                    stringArray4[0] = "Hz";
                    stringArray = stringArray4;
                    stringArray4[1] = "ppm";
                } else {
                    String[] stringArray5 = new String[1];
                    stringArray = stringArray5;
                    stringArray5[0] = "";
                }
                String[] s1 = stringArray;
                if (this.isHNMR()) {
                    int[] nArray4 = new int[2];
                    nArray4[0] = 1;
                    nArray = nArray4;
                    nArray4[1] = 2;
                } else {
                    int[] nArray5 = new int[2];
                    nArray5[0] = 1;
                    nArray = nArray5;
                    nArray5[1] = 1;
                }
                int[] s2 = nArray;
                return new Object[]{s1, s2, isNMR ? 1 : 0};
            }
            case NONE: 
            case OverlayLegend: {
                break;
            }
        }
        return null;
    }

    public double[] getPeakListArray(Measurement m, double[] last, double maxY) {
        double x = m.getXVal();
        double y = m.getYVal();
        if (this.isNMR()) {
            y /= maxY;
        }
        double dx = Math.abs(x - last[0]);
        last[0] = x;
        double ddx = dx + last[1];
        last[1] = dx;
        double dddx = ddx + last[2];
        last[2] = ddx;
        if (this.isNMR()) {
            return new double[]{x, y, x * this.observedFreq, dx * this.observedFreq > 20.0 ? 0.0 : dx * this.observedFreq, ddx * this.observedFreq > 20.0 ? 0.0 : ddx * this.observedFreq, dddx * this.observedFreq > 20.0 ? 0.0 : dddx * this.observedFreq};
        }
        return new double[]{x, y};
    }

    void finalizeCoordinates() {
        boolean isHz;
        double freq = Double.isNaN(this.freq2dX) ? this.observedFreq : this.freq2dX;
        boolean bl = isHz = freq != Double.MAX_VALUE && this.getXUnits().toUpperCase().equals("HZ");
        if (this.fileShiftRef != Double.MAX_VALUE && freq != Double.MAX_VALUE && this.dataType.toUpperCase().contains("SPECTRUM") && this.jcampdx.indexOf("JEOL") < 0) {
            this.applyShiftReference(isHz ? freq : 1.0, this.fileShiftRef);
        }
        if (this.fileFirstX > this.fileLastX) {
            Coordinate.reverse(this.xyCoords);
        }
        if (isHz) {
            Coordinate.applyScale(this.xyCoords, 1.0 / freq, 1.0);
            this.setXUnits("PPM");
            this.setHZtoPPM(true);
        }
    }

    void setShiftReference(double shift, int pt, int type) {
        this.fileShiftRef = shift;
        this.fileShiftRefDataPt = pt > 0 ? pt : 1;
        this.fileShiftRefType = type;
    }

    boolean isShiftTypeSpecified() {
        return this.fileShiftRefType != -1;
    }

    private void applyShiftReference(double referenceFreq, double shift) {
        if (this.fileShiftRefDataPt > this.xyCoords.length || this.fileShiftRefDataPt < 0) {
            return;
        }
        switch (this.fileShiftRefType) {
            case 0: {
                shift = this.xyCoords[this.fileShiftRefDataPt - 1].getXVal() - shift * referenceFreq;
                break;
            }
            case 1: {
                shift = this.fileFirstX - shift * referenceFreq;
                break;
            }
            case 2: {
                shift = this.fileLastX + shift;
            }
        }
        for (int index = 0; index < this.xyCoords.length; ++index) {
            Coordinate coord = this.xyCoords[index];
            coord.setXVal(coord.getXVal() - shift);
            this.xyCoords[index] = coord;
        }
    }

    static {
        int n = gyroData.length - 1;
        for (int i = 0; i < n; i += 2) {
            gyroMap.put("" + (int)gyroData[i], gyroData[i + 1]);
        }
    }
}

