/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import naga.NIOService;
import naga.NIOSocket;
import naga.NIOSocketSSL;
import naga.PacketReader;
import naga.PacketWriter;
import naga.SSLPacketHandler;
import naga.SocketObserver;

class SSLSocketChannelResponder
implements NIOSocketSSL,
SocketObserver {
    private final NIOSocket m_wrappedSocket;
    private final SSLPacketHandler m_packetHandler;
    private final NIOService m_nioService;
    private SocketObserver m_observer;

    public SSLSocketChannelResponder(NIOService nIOService, NIOSocket nIOSocket, SSLEngine sSLEngine, boolean bl) throws SSLException {
        this.m_nioService = nIOService;
        this.m_wrappedSocket = nIOSocket;
        this.m_packetHandler = new SSLPacketHandler(sSLEngine, this.m_wrappedSocket, this);
        this.m_wrappedSocket.setPacketReader(this.m_packetHandler);
        this.m_wrappedSocket.setPacketWriter(this.m_packetHandler);
        sSLEngine.setUseClientMode(bl);
    }

    @Override
    public void beginHandshake() throws SSLException {
        if (this.getSSLEngine().getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            throw new IllegalStateException("Tried to start handshake during handshake.");
        }
        this.m_packetHandler.begin();
    }

    @Override
    public boolean isEncrypted() {
        return this.m_packetHandler.isEncrypted();
    }

    @Override
    public SSLEngine getSSLEngine() {
        return this.m_packetHandler.getSSLEngine();
    }

    @Override
    public boolean write(byte[] byArray) {
        return this.m_wrappedSocket.write(byArray);
    }

    @Override
    public boolean write(byte[] byArray, Object object) {
        return this.m_wrappedSocket.write(byArray, object);
    }

    @Override
    public void queue(Runnable runnable) {
        this.m_wrappedSocket.queue(runnable);
    }

    @Override
    public long getBytesRead() {
        return this.m_wrappedSocket.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.m_wrappedSocket.getBytesWritten();
    }

    @Override
    public long getTimeOpen() {
        return this.m_wrappedSocket.getTimeOpen();
    }

    @Override
    public long getWriteQueueSize() {
        return this.m_wrappedSocket.getWriteQueueSize();
    }

    @Override
    public int getMaxQueueSize() {
        return this.m_wrappedSocket.getMaxQueueSize();
    }

    @Override
    public void setMaxQueueSize(int n) {
        this.m_wrappedSocket.setMaxQueueSize(n);
    }

    @Override
    public void setPacketReader(PacketReader packetReader) {
        this.m_packetHandler.setReader(packetReader);
    }

    @Override
    public void setPacketWriter(final PacketWriter packetWriter) {
        this.m_wrappedSocket.queue(new Runnable(){

            @Override
            public void run() {
                SSLSocketChannelResponder.this.m_packetHandler.setWriter(packetWriter);
            }
        });
    }

    @Override
    public void listen(SocketObserver socketObserver) {
        this.m_observer = socketObserver;
        this.m_wrappedSocket.listen(this);
    }

    @Override
    public void closeAfterWrite() {
        this.m_packetHandler.closeEngine();
        this.m_wrappedSocket.closeAfterWrite();
    }

    @Override
    public Socket socket() {
        return this.m_wrappedSocket.socket();
    }

    @Override
    public void close() {
        this.m_wrappedSocket.close();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.m_wrappedSocket.getAddress();
    }

    @Override
    public boolean isOpen() {
        return this.m_wrappedSocket.isOpen();
    }

    @Override
    public String getIp() {
        return this.m_wrappedSocket.getIp();
    }

    @Override
    public int getPort() {
        return this.m_wrappedSocket.getPort();
    }

    @Override
    public Object getTag() {
        return this.m_wrappedSocket.getTag();
    }

    @Override
    public void setTag(Object object) {
        this.m_wrappedSocket.setTag(object);
    }

    void closeDueToSSLException(SSLException sSLException) {
        try {
            if (this.m_observer != null) {
                this.m_observer.connectionBroken(this, sSLException);
            }
        }
        catch (Exception exception) {
            this.m_nioService.notifyException(sSLException);
        }
        this.m_wrappedSocket.close();
    }

    @Override
    public void connectionOpened(NIOSocket nIOSocket) {
        try {
            if (this.m_observer != null) {
                this.m_observer.connectionOpened(this);
            }
        }
        catch (Exception exception) {
            this.m_nioService.notifyException(exception);
        }
    }

    @Override
    public void connectionBroken(NIOSocket nIOSocket, Exception exception) {
        try {
            if (this.m_observer != null) {
                this.m_observer.connectionBroken(this, exception);
            }
        }
        catch (Exception exception2) {
            this.m_nioService.notifyException(exception2);
        }
    }

    @Override
    public void packetReceived(NIOSocket nIOSocket, byte[] byArray) {
        try {
            if (this.m_observer != null) {
                this.m_observer.packetReceived(this, byArray);
            }
        }
        catch (Exception exception) {
            this.m_nioService.notifyException(exception);
        }
    }

    @Override
    public void packetSent(NIOSocket nIOSocket, Object object) {
        try {
            if (this.m_observer != null) {
                this.m_observer.packetSent(this, object);
            }
        }
        catch (Exception exception) {
            this.m_nioService.notifyException(exception);
        }
    }
}

