/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.util.Hashtable;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.jvxl.readers.XmlReader;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class JvxlXmlReader
extends VolumeFileReader {
    protected String JVXL_VERSION = "2.3";
    protected int surfaceDataCount;
    protected int edgeDataCount;
    protected int colorDataCount;
    private int excludedTriangleCount;
    private int excludedVertexCount;
    private int invalidatedVertexCount;
    protected boolean haveContourData;
    private XmlReader xr;
    protected boolean isXmlFile = true;
    protected boolean thisInside;
    String tempDataXml;
    protected BS bsVoxelBitSet;
    private boolean includeValueNaN = true;
    private int valueCount;
    private float valueMin = Float.NaN;
    private float valueRange = Float.NaN;
    private int fractionPtr;
    private int colorPtr;
    private String strFractionTemp = "";
    boolean haveReadColorData;
    private String jvxlColorEncodingRead;

    JvxlXmlReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2JXR(sg, br);
    }

    void init2JXR(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
        this.isJvxl = true;
        this.jvxlData.wasJvxl = true;
        this.canDownsample = false;
        this.isXLowToHigh = false;
        this.xr = new XmlReader(br);
    }

    @Override
    protected boolean readVolumeData(boolean isMapData) {
        if (!this.readVolumeDataVFR(isMapData)) {
            return false;
        }
        this.strFractionTemp = this.jvxlEdgeDataRead;
        this.fractionPtr = 0;
        return true;
    }

    @Override
    protected boolean gotoAndReadVoxelData(boolean isMapData) {
        this.initializeVolumetricData();
        if (this.nPointsX < 0 || this.nPointsY < 0 || this.nPointsZ < 0) {
            return true;
        }
        try {
            this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
            if (this.vertexDataOnly) {
                return true;
            }
            this.volumeData.setMappingPlane(this.params.thePlane);
            this.readSurfaceData(isMapData);
            this.volumeData.setMappingPlane(null);
            if (this.edgeDataCount > 0) {
                this.jvxlEdgeDataRead = this.jvxlReadFractionData("edge", this.edgeDataCount);
            }
            this.jvxlData.jvxlExcluded = new BS[4];
            this.params.bsExcluded = this.jvxlData.jvxlExcluded;
            boolean bl = this.hasColorData = this.colorDataCount > 0;
            if (this.hasColorData) {
                this.jvxlColorDataRead = this.jvxlReadFractionData("color", this.colorDataCount);
            }
            if (this.excludedVertexCount > 0) {
                this.jvxlData.jvxlExcluded[0] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedVertexData", null, false, false));
                if (this.xr.isNext("jvxlExcludedPlaneData")) {
                    this.jvxlData.jvxlExcluded[2] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedPlaneData", null, false, false));
                }
            }
            if (this.excludedTriangleCount > 0) {
                this.jvxlData.jvxlExcluded[3] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlExcludedTriangleData", null, false, false));
            }
            if (this.invalidatedVertexCount > 0) {
                this.jvxlData.jvxlExcluded[1] = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlInvalidatedVertexData", null, false, false));
            }
            if (this.haveContourData) {
                this.jvxlDecodeContourData(this.jvxlData, this.xr.getXmlData("jvxlContourData", null, false, false));
            }
            if (this.jvxlDataIsColorMapped && this.jvxlData.nVertexColors > 0) {
                this.jvxlData.vertexColorMap = new Hashtable<String, BS>();
                String vdata = this.xr.getXmlData("jvxlVertexColorData", null, true, false);
                String baseColor = XmlReader.getXmlAttrib(vdata, "baseColor");
                this.jvxlData.baseColor = baseColor.length() > 0 ? baseColor : null;
                for (int i = 0; i < this.jvxlData.nVertexColors; ++i) {
                    String s = this.xr.getXmlData("jvxlColorMap", vdata, true, false);
                    String color = XmlReader.getXmlAttrib(s, "color");
                    BS bs = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlColorMap", s, false, false));
                    this.jvxlData.vertexColorMap.put(color, bs);
                }
            }
        }
        catch (Exception e) {
            Logger.error(e.toString());
            return false;
        }
        return true;
    }

    @Override
    protected void readParameters() throws Exception {
        String s = this.xr.getXmlDataLF("jvxlFileTitle", null, false, false, true);
        this.jvxlFileHeaderBuffer = SB.newS(s == null ? "" : s);
        this.xr.toTag("jvxlVolumeData");
        String data = this.tempDataXml = this.xr.getXmlData("jvxlVolumeData", null, true, false);
        this.volumetricOrigin.setT(this.xr.getXmlPoint(data, "origin"));
        this.isAngstroms = true;
        this.readVector(0);
        this.readVector(1);
        this.readVector(2);
        this.line = this.xr.toTag("jvxlSurfaceSet");
        this.nSurfaces = this.parseIntStr(XmlReader.getXmlAttrib(this.line, "count"));
        Logger.info("jvxl file surfaces: " + this.nSurfaces);
        Logger.info("using default edge fraction base and range");
        Logger.info("using default color fraction base and range");
        this.cJvxlEdgeNaN = (char)(this.edgeFractionBase + this.edgeFractionRange);
    }

    @Override
    protected float getJVXLCutoff() {
        return this.params.cutoff;
    }

    protected void readVector(int voxelVectorIndex) throws Exception {
        String data = this.xr.getXmlData("jvxlVolumeVector", this.tempDataXml, true, true);
        this.tempDataXml = this.tempDataXml.substring(this.tempDataXml.indexOf(data) + data.length());
        int n = this.parseIntStr(XmlReader.getXmlAttrib(data, "count"));
        if (n == Integer.MIN_VALUE) {
            this.vertexDataOnly = true;
        }
        this.voxelCounts[voxelVectorIndex] = n < 0 ? 0 : n;
        this.volumetricVectors[voxelVectorIndex].setT(this.xr.getXmlPoint(data, "vector"));
        if (this.isAnisotropic) {
            this.setVectorAnisotropy(this.volumetricVectors[voxelVectorIndex]);
        }
    }

    @Override
    protected void gotoData(int n, int nPoints) throws Exception {
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + nPoints + " points each");
        }
        this.jvxlData.vertexDataOnly = nPoints == 0;
        this.vertexDataOnly = this.jvxlData.vertexDataOnly;
        for (int i = 0; i < n; ++i) {
            this.jvxlSkipData(nPoints, true);
        }
        this.xr.toTag("jvxlSurface");
        this.jvxlReadSurfaceInfo();
    }

    protected void jvxlSkipData(int nPoints, boolean doSkipColorData) throws Exception {
        this.rd();
        this.xr.skipTag("jvxlSurface");
    }

    protected void jvxlReadSurfaceInfo() throws Exception {
        String data = this.xr.getXmlData("jvxlSurfaceInfo", null, true, true);
        this.isXLowToHigh = XmlReader.getXmlAttrib(data, "isXLowToHigh").equals("true");
        String s = XmlReader.getXmlAttrib(data, "cutoff");
        if (s.indexOf(" ") < 0) {
            this.jvxlCutoff = this.parseFloatStr(s);
            if (!Double.isNaN(this.jvxlCutoff)) {
                Logger.info("JVXL read: cutoff " + this.jvxlCutoff);
            }
        } else {
            this.jvxlCutoffRange = this.parseFloatArrayStr(s);
            this.jvxlCutoff = this.jvxlCutoffRange[0];
            Logger.info("JVXL read: cutoff " + Escape.eAF(this.jvxlCutoffRange));
        }
        this.params.cutoff = this.jvxlCutoff;
        int nContourData = this.parseIntStr(XmlReader.getXmlAttrib(data, "nContourData"));
        this.haveContourData = nContourData > 0;
        this.params.isContoured = this.jvxlData.isModelConnected = XmlReader.getXmlAttrib(data, "contoured").equals("true");
        this.params.isModelConnected = XmlReader.getXmlAttrib(data, "isModelConnected").equals("true");
        if (this.params.isContoured) {
            int nContoursRead = this.parseIntStr(XmlReader.getXmlAttrib(data, "nContours"));
            if (nContoursRead <= 0) {
                nContoursRead = 0;
            } else {
                if (this.params.thisContour < 0) {
                    this.params.thisContour = this.parseIntStr(XmlReader.getXmlAttrib(data, "thisContour"));
                }
                if ((s = XmlReader.getXmlAttrib(data, "contourValues")).length() > 0) {
                    s = s.replace('[', ' ').replace(']', ' ');
                    this.params.contoursDiscrete = this.parseFloatArrayStr(s);
                    this.jvxlData.contourValues = this.params.contoursDiscrete;
                    Logger.info("JVXL read: contourValues " + Escape.eAF(this.jvxlData.contourValues));
                }
                if ((s = XmlReader.getXmlAttrib(data, "contourColors")).length() > 0) {
                    this.params.contourColixes = C.getColixArray(s);
                    this.jvxlData.contourColixes = this.params.contourColixes;
                    this.jvxlData.contourColors = C.getHexCodes(this.jvxlData.contourColixes);
                    Logger.info("JVXL read: contourColixes " + C.getHexCodes(this.jvxlData.contourColixes));
                }
                this.params.contourFromZero = XmlReader.getXmlAttrib(data, "contourFromZero").equals("true");
            }
            this.params.nContours = this.haveContourData ? nContourData : nContoursRead;
        }
        this.jvxlData.nVertexColors = this.parseIntStr(XmlReader.getXmlAttrib(data, "nVertexColors"));
        this.params.isBicolorMap = XmlReader.getXmlAttrib(data, "bicolorMap").equals("true");
        if (this.params.isBicolorMap) {
            s = XmlReader.getXmlAttrib(data, "colorPositive");
            if (s.length() > 0 && this.params.colorRgb == Integer.MIN_VALUE && this.params.colorPos == -16776961) {
                this.params.colorPos = CU.getArgbFromString(s);
            }
            if ((s = XmlReader.getXmlAttrib(data, "colorNegative")).length() > 0 && this.params.colorRgb == Integer.MIN_VALUE && this.params.colorNeg == -65536) {
                this.params.colorNeg = CU.getArgbFromString(s);
            }
        }
        if (this.params.isBicolorMap || this.params.colorBySign) {
            this.jvxlCutoff = 0.0f;
        }
        this.jvxlDataIsColorMapped = !(this.params.colorRgb != Integer.MIN_VALUE && this.params.colorRgb != Integer.MAX_VALUE || !this.params.isBicolorMap && !XmlReader.getXmlAttrib(data, "colorMapped").equals("true"));
        this.jvxlData.isJvxlPrecisionColor = XmlReader.getXmlAttrib(data, "precisionColor").equals("true");
        this.params.colorDensity = this.params.colorRgb == Integer.MIN_VALUE && XmlReader.getXmlAttrib(data, "colorDensity").equals("true");
        this.jvxlData.jvxlDataIsColorDensity = this.params.colorDensity;
        if (this.jvxlData.jvxlDataIsColorDensity && Float.isNaN(this.params.pointSize) && (s = XmlReader.getXmlAttrib(data, "pointSize")).length() > 0) {
            this.jvxlData.pointSize = this.params.pointSize = this.parseFloatStr(s);
        }
        this.params.allowVolumeRender = (s = XmlReader.getXmlAttrib(data, "allowVolumeRender")).length() == 0 || s.equalsIgnoreCase("true");
        this.jvxlData.allowVolumeRender = this.params.allowVolumeRender;
        s = XmlReader.getXmlAttrib(data, "plane");
        if (s.indexOf("{") >= 0) {
            this.params.thePlane = null;
            this.params.mapLattice = null;
            try {
                this.params.thePlane = (P4)Escape.uP(s);
                s = XmlReader.getXmlAttrib(data, "maplattice");
                Logger.info("JVXL read: plane " + this.params.thePlane);
                if (s.indexOf("{") >= 0) {
                    this.params.mapLattice = (P3)Escape.uP(s);
                    Logger.info("JVXL read: mapLattice " + this.params.mapLattice);
                }
                if (this.params.scale3d == 0.0f) {
                    this.params.scale3d = this.parseFloatStr(XmlReader.getXmlAttrib(data, "scale3d"));
                }
                if (Float.isNaN(this.params.scale3d)) {
                    this.params.scale3d = 0.0f;
                }
            }
            catch (Exception e) {
                if (this.params.thePlane == null) {
                    Logger.error("JVXL Error reading plane definition -- setting to 0 0 1 0  (z=0)");
                    this.params.thePlane = P4.new4(0.0f, 0.0f, 1.0f, 0.0f);
                }
                Logger.error("JVXL Error reading mapLattice definition -- ignored");
            }
            this.surfaceDataCount = 0;
            this.edgeDataCount = 0;
        } else {
            this.params.thePlane = null;
            this.surfaceDataCount = this.parseIntStr(XmlReader.getXmlAttrib(data, "nSurfaceInts"));
            this.edgeDataCount = this.parseIntStr(XmlReader.getXmlAttrib(data, "nBytesUncompressedEdgeData"));
            s = XmlReader.getXmlAttrib(data, "fixedLattice");
            if (s.indexOf("{") >= 0) {
                this.jvxlData.fixedLattice = (P3)Escape.uP(s);
            }
        }
        this.excludedVertexCount = this.parseIntStr(XmlReader.getXmlAttrib(data, "nExcludedVertexes"));
        this.excludedTriangleCount = this.parseIntStr(XmlReader.getXmlAttrib(data, "nExcludedTriangles"));
        this.invalidatedVertexCount = this.parseIntStr(XmlReader.getXmlAttrib(data, "nInvalidatedVertexes"));
        s = XmlReader.getXmlAttrib(data, "slabInfo");
        if (s.length() > 0) {
            this.jvxlData.slabInfo = s;
        }
        this.colorDataCount = Math.max(0, this.parseIntStr(XmlReader.getXmlAttrib(data, "nBytesUncompressedColorData")));
        this.jvxlDataIs2dContour = this.params.thePlane != null && this.jvxlDataIsColorMapped;
        this.jvxlData.color = XmlReader.getXmlAttrib(data, "color");
        if (this.jvxlData.color.length() == 0 || this.jvxlData.color.indexOf("null") >= 0) {
            this.jvxlData.color = "orange";
        }
        this.jvxlData.translucency = this.parseFloatStr(XmlReader.getXmlAttrib(data, "translucency"));
        if (Float.isNaN(this.jvxlData.translucency)) {
            this.jvxlData.translucency = 0.0f;
        }
        if ((s = XmlReader.getXmlAttrib(data, "meshColor")).length() > 0) {
            this.jvxlData.meshColor = s;
        }
        if ((s = XmlReader.getXmlAttrib(data, "rendering")).length() > 0) {
            this.jvxlData.rendering = s;
        }
        this.jvxlData.colorScheme = XmlReader.getXmlAttrib(data, "colorScheme");
        if (this.jvxlData.colorScheme.length() == 0) {
            String string = this.jvxlData.colorScheme = this.jvxlDataIsColorMapped ? "roygb" : null;
        }
        if (this.jvxlData.thisSet == null) {
            String[] sets;
            String a;
            int n = this.parseIntStr(XmlReader.getXmlAttrib(data, "set"));
            if (n > 0) {
                this.jvxlData.thisSet = new BS();
                this.jvxlData.thisSet.set(n - 1);
            }
            if ((a = XmlReader.getXmlAttrib(data, "subset")) != null && a.length() > 2 && (sets = a.replace('[', ' ').replace(']', ' ').trim().split(" ")).length > 0) {
                this.jvxlData.thisSet = new BS();
                int i = sets.length;
                while (--i >= 0) {
                    this.jvxlData.thisSet.set(PT.parseInt(sets[i]) - 1);
                }
            }
        }
        this.jvxlData.slabValue = this.parseIntStr(XmlReader.getXmlAttrib(data, "slabValue"));
        this.jvxlData.isSlabbable = XmlReader.getXmlAttrib(data, "slabbable").equalsIgnoreCase("true");
        this.jvxlData.diameter = this.parseIntStr(XmlReader.getXmlAttrib(data, "diameter"));
        if (this.jvxlData.diameter == Integer.MIN_VALUE) {
            this.jvxlData.diameter = 0;
        }
        if (this.jvxlDataIs2dContour) {
            this.params.isContoured = true;
        }
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        boolean insideOut = XmlReader.getXmlAttrib(data, "insideOut").equals("true");
        float dataMin = Float.NaN;
        float dataMax = Float.NaN;
        float red = Float.NaN;
        float blue = Float.NaN;
        if (this.jvxlDataIsColorMapped) {
            dataMin = this.parseFloatStr(XmlReader.getXmlAttrib(data, "dataMinimum"));
            dataMax = this.parseFloatStr(XmlReader.getXmlAttrib(data, "dataMaximum"));
            red = this.parseFloatStr(XmlReader.getXmlAttrib(data, "valueMappedToRed"));
            blue = this.parseFloatStr(XmlReader.getXmlAttrib(data, "valueMappedToBlue"));
            if (Float.isNaN(dataMin)) {
                red = -1.0f;
                dataMin = -1.0f;
                blue = 1.0f;
                dataMax = 1.0f;
            }
        }
        this.jvxlSetColorRanges(dataMin, dataMax, red, blue, insideOut);
    }

    protected void jvxlSetColorRanges(float dataMin, float dataMax, float red, float blue, boolean insideOut) {
        if (this.jvxlDataIsColorMapped) {
            if (!Float.isNaN(dataMin) && !Float.isNaN(dataMax)) {
                if (dataMax == 0.0f && dataMin == 0.0f) {
                    dataMin = -1.0f;
                    dataMax = 1.0f;
                }
                this.params.mappedDataMin = dataMin;
                this.params.mappedDataMax = dataMax;
                Logger.info("JVXL read: data_min/max " + this.params.mappedDataMin + "/" + this.params.mappedDataMax);
            }
            if (!this.params.rangeDefined) {
                if (!Float.isNaN(red) && !Float.isNaN(blue)) {
                    if (red == 0.0f && blue == 0.0f) {
                        red = -1.0f;
                        blue = 1.0f;
                    }
                    this.params.valueMappedToRed = Math.min(red, blue);
                    this.params.valueMappedToBlue = Math.max(red, blue);
                    this.params.isColorReversed = red > blue;
                    this.params.rangeDefined = true;
                } else {
                    this.params.valueMappedToRed = 0.0f;
                    this.params.valueMappedToBlue = 1.0f;
                    this.params.rangeDefined = true;
                }
            }
            Logger.info("JVXL read: color red/blue: " + this.params.valueMappedToRed + "/" + this.params.valueMappedToBlue);
        }
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.isColorReversed = this.params.isColorReversed;
        if (this.params.insideOut) {
            insideOut = !insideOut;
        }
        this.params.insideOut = this.jvxlData.insideOut = insideOut;
    }

    @Override
    protected void readSurfaceData(boolean isMapDataIgnored) throws Exception {
        boolean bl = this.thisInside = !this.params.isContoured;
        if (this.readSurfaceDataXML()) {
            return;
        }
        this.tempDataXml = this.xr.getXmlData("jvxlEdgeData", null, true, false);
        this.bsVoxelBitSet = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlEdgeData", this.tempDataXml, false, false));
        this.readSurfaceDataJXR();
    }

    protected boolean readSurfaceDataXML() throws Exception {
        if (this.vertexDataOnly) {
            this.getEncodedVertexData();
            return true;
        }
        if (this.params.thePlane != null) {
            this.volumeData.setDataDistanceToPlane(this.params.thePlane);
            this.setVolumeDataV(this.volumeData);
            this.params.cutoff = 0.0f;
            this.jvxlData.setSurfaceInfo(this.params.thePlane, this.params.mapLattice, 0, "");
            this.jvxlData.scale3d = this.params.scale3d;
            return true;
        }
        return false;
    }

    protected void readSurfaceDataJXR() throws Exception {
        this.readSurfaceDataVFR(false);
        this.volumeData.setMappingPlane(null);
    }

    protected String jvxlReadFractionData(String type, int nPoints) {
        String str;
        try {
            if (type.equals("edge")) {
                str = JvxlCoder.jvxlDecompressString(XmlReader.getXmlAttrib(this.tempDataXml, "data"));
            } else {
                String data = this.xr.getXmlData("jvxlColorData", null, true, false);
                this.jvxlData.isJvxlPrecisionColor = JvxlXmlReader.getEncoding(data).endsWith("2");
                str = JvxlCoder.jvxlDecompressString(XmlReader.getXmlAttrib(data, "data"));
            }
        }
        catch (Exception e) {
            Logger.error("Error reading " + type + " data " + e);
            throw new NullPointerException();
        }
        return str;
    }

    @Override
    protected BS getVoxelBitSet(int nPoints) throws Exception {
        if (this.bsVoxelBitSet != null) {
            return this.bsVoxelBitSet;
        }
        BS bs = new BS();
        if (this.surfaceDataCount <= 0) {
            return bs;
        }
        int nThisValue = 0;
        for (int bsVoxelPtr = 0; bsVoxelPtr < nPoints; bsVoxelPtr += nThisValue) {
            nThisValue = this.parseInt();
            if (nThisValue == Integer.MIN_VALUE) {
                this.rd();
                if (this.line == null || (nThisValue = this.parseIntStr(this.line)) == Integer.MIN_VALUE) {
                    if (!this.endOfData) {
                        Logger.error("end of file in JvxlReader? line=" + this.line);
                    }
                    this.endOfData = true;
                    nThisValue = 10000;
                }
            }
            this.thisInside = !this.thisInside;
            ++this.jvxlNSurfaceInts;
            if (!this.thisInside) continue;
            bs.setBits(bsVoxelPtr, bsVoxelPtr + nThisValue);
        }
        return bs;
    }

    @Override
    protected float getSurfacePointAndFraction(float cutoff, boolean isCutoffAbsolute, float valueA, float valueB, T3 pointA, V3 edgeVector, int x, int y, int z, int vA, int vB, float[] fReturn, T3 ptReturn) {
        if (this.edgeDataCount <= 0) {
            return this.getSPFv(cutoff, isCutoffAbsolute, valueA, valueB, pointA, edgeVector, x, y, z, vA, vB, fReturn, ptReturn);
        }
        fReturn[0] = this.jvxlGetNextFraction(this.edgeFractionBase, this.edgeFractionRange, 0.5f);
        ptReturn.scaleAdd2(fReturn[0], edgeVector, pointA);
        if (Float.isNaN(this.valueMin)) {
            this.setValueMinMax();
        }
        return this.valueCount == 0 || this.includeValueNaN && Float.isNaN(fReturn[0]) ? fReturn[0] : this.getNextValue();
    }

    private float getNextValue() {
        float fraction = Float.NaN;
        if (this.colorPtr < this.valueCount && Float.isNaN(fraction)) {
            fraction = this.jvxlData.isJvxlPrecisionColor ? JvxlCoder.jvxlFractionFromCharacter2(this.jvxlColorDataRead.charAt(this.colorPtr), this.jvxlColorDataRead.charAt(this.colorPtr++ + this.valueCount), this.colorFractionBase, this.colorFractionRange) : JvxlCoder.jvxlFractionFromCharacter(this.jvxlColorDataRead.charAt(this.colorPtr++), this.colorFractionBase, this.colorFractionRange, 0.5f);
        }
        return this.valueMin + fraction * this.valueRange;
    }

    private void setValueMinMax() {
        this.valueCount = this.jvxlColorDataRead.length();
        if (this.jvxlData.isJvxlPrecisionColor) {
            this.valueCount /= 2;
        }
        boolean bl = this.includeValueNaN = this.valueCount != this.jvxlEdgeDataRead.length();
        float f = !this.jvxlData.isJvxlPrecisionColor ? this.params.valueMappedToRed : (this.valueMin = this.params.mappedDataMin == Float.MAX_VALUE ? 0.0f : this.params.mappedDataMin);
        this.valueRange = (!this.jvxlData.isJvxlPrecisionColor ? this.params.valueMappedToBlue : (this.params.mappedDataMin == Float.MAX_VALUE ? 1.0f : this.params.mappedDataMax)) - this.valueMin;
        this.haveReadColorData = true;
    }

    private float jvxlGetNextFraction(int base, int range, float fracOffset) {
        if (this.fractionPtr >= this.strFractionTemp.length()) {
            if (!this.endOfData) {
                Logger.error("end of file reading compressed fraction data");
            }
            this.endOfData = true;
            this.strFractionTemp = "" + (char)base;
            this.fractionPtr = 0;
        }
        return JvxlCoder.jvxlFractionFromCharacter(this.strFractionTemp.charAt(this.fractionPtr++), base, range, fracOffset);
    }

    @Override
    protected String readColorData() {
        if (!this.jvxlDataIsColorMapped) {
            return "";
        }
        int vertexCount = this.jvxlData.vertexCount = this.meshData.vc;
        short[] colixes = this.meshData.vcs;
        float[] vertexValues = this.meshData.vvs;
        if ("none".equals(this.jvxlColorEncodingRead)) {
            this.jvxlData.vertexColors = new int[vertexCount];
            int[] nextc = new int[1];
            int n = PT.parseIntNext(this.jvxlColorDataRead, nextc);
            n = Math.min(n, vertexCount);
            String[] tokens = PT.getTokens(this.jvxlColorDataRead.substring(nextc[0]));
            boolean haveTranslucent = false;
            float trans = this.jvxlData.translucency;
            int lastColor = 0;
            for (int i = 0; i < n; ++i) {
                try {
                    int c = JvxlXmlReader.getColor(tokens[i]);
                    if (c == 0) {
                        c = lastColor;
                    } else {
                        lastColor = c;
                    }
                    this.jvxlData.vertexColors[i] = c;
                    colixes[i] = C.getColixTranslucent(this.jvxlData.vertexColors[i]);
                    if (C.isColixTranslucent(colixes[i])) {
                        haveTranslucent = true;
                        continue;
                    }
                    if (trans == 0.0f) continue;
                    colixes[i] = C.getColixTranslucent3(colixes[i], true, trans);
                    continue;
                }
                catch (Exception e) {
                    Logger.info("JvxlXmlReader: Cannot interpret color code: " + tokens[i]);
                }
            }
            if (haveTranslucent && trans == 0.0f) {
                this.jvxlData.translucency = 0.5f;
            }
            return "-";
        }
        if (this.params.colorEncoder == null) {
            this.params.colorEncoder = new ColorEncoder(null, null);
        }
        this.params.colorEncoder.setColorScheme(null, false);
        this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
        Logger.info("JVXL reading color data mapped min/max: " + this.params.mappedDataMin + "/" + this.params.mappedDataMax + " for " + vertexCount + " vertices. using encoding keys " + this.colorFractionBase + " " + this.colorFractionRange);
        Logger.info("mapping red-->blue for " + this.params.valueMappedToRed + " to " + this.params.valueMappedToBlue + " colorPrecision:" + this.jvxlData.isJvxlPrecisionColor);
        boolean getValues = Float.isNaN(this.valueMin);
        if (getValues) {
            this.setValueMinMax();
        }
        float contourPlaneMinimumValue = Float.MAX_VALUE;
        float contourPlaneMaximumValue = -3.4028235E38f;
        if (colixes == null || colixes.length < vertexCount) {
            this.meshData.vcs = colixes = new short[vertexCount];
        }
        short colixNeg = 0;
        short colixPos = 0;
        if (this.params.colorBySign) {
            colixPos = C.getColix(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos);
            colixNeg = C.getColix(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg);
        }
        int vertexIncrement = this.meshData.vertexIncrement;
        boolean needContourMinMax = this.params.mappedDataMin == Float.MAX_VALUE;
        for (int i = 0; i < vertexCount; i += vertexIncrement) {
            float value = getValues ? (vertexValues[i] = this.getNextValue()) : vertexValues[i];
            if (!needContourMinMax) continue;
            if (value < contourPlaneMinimumValue) {
                contourPlaneMinimumValue = value;
            }
            if (!(value > contourPlaneMaximumValue)) continue;
            contourPlaneMaximumValue = value;
        }
        if (needContourMinMax) {
            this.params.mappedDataMin = contourPlaneMinimumValue;
            this.params.mappedDataMax = contourPlaneMaximumValue;
        }
        if (this.jvxlData.colorScheme != null) {
            boolean setContourValue = this.marchingSquares != null && this.params.isContoured;
            for (int i = 0; i < vertexCount; i += vertexIncrement) {
                float value = vertexValues[i];
                if (setContourValue) {
                    this.marchingSquares.setContourData(i, value);
                    continue;
                }
                short colix = !this.params.colorBySign ? this.params.colorEncoder.getColorIndex(value) : ((this.params.isColorReversed ? value > 0.0f : value <= 0.0f) ? colixNeg : colixPos);
                colixes[i] = C.getColixTranslucent3(colix, true, this.jvxlData.translucency);
            }
        }
        return this.jvxlColorDataRead + "\n";
    }

    private static int getColor(String c) {
        int n = 0;
        try {
            switch (c.charAt(0)) {
                case '[': {
                    n = CU.getArgbFromString(c);
                    break;
                }
                case '0': {
                    n = PT.parseIntRadix(c.substring(2), 16);
                    break;
                }
                default: {
                    n = PT.parseIntRadix(c, 10);
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    protected void getEncodedVertexData() throws Exception {
        String sdata = this.xr.getXmlData("jvxlSurfaceData", null, true, false);
        this.jvxlDecodeVertexData(this.xr.getXmlData("jvxlVertexData", sdata, true, false), false);
        String tData = this.xr.getXmlData("jvxlTriangleData", sdata, true, false);
        String edgeData = this.xr.getXmlData("jvxlTriangleEdgeData", sdata, true, false);
        String polygonColorData = this.xr.getXmlData("jvxlPolygonColorData", sdata, false, false);
        this.jvxlDecodeTriangleData(tData, edgeData, polygonColorData);
        String cData = this.xr.getXmlData("jvxlColorData", sdata, true, false);
        this.jvxlColorEncodingRead = JvxlXmlReader.getEncoding(cData);
        this.jvxlData.isJvxlPrecisionColor = this.jvxlColorEncodingRead.endsWith("2");
        cData = this.getData(cData, "jvxlColorData");
        this.jvxlColorDataRead = this.jvxlColorEncodingRead.equals("none") ? cData : JvxlCoder.jvxlDecompressString(cData);
        boolean bl = this.jvxlDataIsColorMapped = (this.params.colorRgb == Integer.MIN_VALUE || this.params.colorRgb == Integer.MAX_VALUE) && this.jvxlColorDataRead.length() > 0;
        if (this.haveContourData) {
            this.jvxlDecodeContourData(this.jvxlData, this.xr.getXmlData("jvxlContourData", null, false, false));
        }
    }

    private String getData(String sdata, String name) throws Exception {
        String data = XmlReader.getXmlAttrib(sdata, "data");
        if (data.length() == 0) {
            data = this.xr.getXmlData(name, sdata, false, false);
        }
        return data;
    }

    private static String getEncoding(String data) {
        if (XmlReader.getXmlAttrib(data, "len").length() > 0) {
            return "";
        }
        String s = XmlReader.getXmlAttrib(data, "encoding");
        return s.length() == 0 ? "none" : s;
    }

    public P3[] jvxlDecodeVertexData(String data, boolean asArray) throws Exception {
        int vertexCount = this.parseIntStr(XmlReader.getXmlAttrib(data, "count"));
        if (!asArray) {
            Logger.info("Reading " + vertexCount + " vertices");
        }
        int ptCount = vertexCount * 3;
        P3[] vertices = asArray ? new P3[vertexCount] : null;
        String vData = XmlReader.getXmlAttrib(data, "data");
        String encoding = JvxlXmlReader.getEncoding(data);
        if ("none".equals(encoding)) {
            float[] fdata;
            if (vData.length() == 0) {
                vData = this.xr.getXmlData("jvxlVertexData", data, false, false);
            }
            if ((fdata = PT.parseFloatArray(vData))[0] != (float)(vertexCount * 3)) {
                Logger.info("JvxlXmlReader: vertexData count=" + (int)fdata[0] + "; expected " + vertexCount * 3);
            }
            int pt = 1;
            for (int i = 0; i < vertexCount; ++i) {
                P3 p = P3.new3(fdata[pt++], fdata[pt++], fdata[pt++]);
                if (asArray) {
                    vertices[i] = p;
                    continue;
                }
                this.addVertexCopy(p, 0.0f, i, false);
            }
        } else {
            P3 min = this.xr.getXmlPoint(data, "min");
            P3 range = this.xr.getXmlPoint(data, "max");
            range.sub(min);
            int colorFractionBase = this.jvxlData.colorFractionBase;
            int colorFractionRange = this.jvxlData.colorFractionRange;
            String s = JvxlCoder.jvxlDecompressString(vData);
            if (s.length() == 0) {
                s = this.xr.getXmlData("jvxlVertexData", data, false, false);
            }
            int pt = -1;
            for (int i = 0; i < vertexCount; ++i) {
                P3 p = new P3();
                float fraction = JvxlCoder.jvxlFractionFromCharacter2(s.charAt(++pt), s.charAt(pt + ptCount), colorFractionBase, colorFractionRange);
                p.x = min.x + fraction * range.x;
                fraction = JvxlCoder.jvxlFractionFromCharacter2(s.charAt(++pt), s.charAt(pt + ptCount), colorFractionBase, colorFractionRange);
                p.y = min.y + fraction * range.y;
                fraction = JvxlCoder.jvxlFractionFromCharacter2(s.charAt(++pt), s.charAt(pt + ptCount), colorFractionBase, colorFractionRange);
                p.z = min.z + fraction * range.z;
                if (asArray) {
                    vertices[i] = p;
                    continue;
                }
                this.addVertexCopy(p, 0.0f, i, false);
            }
        }
        return vertices;
    }

    void jvxlDecodeTriangleData(String tdata, String edgeData, String colorData) throws Exception {
        boolean haveEdgeInfo;
        boolean haveEncoding;
        int nTriangles = this.parseIntStr(XmlReader.getXmlAttrib(tdata, "count"));
        if (nTriangles < 0) {
            return;
        }
        int[] nextc = new int[1];
        int nColors = colorData == null ? -1 : 1;
        int color = 0;
        Logger.info("Reading " + nTriangles + " triangles");
        String encoding = JvxlXmlReader.getEncoding(tdata);
        tdata = this.getData(tdata, "jvxlTriangleData");
        String edata = this.getData(edgeData, "jvxlTriangleEdgeData");
        int[] vertex = new int[3];
        int[] nextp = new int[1];
        int[] nexte = null;
        int edgeMask = 7;
        boolean bl = haveEncoding = !"none".equals(encoding);
        if (haveEncoding) {
            tdata = JvxlCoder.jvxlDecompressString(tdata);
            haveEdgeInfo = (edata = JvxlCoder.jvxlDecompressString(edata).trim()).length() == nTriangles;
        } else {
            int n = PT.parseIntNext(tdata, nextp);
            boolean bl2 = haveEdgeInfo = edata.length() > 0;
            if (haveEdgeInfo) {
                nexte = new int[1];
                PT.parseIntNext(edata, nexte);
            } else if (n > 0) {
                Logger.info("JvxlXmlReader: jvxlTriangleEdgeData count=" + n + "; expected " + nTriangles);
            }
        }
        int i = 0;
        int v = 0;
        int p = 0;
        int pt = -1;
        block5: while (i < nTriangles) {
            if (haveEncoding) {
                int diff;
                char ch = tdata.charAt(++pt);
                switch (ch) {
                    case '!': {
                        diff = 0;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '+': 
                    case ',': 
                    case '.': {
                        continue block5;
                    }
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        nextp[0] = pt;
                        diff = PT.parseIntNext(tdata, nextp);
                        pt = nextp[0] - 1;
                        break;
                    }
                    default: {
                        diff = ch - 92;
                    }
                }
                v += diff;
            } else {
                v = PT.parseIntNext(tdata, nextp) - 1;
            }
            vertex[p] = v;
            if (++p != 3) continue;
            p = 0;
            if (haveEdgeInfo) {
                int n = edgeMask = nexte == null ? edata.charAt(i) - 48 : PT.parseIntNext(edata, nexte);
                if (edgeMask < 0 || edgeMask > 7) {
                    edgeMask = 7;
                }
            }
            if (--nColors == 0) {
                nColors = PT.parseIntNext(colorData, nextc);
                int c = PT.parseIntNext(colorData, nextc);
                if (c == Integer.MIN_VALUE) {
                    nColors = 0;
                } else {
                    color = c | 0xFF000000;
                }
            }
            this.addTriangleCheck(vertex[0], vertex[1], vertex[2], edgeMask, color, false, color);
            ++i;
        }
    }

    protected void jvxlDecodeContourData(JvxlData jvxlData, String data) throws Exception {
        Lst<Lst<Object>> vs = new Lst<Lst<Object>>();
        SB values = new SB();
        SB colors = new SB();
        int pt = -1;
        jvxlData.vContours = null;
        if (data == null) {
            return;
        }
        while ((pt = data.indexOf("<jvxlContour", pt + 1)) >= 0) {
            Lst<Object> v = new Lst<Object>();
            String s = this.xr.getXmlData("jvxlContour", data.substring(pt), true, false);
            float value = this.parseFloatStr(XmlReader.getXmlAttrib(s, "value"));
            values.append(" ").appendF(value);
            int color = JvxlXmlReader.getColor(XmlReader.getXmlAttrib(s, "color"));
            short colix = C.getColix(color);
            colors.append(" ").append(Escape.escapeColor(color));
            String fData = JvxlCoder.jvxlDecompressString(XmlReader.getXmlAttrib(s, "data"));
            BS bs = JvxlCoder.jvxlDecodeBitSet(this.xr.getXmlData("jvxlContour", s, false, false));
            int n = bs.length();
            IsosurfaceMesh.setContourVector(v, n, bs, value, colix, color, SB.newS(fData));
            vs.addLast(v);
        }
        int n = vs.size();
        if (n > 0) {
            jvxlData.vContours = AU.createArrayOfArrayList(n);
            this.params.contourColixes = new short[n];
            jvxlData.contourColixes = this.params.contourColixes;
            this.params.contoursDiscrete = new float[n];
            jvxlData.contourValues = this.params.contoursDiscrete;
            for (int i = 0; i < n; ++i) {
                jvxlData.vContours[i] = (Lst)vs.get(i);
                jvxlData.contourValues[i] = ((Float)jvxlData.vContours[i].get(2)).floatValue();
                jvxlData.contourColixes[i] = ((short[])jvxlData.vContours[i].get(3))[0];
            }
            jvxlData.contourColors = C.getHexCodes(jvxlData.contourColixes);
            Logger.info("JVXL read: " + n + " discrete contours");
            Logger.info("JVXL read: contour values: " + values);
            Logger.info("JVXL read: contour colors: " + colors);
        }
    }

    @Override
    protected void postProcessVertices() {
        BS bsInvalid = this.params.bsExcluded[1];
        if (bsInvalid != null) {
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
            }
            this.meshData.invalidateVertices(bsInvalid);
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 4, null);
                this.meshData = new MeshData();
            }
            this.updateTriangles();
        }
    }
}

