/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.GenericMenuInterface;
import org.jmol.api.SC;
import org.jmol.popup.PopupHelper;
import org.jmol.popup.PopupResource;
import org.jmol.util.Logger;

public abstract class GenericPopup
implements GenericMenuInterface {
    public PopupHelper helper;
    protected String strMenuStructure;
    protected boolean allowSignedFeatures;
    protected boolean isJS;
    protected boolean isApplet;
    protected boolean isSigned;
    protected boolean isWebGL;
    public int thisx;
    public int thisy;
    protected boolean isTainted = true;
    protected String menuName;
    protected SC popupMenu;
    protected SC thisPopup;
    protected Map<String, SC> htCheckbox = new Hashtable<String, SC>();
    protected Object buttonGroup;
    protected String currentMenuItemId;
    protected Map<String, SC> htMenus = new Hashtable<String, SC>();
    private Lst<SC> SignedOnly = new Lst();
    protected boolean updatingForShow;

    protected abstract Object getImageIcon(String var1);

    protected abstract void menuShowPopup(SC var1, int var2, int var3);

    protected abstract String getUnknownCheckBoxScriptToRun(SC var1, String var2, String var3, boolean var4);

    protected void appCheckItem(String item, SC newMenu) {
    }

    public void appCheckSpecialMenu(String item, SC subMenu, String word) {
    }

    protected abstract String appFixLabel(String var1);

    protected abstract String getScriptForCallback(SC var1, String var2, String var3);

    protected abstract boolean appGetBooleanProperty(String var1);

    protected abstract boolean appRunSpecialCheckBox(SC var1, String var2, String var3, boolean var4);

    protected abstract void appRestorePopupMenu();

    protected abstract void appRunScript(String var1);

    protected abstract void appUpdateSpecialCheckBoxValue(SC var1, String var2, boolean var3);

    protected abstract void appUpdateForShow();

    protected void initSwing(String title, PopupResource bundle, Object applet, boolean isJS, boolean isSigned, boolean isWebGL) {
        this.isJS = isJS;
        this.isApplet = applet != null;
        this.isSigned = isSigned;
        this.isWebGL = isWebGL;
        this.allowSignedFeatures = !this.isApplet || isSigned;
        this.menuName = title;
        this.thisPopup = this.popupMenu = this.helper.menuCreatePopup(title, applet);
        this.htMenus.put(title, this.popupMenu);
        this.addMenuItems("", title, this.popupMenu, bundle);
    }

    public void addMenuItems(String parentId, String key, SC menu, PopupResource popupResourceBundle) {
        String item;
        String id = parentId + "." + key;
        String value = popupResourceBundle.getStructure(key);
        if (Logger.debugging) {
            Logger.debug(id + " --- " + value);
        }
        if (value == null) {
            this.menuCreateItem(menu, "#" + key, "", "");
            return;
        }
        StringTokenizer st = new StringTokenizer(value);
        while (value.indexOf("@") >= 0) {
            String s = "";
            while (st.hasMoreTokens()) {
                s = s + " " + ((item = st.nextToken()).startsWith("@") ? popupResourceBundle.getStructure(item) : item);
            }
            value = s.substring(1);
            st = new StringTokenizer(value);
        }
        while (st.hasMoreTokens()) {
            item = st.nextToken();
            if (!this.checkKey(item)) continue;
            if ("-".equals(item)) {
                this.menuAddSeparator(menu);
                this.helper.menuAddButtonGroup(null);
                continue;
            }
            if (",".equals(item)) {
                this.menuAddSeparator(menu);
                continue;
            }
            String label = popupResourceBundle.getWord(item);
            SC newItem = null;
            String script = "";
            boolean isCB = false;
            if ((label = this.appFixLabel(label == null ? item : label)).equals("null")) continue;
            if (item.indexOf("Menu") >= 0) {
                if (item.indexOf("more") < 0) {
                    this.helper.menuAddButtonGroup(null);
                }
                SC subMenu = this.menuNewSubMenu(label, id + "." + item);
                this.menuAddSubMenu(menu, subMenu);
                this.addMenu(id, item, subMenu, label, popupResourceBundle);
                newItem = subMenu;
            } else if (item.endsWith("Checkbox") || (isCB = item.endsWith("CB") || item.endsWith("RD"))) {
                boolean isRadio;
                script = popupResourceBundle.getStructure(item);
                String basename = item.substring(0, item.length() - (!isCB ? 8 : 2));
                boolean bl = isRadio = isCB && item.endsWith("RD");
                if (script == null || script.length() == 0 && !isRadio) {
                    script = "set " + basename + " T/F";
                }
                newItem = this.menuCreateCheckboxItem(menu, label, basename + ":" + script, id + "." + item, false, isRadio);
                this.rememberCheckbox(basename, newItem);
                if (isRadio) {
                    this.helper.menuAddButtonGroup(newItem);
                }
            } else {
                script = popupResourceBundle.getStructure(item);
                if (script == null) {
                    script = item;
                }
                newItem = this.menuCreateItem(menu, label, script, id + "." + item);
            }
            this.htMenus.put(item, newItem);
            if (item.startsWith("SIGNED")) {
                this.SignedOnly.addLast(newItem);
                if (!this.allowSignedFeatures) {
                    this.menuEnable(newItem, false);
                }
            }
            this.appCheckItem(item, newItem);
        }
    }

    protected void addMenu(String id, String item, SC subMenu, String label, PopupResource popupResourceBundle) {
        if (item.indexOf("Computed") < 0) {
            this.addMenuItems(id, item, subMenu, popupResourceBundle);
        }
        this.appCheckSpecialMenu(item, subMenu, label);
    }

    protected void updateSignedAppletItems() {
        int i = this.SignedOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.SignedOnly.get(i), this.allowSignedFeatures);
        }
    }

    private boolean checkKey(String key) {
        return key.indexOf(this.isApplet ? "JAVA" : "APPLET") < 0 && (!this.isWebGL || key.indexOf("NOGL") < 0);
    }

    private void rememberCheckbox(String key, SC checkboxMenuItem) {
        this.htCheckbox.put(key + "::" + this.htCheckbox.size(), checkboxMenuItem);
    }

    protected void updateButton(SC b, String entry, String script) {
        String[] ret = new String[]{entry};
        Object icon = this.getEntryIcon(ret);
        entry = ret[0];
        b.init(entry, icon, script, this.thisPopup);
        this.isTainted = true;
    }

    protected Object getEntryIcon(String[] ret) {
        String entry = ret[0];
        if (!entry.startsWith("<")) {
            return null;
        }
        int pt = entry.indexOf(">");
        ret[0] = entry.substring(pt + 1);
        String fileName = entry.substring(1, pt);
        return this.getImageIcon(fileName);
    }

    protected SC addMenuItem(SC menuItem, String entry) {
        return this.menuCreateItem(menuItem, entry, "", null);
    }

    protected void menuSetLabel(SC m, String entry) {
        if (m == null) {
            return;
        }
        m.setText(entry);
        this.isTainted = true;
    }

    public abstract void menuFocusCallback(String var1, String var2, boolean var3);

    public void menuClickCallback(SC source, String script) {
        this.doMenuClickCallback(source, script);
    }

    protected void doMenuClickCallback(SC source, String script) {
        this.appRestorePopupMenu();
        if (script == null || script.length() == 0) {
            return;
        }
        if (script.equals("MAIN")) {
            this.show(this.thisx, this.thisy, true);
            return;
        }
        String id = this.menuGetId(source);
        if (id != null) {
            script = this.getScriptForCallback(source, id, script);
            this.currentMenuItemId = id;
        }
        if (script != null) {
            this.appRunScript(script);
        }
    }

    public void menuCheckBoxCallback(SC source) {
        this.doMenuCheckBoxCallback(source);
    }

    protected void doMenuCheckBoxCallback(SC source) {
        this.appRestorePopupMenu();
        boolean isSelected = source.isSelected();
        String what = source.getActionCommand();
        this.runCheckBoxScript(source, what, isSelected);
        this.appUpdateSpecialCheckBoxValue(source, what, isSelected);
        this.isTainted = true;
        String id = this.menuGetId(source);
        if (id != null) {
            this.currentMenuItemId = id;
        }
    }

    private void runCheckBoxScript(SC item, String what, boolean TF) {
        if (!item.isEnabled()) {
            return;
        }
        if (what.indexOf("##") < 0) {
            int pt = what.indexOf(":");
            if (pt < 0) {
                Logger.error("check box " + item + " IS " + what);
                return;
            }
            String basename = what.substring(0, pt);
            if (this.appRunSpecialCheckBox(item, basename, what, TF)) {
                return;
            }
            if ((pt = (what = what.substring(pt + 1)).indexOf("|")) >= 0) {
                what = (TF ? what.substring(0, pt) : what.substring(pt + 1)).trim();
            }
            what = PT.rep(what, "T/F", TF ? " TRUE" : " FALSE");
        }
        this.appRunScript(what);
    }

    protected SC menuCreateItem(SC menu, String entry, String script, String id) {
        SC item = this.helper.getMenuItem(entry);
        item.addActionListener(this.helper);
        return this.newMenuItem(item, menu, entry, script, id);
    }

    protected SC menuCreateCheckboxItem(SC menu, String entry, String basename, String id, boolean state, boolean isRadio) {
        SC jmi = isRadio ? this.helper.getRadio(entry) : this.helper.getCheckBox(entry);
        jmi.setSelected(state);
        jmi.addItemListener(this.helper);
        return this.newMenuItem(jmi, menu, entry, basename, id);
    }

    protected void menuAddSeparator(SC menu) {
        menu.add(this.helper.getMenuItem(null));
        this.isTainted = true;
    }

    protected SC menuNewSubMenu(String entry, String id) {
        SC jm = this.helper.getMenu(entry);
        jm.addMouseListener(this.helper);
        this.updateButton(jm, entry, null);
        jm.setName(id);
        jm.setAutoscrolls(true);
        return jm;
    }

    protected void menuRemoveAll(SC menu, int indexFrom) {
        if (indexFrom <= 0) {
            menu.removeAll();
        } else {
            int i = menu.getComponentCount();
            while (--i >= indexFrom) {
                menu.remove(i);
            }
        }
        this.isTainted = true;
    }

    private SC newMenuItem(SC item, SC menu, String text, String script, String id) {
        this.updateButton(item, text, script);
        item.addMouseListener(this.helper);
        item.setName(id == null ? menu.getName() + "." : id);
        this.menuAddItem(menu, item);
        return item;
    }

    protected SC setText(String item, String text) {
        SC m = this.htMenus.get(item);
        if (m != null) {
            m.setText(text);
        }
        return m;
    }

    private void menuAddItem(SC menu, SC item) {
        menu.add(item);
        this.isTainted = true;
    }

    protected void menuAddSubMenu(SC menu, SC subMenu) {
        subMenu.addMouseListener(this.helper);
        this.menuAddItem(menu, subMenu);
    }

    protected void menuEnable(SC component, boolean enable) {
        if (component == null || component.isEnabled() == enable) {
            return;
        }
        component.setEnabled(enable);
    }

    protected String menuGetId(SC menu) {
        return menu.getName();
    }

    protected void menuSetAutoscrolls(SC menu) {
        menu.setAutoscrolls(true);
        this.isTainted = true;
    }

    protected int menuGetListPosition(SC item) {
        SC p = (SC)item.getParent();
        int i = p.getComponentCount();
        while (--i >= 0 && this.helper.getSwingComponent(p.getComponent(i)) != item) {
        }
        return i;
    }

    protected void show(int x, int y, boolean doPopup) {
        this.appUpdateForShow();
        this.updateCheckBoxesForShow();
        if (doPopup) {
            this.menuShowPopup(this.popupMenu, this.thisx, this.thisy);
        }
    }

    private void updateCheckBoxesForShow() {
        for (Map.Entry<String, SC> entry : this.htCheckbox.entrySet()) {
            String key = entry.getKey();
            SC item = entry.getValue();
            String basename = key.substring(0, key.indexOf(":"));
            boolean b = this.appGetBooleanProperty(basename);
            boolean updateShow = this.updatingForShow;
            this.updatingForShow = true;
            if (item.isSelected() != b) {
                item.setSelected(b);
                this.isTainted = true;
            }
            this.updatingForShow = updateShow;
        }
    }

    @Override
    public String jpiGetMenuAsString(String title) {
        this.appUpdateForShow();
        int pt = title.indexOf("|");
        if (pt >= 0) {
            String type = title.substring(pt);
            title = title.substring(0, pt);
            if (type.indexOf("current") >= 0) {
                SB sb = new SB();
                SC menu = this.htMenus.get(this.menuName);
                this.menuGetAsText(sb, 0, menu, "PopupMenu");
                return sb.toString();
            }
        }
        return this.appGetMenuAsString(title);
    }

    protected String appGetMenuAsString(String title) {
        return null;
    }

    private void menuGetAsText(SB sb, int level, SC menu, String menuName) {
        String name = menuName;
        Object[] subMenus = menu.getComponents();
        String flags = null;
        String script = null;
        String text = null;
        char key = 'S';
        for (int i = 0; i < subMenus.length; ++i) {
            SC source = this.helper.getSwingComponent(subMenus[i]);
            int type = this.helper.getItemType(source);
            switch (type) {
                case 4: {
                    key = 'M';
                    name = source.getName();
                    flags = "enabled:" + source.isEnabled();
                    text = source.getText();
                    script = null;
                    break;
                }
                case 0: {
                    key = 'S';
                    text = null;
                    script = null;
                    flags = null;
                    break;
                }
                default: {
                    key = 'I';
                    flags = "enabled:" + source.isEnabled();
                    if (type == 2 || type == 3) {
                        flags = flags + ";checked:" + source.isSelected();
                    }
                    script = this.getScriptForCallback(source, source.getName(), source.getActionCommand());
                    name = source.getName();
                    text = source.getText();
                }
            }
            GenericPopup.addItemText(sb, key, level, name, text, script, flags);
            if (type != 2) continue;
            this.menuGetAsText(sb, level + 1, this.helper.getSwingComponent(source.getPopupMenu()), name);
        }
    }

    private static void addItemText(SB sb, char type, int level, String name, String label, String script, String flags) {
        sb.appendC(type).appendI(level).appendC('\t').append(name);
        if (label == null) {
            sb.append(".\n");
            return;
        }
        sb.append("\t").append(label).append("\t").append(script == null || script.length() == 0 ? "-" : script).append("\t").append(flags).append("\n");
    }

    protected static int convertToMegabytes(long num) {
        if (num <= 0x7FFFFFFFFFF7FFFFL) {
            num += 524288L;
        }
        return (int)(num / 0x100000L);
    }

    @Override
    public void jpiDispose() {
        this.thisPopup = null;
        this.popupMenu = null;
        this.helper.dispose(this.popupMenu);
        this.helper = null;
    }
}

