/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public final class FeatureAdapter {
    private static ApiKeyAdapter apiKeyAdapter = new DefaultApiKeyAdapter();
    private static BrowserAdapter browserAdapter = new DefaultBrowserAdapter();
    private static ImageAdapter imageAdapter = new DefaultImageAdapter();
    private static TranslationAdapter translationAdapter = new DefaultTranslationAdapter();
    private static LoggingAdapter loggingAdapter = new DefaultLoggingAdapter();
    private static SettingsAdapter settingsAdapter = new DefaultSettingsAdapter();

    private FeatureAdapter() {
    }

    public static void registerApiKeyAdapter(ApiKeyAdapter apiKeyAdapter) {
        FeatureAdapter.apiKeyAdapter = Objects.requireNonNull(apiKeyAdapter);
    }

    public static void registerBrowserAdapter(BrowserAdapter browserAdapter) {
        FeatureAdapter.browserAdapter = Objects.requireNonNull(browserAdapter);
    }

    public static void registerImageAdapter(ImageAdapter imageAdapter) {
        FeatureAdapter.imageAdapter = Objects.requireNonNull(imageAdapter);
    }

    public static void registerTranslationAdapter(TranslationAdapter translationAdapter) {
        FeatureAdapter.translationAdapter = Objects.requireNonNull(translationAdapter);
    }

    public static void registerLoggingAdapter(LoggingAdapter loggingAdapter) {
        FeatureAdapter.loggingAdapter = Objects.requireNonNull(loggingAdapter);
    }

    public static void registerSettingsAdapter(SettingsAdapter settingsAdapter) {
        FeatureAdapter.settingsAdapter = Objects.requireNonNull(settingsAdapter);
    }

    public static String retrieveApiKey(String imageryId) throws IOException {
        return apiKeyAdapter.retrieveApiKey(imageryId);
    }

    public static void openLink(String url) {
        browserAdapter.openLink(url);
    }

    public static BufferedImage readImage(URL url) throws IOException {
        return imageAdapter.read(url, false, false);
    }

    public static BufferedImage readImage(URI url) throws IOException {
        return imageAdapter.read(url.toURL(), false, false);
    }

    public static String tr(String text, Object ... objects) {
        return translationAdapter.tr(text, objects);
    }

    public static Logger getLogger(String name) {
        return loggingAdapter.getLogger(name);
    }

    public static Logger getLogger(Class<?> klass) {
        return loggingAdapter.getLogger(klass.getSimpleName());
    }

    public static String getSetting(String key, String def) {
        return settingsAdapter.get(key, def);
    }

    public static int getIntSetting(String key, int def) {
        return Integer.parseInt(settingsAdapter.get(key, Integer.toString(def)));
    }

    public static boolean putSetting(String key, String value) {
        return settingsAdapter.put(key, value);
    }

    public static class DefaultSettingsAdapter
    implements SettingsAdapter {
        private final Map<String, String> settings = new TreeMap<String, String>();

        @Override
        public String get(String key, String def) {
            return this.settings.getOrDefault(key, def);
        }

        @Override
        public boolean put(String key, String value) {
            return !Objects.equals(value == null || value.isEmpty() ? this.settings.remove(key) : this.settings.put(key, value), value);
        }
    }

    public static class DefaultLoggingAdapter
    implements LoggingAdapter {
        @Override
        public Logger getLogger(String name) {
            return Logger.getLogger(name);
        }
    }

    public static class DefaultTranslationAdapter
    implements TranslationAdapter {
        @Override
        public String tr(String text, Object ... objects) {
            return MessageFormat.format(text, objects);
        }
    }

    public static class DefaultImageAdapter
    implements ImageAdapter {
        @Override
        public BufferedImage read(URL input, boolean readMetadata, boolean enforceTransparency) throws IOException {
            return ImageIO.read(input);
        }
    }

    public static class DefaultBrowserAdapter
    implements BrowserAdapter {
        @Override
        public void openLink(String url) {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (IOException | URISyntaxException e) {
                    FeatureAdapter.getLogger(FeatureAdapter.class).log(Level.SEVERE, e.getMessage(), e);
                }
            } else {
                FeatureAdapter.getLogger(FeatureAdapter.class).log(Level.SEVERE, FeatureAdapter.tr("Opening link not supported on current platform (''{0}'')", url));
            }
        }
    }

    public static class DefaultApiKeyAdapter
    implements ApiKeyAdapter {
        @Override
        public String retrieveApiKey(String imageryId) {
            return System.getProperty(imageryId + ".api-key");
        }
    }

    public static interface SettingsAdapter {
        public String get(String var1, String var2);

        public boolean put(String var1, String var2);
    }

    @FunctionalInterface
    public static interface ImageAdapter {
        public BufferedImage read(URL var1, boolean var2, boolean var3) throws IOException;
    }

    @FunctionalInterface
    public static interface LoggingAdapter {
        public Logger getLogger(String var1);
    }

    public static interface TranslationAdapter {
        public String tr(String var1, Object ... var2);
    }

    @FunctionalInterface
    public static interface BrowserAdapter {
        public void openLink(String var1);
    }

    @FunctionalInterface
    public static interface ApiKeyAdapter {
        public String retrieveApiKey(String var1) throws IOException;
    }
}

