/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public class DataIntegrityProblemException
extends RuntimeException {
    private final String htmlMessage;

    public DataIntegrityProblemException(String message) {
        this(message, null, new OsmPrimitive[0]);
    }

    public DataIntegrityProblemException(String message, String htmlMessage, OsmPrimitive ... p) {
        super(message + DataIntegrityProblemException.relevantCommands(p));
        this.htmlMessage = htmlMessage;
    }

    public String getHtmlMessage() {
        return this.htmlMessage;
    }

    private static String relevantCommands(OsmPrimitive ... p) {
        if (p == null || p.length == 0) {
            return "";
        }
        Predicate<Command> isParticipating = c -> Arrays.stream(p).anyMatch(c.getParticipatingPrimitives()::contains);
        Stream<String> undo = UndoRedoHandler.getInstance().getUndoCommands().stream().filter(isParticipating).map(c -> "[" + c.getDescriptionText() + "]");
        Stream<String> redo = UndoRedoHandler.getInstance().getRedoCommands().stream().filter(isParticipating).map(c -> "[" + c.getDescriptionText() + " (undone)]");
        return Stream.concat(undo, redo).collect(Collectors.joining(", ", " (changed by the following commands: ", ")"));
    }
}

