/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.osm.AbstractDataSourceChangeEvent;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class DataSourceRemovedEvent
extends AbstractDataSourceChangeEvent {
    private Set<DataSource> current;
    private final Set<DataSource> removed;
    private Set<DataSource> added;

    public DataSourceRemovedEvent(DataSet source, Set<DataSource> old, Stream<DataSource> removedDataSources) {
        super(source, old);
        CheckParameterUtil.ensureParameterNotNull(removedDataSources, "removedDataSources");
        this.removed = removedDataSources.collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public Set<DataSource> getDataSources() {
        if (this.current == null) {
            this.current = this.getOldDataSources().stream().filter(s -> !this.removed.contains(s)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.current;
    }

    @Override
    public synchronized Set<DataSource> getRemoved() {
        return this.removed;
    }

    @Override
    public synchronized Set<DataSource> getAdded() {
        if (this.added == null) {
            this.added = this.getDataSources().stream().filter(s -> !this.getOldDataSources().contains(s)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.added;
    }

    public String toString() {
        return "DataSourceAddedEvent [current=" + String.valueOf(this.current) + ", removed=" + String.valueOf(this.removed) + ", added=" + String.valueOf(this.added) + "]";
    }
}

