/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.tagging.ac;

import java.util.Objects;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;

public class AutoCompletionItem
implements Comparable<AutoCompletionItem> {
    private AutoCompletionPriority priority;
    private final String value;

    public AutoCompletionItem(String value, AutoCompletionPriority priority) {
        this.value = value;
        this.priority = priority;
    }

    public AutoCompletionItem(String value) {
        this.value = value;
        this.priority = AutoCompletionPriority.UNKNOWN;
    }

    public AutoCompletionItem() {
        this.value = "";
        this.priority = AutoCompletionPriority.UNKNOWN;
    }

    public AutoCompletionPriority getPriority() {
        return this.priority;
    }

    public void setPriority(AutoCompletionPriority priority) {
        this.priority = priority;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hash(this.priority, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AutoCompletionItem)) {
            return false;
        }
        AutoCompletionItem other = (AutoCompletionItem)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.priority == null ? other.priority == null : this.priority.equals(other.priority);
    }

    @Override
    public int compareTo(AutoCompletionItem other) {
        int ret = other.priority.compareTo(this.priority);
        return ret != 0 ? ret : this.value.compareTo(other.value);
    }
}

