/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.io.importexport.NoteImporter;
import org.openstreetmap.josm.gui.io.importexport.OsmImporter;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class AutosaveTask
extends TimerTask
implements LayerManager.LayerChangeListener,
DataSetListenerAdapter.Listener,
NoteData.NoteDataUpdateListener {
    private static final char[] ILLEGAL_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final String AUTOSAVE_DIR = "autosave";
    private static final String DELETED_LAYERS_DIR = "autosave/deleted_layers";
    public static final BooleanProperty PROP_AUTOSAVE_ENABLED = new BooleanProperty("autosave.enabled", true);
    public static final IntegerProperty PROP_FILES_PER_LAYER = new IntegerProperty("autosave.filesPerLayer", 1);
    public static final IntegerProperty PROP_DELETED_LAYERS = new IntegerProperty("autosave.deletedLayersBackupCount", 5);
    public static final IntegerProperty PROP_INTERVAL = new IntegerProperty("autosave.interval", (int)TimeUnit.MINUTES.toSeconds(5L));
    public static final IntegerProperty PROP_INDEX_LIMIT = new IntegerProperty("autosave.index-limit", 1000);
    public static final BooleanProperty PROP_NOTIFICATION = new BooleanProperty("autosave.notification", false);
    private final DataSetListenerAdapter datasetAdapter = new DataSetListenerAdapter(this);
    private final Set<Data> changedData = new HashSet<Data>();
    private final List<AutosaveLayerInfo<?>> layersInfo = new ArrayList();
    private final Object layersLock = new Object();
    private final Deque<File> deletedLayers = new LinkedList<File>();
    private final File autosaveDir = new File(Config.getDirs().getUserDataDirectory(true), "autosave");
    private final File deletedLayersDir = new File(Config.getDirs().getUserDataDirectory(true), "autosave/deleted_layers");

    public final Path getAutosaveDir() {
        return this.autosaveDir.toPath();
    }

    public void schedule() {
        if (PROP_INTERVAL.get() > 0) {
            if (!this.autosaveDir.exists() && !this.autosaveDir.mkdirs()) {
                Logging.warn(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.autosaveDir.getAbsolutePath()));
                return;
            }
            if (!this.deletedLayersDir.exists() && !this.deletedLayersDir.mkdirs()) {
                Logging.warn(I18n.tr("Unable to create directory {0}, autosave will be disabled", this.deletedLayersDir.getAbsolutePath()));
                return;
            }
            File[] files = this.deletedLayersDir.listFiles();
            if (files != null) {
                try {
                    Arrays.sort(files, Comparator.comparingLong(File::lastModified));
                }
                catch (Exception e) {
                    Logging.error(e);
                }
                this.deletedLayers.addAll(Arrays.asList(files));
            }
            new Timer(true).schedule((TimerTask)this, TimeUnit.SECONDS.toMillis(1L), TimeUnit.SECONDS.toMillis(PROP_INTERVAL.get().intValue()));
            MainApplication.getLayerManager().addAndFireLayerChangeListener(this);
        }
    }

    private static String getFileName(String layerName, int index) {
        Object result = layerName;
        for (char illegalCharacter : ILLEGAL_CHARACTERS) {
            result = ((String)result).replaceAll(Pattern.quote(String.valueOf(illegalCharacter)), "&" + String.valueOf((int)illegalCharacter) + ";");
        }
        if (index != 0) {
            result = (String)result + "_" + index;
        }
        return result;
    }

    private void setLayerFileName(AutosaveLayerInfo<?> layer) {
        int index = 0;
        while (true) {
            String filename = AutosaveTask.getFileName(((Layer)layer.layer).getName(), index);
            boolean foundTheSame = this.layersInfo.stream().anyMatch(info -> info != layer && filename.equals(info.layerFileName));
            if (!foundTheSame) {
                layer.layerFileName = filename;
                return;
            }
            ++index;
        }
    }

    protected File getNewLayerFile(AutosaveLayerInfo<?> layer, Instant now, int startIndex) {
        int index = startIndex;
        while (true) {
            String filename = String.format(Locale.ENGLISH, "%1$s_%2$tY%2$tm%2$td_%2$tH%2$tM%2$tS%2$tL%3$s", layer.layerFileName, Date.from(now), index == 0 ? "" : "_" + Integer.toString(index));
            File result = new File(this.autosaveDir, filename + "." + (layer.layer instanceof NoteLayer ? Config.getPref().get("autosave.notes.extension", "osn") : Config.getPref().get("autosave.extension", "osm")));
            try {
                if (index > PROP_INDEX_LIMIT.get()) {
                    throw new IOException("index limit exceeded");
                }
                if (result.createNewFile()) {
                    AutosaveTask.createNewPidFile(this.autosaveDir, filename);
                    return result;
                }
                Logging.warn(I18n.tr("Unable to create file {0}, other filename will be used", result.getAbsolutePath()));
            }
            catch (IOException e) {
                Logging.log(Logging.LEVEL_ERROR, I18n.tr("IOError while creating file, autosave will be skipped: {0}", e.getMessage()), e);
                return null;
            }
            ++index;
        }
    }

    private static void createNewPidFile(File autosaveDir, String filename) {
        File pidFile = new File(autosaveDir, filename + ".pid");
        try {
            String content = ManagementFactory.getRuntimeMXBean().getName();
            Files.write(pidFile.toPath(), Collections.singleton(content), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException | SecurityException t) {
            Logging.error(t);
        }
    }

    private void savelayer(AutosaveLayerInfo<?> info) {
        if (!((Layer)info.layer).getName().equals(info.layerName)) {
            this.setLayerFileName(info);
            info.layerName = ((Layer)info.layer).getName();
        }
        try {
            File file;
            Data data = ((AbstractModifiableLayer)info.layer).getData();
            if (data != null && this.changedData.remove(data) && (file = this.getNewLayerFile(info, Instant.now(), 0)) != null) {
                info.backupFiles.add(file);
                ((AbstractModifiableLayer)info.layer).autosave(file);
            }
        }
        catch (IOException e) {
            Logging.error(e);
        }
        while (info.backupFiles.size() > PROP_FILES_PER_LAYER.get()) {
            File oldFile = info.backupFiles.remove();
            if (!Utils.deleteFile(oldFile, I18n.marktr("Unable to delete old backup file {0}"))) continue;
            Utils.deleteFile(this.getPidFile(oldFile), I18n.marktr("Unable to delete old backup file {0}"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.layersLock;
        synchronized (object) {
            try {
                for (AutosaveLayerInfo<?> info : this.layersInfo) {
                    this.savelayer(info);
                }
                this.changedData.clear();
                if (PROP_NOTIFICATION.get().booleanValue() && !this.layersInfo.isEmpty()) {
                    GuiHelper.runInEDT(this::displayNotification);
                }
            }
            catch (RuntimeException t) {
                Logging.error("Autosave failed:");
                Logging.error(t);
            }
        }
    }

    protected void displayNotification() {
        new Notification(I18n.tr("Your work has been saved automatically.", new Object[0])).setIcon(ImageProvider.get("save")).setDuration(Notification.TIME_SHORT).show();
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewlayer(OsmDataLayer layer) {
        Object object = this.layersLock;
        synchronized (object) {
            layer.getDataSet().addDataSetListener(this.datasetAdapter);
            this.layersInfo.add(new AutosaveLayerInfo<OsmDataLayer>(layer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewlayer(NoteLayer layer) {
        Object object = this.layersLock;
        synchronized (object) {
            layer.getNoteData().addNoteDataUpdateListener(this);
            this.layersInfo.add(new AutosaveLayerInfo<NoteLayer>(layer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        Layer layer = e.getAddedLayer();
        if (layer.isSavable()) {
            if (layer instanceof OsmDataLayer) {
                this.registerNewlayer((OsmDataLayer)layer);
            } else if (layer instanceof NoteLayer) {
                this.registerNewlayer((NoteLayer)layer);
            } else if (layer instanceof AbstractModifiableLayer) {
                Object object = this.layersLock;
                synchronized (object) {
                    this.layersInfo.add(new AutosaveLayerInfo<AbstractModifiableLayer>((AbstractModifiableLayer)layer));
                }
            } else {
                Logging.debug("Unsupported savable layer type: {0}", layer.getClass().getSimpleName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof OsmDataLayer) {
            Object object = this.layersLock;
            synchronized (object) {
                OsmDataLayer osmLayer = (OsmDataLayer)e.getRemovedLayer();
                osmLayer.getDataSet().removeDataSetListener(this.datasetAdapter);
                this.cleanupLayer(osmLayer);
            }
        }
        if (e.getRemovedLayer() instanceof NoteLayer) {
            Object object = this.layersLock;
            synchronized (object) {
                NoteLayer noteLayer = (NoteLayer)e.getRemovedLayer();
                noteLayer.getNoteData().removeNoteDataUpdateListener(this);
                this.cleanupLayer(noteLayer);
            }
        }
        if (e.getRemovedLayer() instanceof AbstractModifiableLayer) {
            Object object = this.layersLock;
            synchronized (object) {
                this.cleanupLayer((AbstractModifiableLayer)e.getRemovedLayer());
            }
        }
    }

    private void cleanupLayer(AbstractModifiableLayer removedLayer) {
        Iterator<AutosaveLayerInfo<?>> it = this.layersInfo.iterator();
        while (it.hasNext()) {
            AutosaveLayerInfo<?> info = it.next();
            if (info.layer != removedLayer) continue;
            this.savelayer(info);
            File lastFile = info.backupFiles.pollLast();
            if (lastFile != null) {
                this.moveToDeletedLayersFolder(lastFile);
            }
            for (File file : info.backupFiles) {
                if (!Utils.deleteFile(file)) continue;
                Utils.deleteFile(this.getPidFile(file));
            }
            it.remove();
        }
    }

    @Override
    public void processDatasetEvent(AbstractDatasetChangedEvent event) {
        this.dataUpdated(event.getDataset());
    }

    @Override
    public void noteDataUpdated(NoteData data) {
        this.dataUpdated(data);
    }

    public boolean dataUpdated(Data data) {
        return this.changedData.add(data);
    }

    @Override
    public void selectedNoteChanged(NoteData noteData) {
    }

    protected File getPidFile(File osmFile) {
        return new File(this.autosaveDir, osmFile.getName().replaceFirst("[.][^.]+$", ".pid"));
    }

    public List<File> getUnsavedLayersFiles() {
        ArrayList<File> result = new ArrayList<File>();
        try {
            File[] files = this.autosaveDir.listFiles(pathname -> OsmImporter.FILE_FILTER.accept(pathname) || NoteImporter.FILE_FILTER.accept(pathname));
            if (files == null) {
                return result;
            }
            for (File file : files) {
                if (!file.isFile()) continue;
                boolean skipFile = false;
                File pidFile = this.getPidFile(file);
                if (pidFile.exists()) {
                    try (BufferedReader reader = Files.newBufferedReader(pidFile.toPath(), StandardCharsets.UTF_8);){
                        String jvmId = reader.readLine();
                        if (jvmId != null) {
                            String pid = jvmId.split("@", -1)[0];
                            skipFile = AutosaveTask.jvmPerfDataFileExists(pid);
                        }
                    }
                    catch (IOException | SecurityException t) {
                        Logging.error(t);
                    }
                }
                if (skipFile) continue;
                result.add(file);
            }
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to list unsaved layers files", e);
        }
        return result;
    }

    private static boolean jvmPerfDataFileExists(String jvmId) {
        File jvmDir = new File(Utils.getSystemProperty("java.io.tmpdir") + File.separator + "hsperfdata_" + Utils.getSystemProperty("user.name"));
        if (jvmDir.exists() && jvmDir.canRead()) {
            File[] files = jvmDir.listFiles(file -> file.getName().equals(jvmId) && file.isFile());
            return files != null && files.length == 1;
        }
        return false;
    }

    public Future<?> recoverUnsavedLayers() {
        List<File> files = this.getUnsavedLayersFiles();
        OpenFileAction.OpenFileTask openFileTsk = new OpenFileAction.OpenFileTask(files, null, I18n.tr("Restoring files", new Object[0]));
        Future<?> openFilesFuture = MainApplication.worker.submit(openFileTsk);
        return MainApplication.worker.submit(() -> {
            try {
                openFilesFuture.get();
                for (File f : openFileTsk.getSuccessfullyOpenedFiles()) {
                    this.moveToDeletedLayersFolder(f);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                Logging.error(e);
            }
        });
    }

    private void moveToDeletedLayersFolder(File f) {
        File next;
        File backupFile = new File(this.deletedLayersDir, f.getName());
        File pidFile = this.getPidFile(f);
        if (backupFile.exists()) {
            this.deletedLayers.remove(backupFile);
            Utils.deleteFile(backupFile, I18n.marktr("Unable to delete old backup file {0}"));
        }
        if (f.renameTo(backupFile)) {
            this.deletedLayers.add(backupFile);
            Utils.deleteFile(pidFile);
        } else {
            Logging.warn(String.format("Could not move autosaved file %s to %s folder", f.getName(), this.deletedLayersDir.getName()));
            if (Utils.deleteFile(f, I18n.marktr("Unable to delete backup file {0}"))) {
                Utils.deleteFile(pidFile, I18n.marktr("Unable to delete PID file {0}"));
            }
        }
        while (this.deletedLayers.size() > PROP_DELETED_LAYERS.get() && (next = this.deletedLayers.remove()) != null) {
            Utils.deleteFile(next, I18n.marktr("Unable to delete archived backup file {0}"));
        }
    }

    public void discardUnsavedLayers() {
        for (File f : this.getUnsavedLayersFiles()) {
            this.moveToDeletedLayersFolder(f);
        }
    }

    protected static final class AutosaveLayerInfo<T extends AbstractModifiableLayer> {
        private final T layer;
        private String layerName;
        private String layerFileName;
        private final Deque<File> backupFiles = new LinkedList<File>();

        AutosaveLayerInfo(T layer) {
            this.layer = layer;
        }
    }
}

