/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Map;
import org.openstreetmap.josm.gui.layer.imagery.ColorfulFilter;
import org.openstreetmap.josm.io.session.SessionAwareReadApply;
import org.openstreetmap.josm.tools.ImageProcessor;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ColorfulImageProcessor
implements ImageProcessor,
SessionAwareReadApply {
    private ColorfulFilter op;
    private double colorfulness = 1.0;

    public double getColorfulness() {
        return this.colorfulness;
    }

    public void setColorfulness(double colorfulness) {
        this.colorfulness = colorfulness < 0.0 ? 0.0 : colorfulness;
        this.op = this.colorfulness < 0.95 || this.colorfulness > 1.05 ? new ColorfulFilter(this.colorfulness) : null;
    }

    @Override
    public BufferedImage process(BufferedImage image) {
        if (this.op != null) {
            return this.op.filter(image, null);
        }
        return image;
    }

    @Override
    public void applyFromPropertiesMap(Map<String, String> properties) {
        String cStr = properties.get("colorfulness");
        if (cStr != null) {
            try {
                this.setColorfulness(Double.parseDouble(cStr));
            }
            catch (NumberFormatException e) {
                Logging.trace(e);
            }
        }
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        if (Utils.equalsEpsilon(this.colorfulness, 1.0)) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap("colorfulness", Double.toString(this.colorfulness));
    }

    public String toString() {
        return "ColorfulImageProcessor [colorfulness=" + this.colorfulness + "]";
    }
}

