/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JEditorPane;
import javax.swing.text.View;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;

public class JMultilineLabel
extends JEditorPane {
    private int maxWidth = Integer.MAX_VALUE;
    private Rectangle oldbounds;
    private Dimension oldPreferred;

    public JMultilineLabel(String text) {
        this(text, false);
    }

    public JMultilineLabel(String text, boolean allBold) {
        this(text, allBold, false);
    }

    public JMultilineLabel(String text, boolean allBold, boolean focusable) {
        JosmEditorPane.makeJLabelLike(this, allBold);
        Object html = text.trim().replaceAll("\n", "<br>");
        if (!((String)html).startsWith("<html>")) {
            html = "<html>" + (String)html + "</html>";
        }
        this.setFocusable(focusable);
        super.setText((String)html);
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.oldPreferred != null && this.getBounds().equals(this.oldbounds)) {
            return this.oldPreferred;
        }
        this.oldbounds = this.getBounds();
        Dimension superPreferred = super.getPreferredSize();
        int width = Math.min(superPreferred.width, this.maxWidth);
        View v = (View)super.getClientProperty("html");
        if (v == null) {
            return superPreferred;
        }
        v.setSize(width, 0.0f);
        int w = (int)Math.ceil(v.getPreferredSpan(0));
        int h = (int)Math.ceil(v.getPreferredSpan(1));
        this.oldPreferred = new Dimension(w, h);
        return this.oldPreferred;
    }
}

