/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class DecimalStyle {
    public static final DecimalStyle STANDARD = new DecimalStyle('0', '+', '-', '.');
    private static final ConcurrentMap<Locale, DecimalStyle> CACHE = new ConcurrentHashMap<Locale, DecimalStyle>(16, 0.75f, 2);
    private final char zeroDigit;
    private final char positiveSign;
    private final char negativeSign;
    private final char decimalSeparator;

    public static Set<Locale> getAvailableLocales() {
        Locale[] localeArray = DecimalFormatSymbols.getAvailableLocales();
        HashSet<Locale> hashSet = new HashSet<Locale>(localeArray.length);
        Collections.addAll(hashSet, localeArray);
        return hashSet;
    }

    public static DecimalStyle ofDefaultLocale() {
        return DecimalStyle.of(Locale.getDefault(Locale.Category.FORMAT));
    }

    public static DecimalStyle of(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        DecimalStyle decimalStyle = (DecimalStyle)CACHE.get(locale);
        if (decimalStyle == null) {
            decimalStyle = DecimalStyle.create(locale);
            CACHE.putIfAbsent(locale, decimalStyle);
            decimalStyle = (DecimalStyle)CACHE.get(locale);
        }
        return decimalStyle;
    }

    private static DecimalStyle create(Locale locale) {
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(locale);
        char c = decimalFormatSymbols.getZeroDigit();
        char c2 = '+';
        char c3 = decimalFormatSymbols.getMinusSign();
        char c4 = decimalFormatSymbols.getDecimalSeparator();
        if (c == '0' && c3 == '-' && c4 == '.') {
            return STANDARD;
        }
        return new DecimalStyle(c, c2, c3, c4);
    }

    private DecimalStyle(char c, char c2, char c3, char c4) {
        this.zeroDigit = c;
        this.positiveSign = c2;
        this.negativeSign = c3;
        this.decimalSeparator = c4;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public DecimalStyle withZeroDigit(char c) {
        if (c == this.zeroDigit) {
            return this;
        }
        return new DecimalStyle(c, this.positiveSign, this.negativeSign, this.decimalSeparator);
    }

    public char getPositiveSign() {
        return this.positiveSign;
    }

    public DecimalStyle withPositiveSign(char c) {
        if (c == this.positiveSign) {
            return this;
        }
        return new DecimalStyle(this.zeroDigit, c, this.negativeSign, this.decimalSeparator);
    }

    public char getNegativeSign() {
        return this.negativeSign;
    }

    public DecimalStyle withNegativeSign(char c) {
        if (c == this.negativeSign) {
            return this;
        }
        return new DecimalStyle(this.zeroDigit, this.positiveSign, c, this.decimalSeparator);
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public DecimalStyle withDecimalSeparator(char c) {
        if (c == this.decimalSeparator) {
            return this;
        }
        return new DecimalStyle(this.zeroDigit, this.positiveSign, this.negativeSign, c);
    }

    int convertToDigit(char c) {
        int n = c - this.zeroDigit;
        return n >= 0 && n <= 9 ? n : -1;
    }

    String convertNumberToI18N(String string) {
        if (this.zeroDigit == '0') {
            return string;
        }
        int n = this.zeroDigit - 48;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(cArray[i] + n);
        }
        return new String(cArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DecimalStyle) {
            DecimalStyle decimalStyle = (DecimalStyle)object;
            return this.zeroDigit == decimalStyle.zeroDigit && this.positiveSign == decimalStyle.positiveSign && this.negativeSign == decimalStyle.negativeSign && this.decimalSeparator == decimalStyle.decimalSeparator;
        }
        return false;
    }

    public int hashCode() {
        return this.zeroDigit + this.positiveSign + this.negativeSign + this.decimalSeparator;
    }

    public String toString() {
        return "DecimalStyle[" + this.zeroDigit + this.positiveSign + this.negativeSign + this.decimalSeparator + "]";
    }
}

