/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ConfigurableStore;
import org.apache.kafka.streams.state.StoreBuilder;

public interface StoreFactory
extends ConfigurableStore {
    public StoreBuilder<?> builder();

    public long retentionPeriod();

    public long historyRetention();

    public Set<String> connectedProcessorNames();

    public boolean loggingEnabled();

    public String storeName();

    public boolean isWindowStore();

    public boolean isVersionedStore();

    public Map<String, String> logConfig();

    public StoreFactory withCachingDisabled();

    public StoreFactory withLoggingDisabled();

    public boolean isCompatibleWith(StoreFactory var1);

    public static class FactoryWrappingStoreBuilder<T extends StateStore>
    implements StoreBuilder<T>,
    ConfigurableStore {
        private final StoreFactory storeFactory;

        public FactoryWrappingStoreBuilder(StoreFactory storeFactory) {
            this.storeFactory = storeFactory;
        }

        public StoreFactory storeFactory() {
            return this.storeFactory;
        }

        @Override
        public void configure(StreamsConfig config) {
            this.storeFactory.configure(config);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FactoryWrappingStoreBuilder that = (FactoryWrappingStoreBuilder)o;
            return this.storeFactory.isCompatibleWith(that.storeFactory);
        }

        public int hashCode() {
            return this.storeFactory.hashCode();
        }

        @Override
        public StoreBuilder<T> withCachingEnabled() {
            throw new IllegalStateException("Should not try to modify StoreBuilder wrapper");
        }

        @Override
        public StoreBuilder<T> withCachingDisabled() {
            this.storeFactory.withCachingDisabled();
            return this;
        }

        @Override
        public StoreBuilder<T> withLoggingEnabled(Map<String, String> config) {
            throw new IllegalStateException("Should not try to modify StoreBuilder wrapper");
        }

        @Override
        public StoreBuilder<T> withLoggingDisabled() {
            this.storeFactory.withLoggingDisabled();
            return this;
        }

        @Override
        public T build() {
            return (T)this.storeFactory.builder().build();
        }

        @Override
        public Map<String, String> logConfig() {
            return this.storeFactory.logConfig();
        }

        @Override
        public boolean loggingEnabled() {
            return this.storeFactory.loggingEnabled();
        }

        @Override
        public String name() {
            return this.storeFactory.storeName();
        }
    }
}

