/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream;
import com.dynatrace.hash4j.hashing.HashFunnel;
import com.dynatrace.hash4j.hashing.HashStream32;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.ToLongFunction;

interface AbstractHashStream32
extends AbstractHashStream,
HashStream32 {
    @Override
    default public int getHashBitSize() {
        return 32;
    }

    @Override
    default public HashStream32 putBoolean(boolean v) {
        AbstractHashStream.super.putBoolean(v);
        return this;
    }

    @Override
    default public HashStream32 putBooleans(boolean[] x) {
        AbstractHashStream.super.putBooleans(x);
        return this;
    }

    @Override
    default public HashStream32 putBooleans(boolean[] x, int off, int len) {
        AbstractHashStream.super.putBooleans(x, off, len);
        return this;
    }

    @Override
    default public HashStream32 putBooleanArray(boolean[] x) {
        AbstractHashStream.super.putBooleanArray(x);
        return this;
    }

    @Override
    default public HashStream32 putBytes(byte[] b) {
        AbstractHashStream.super.putBytes(b);
        return this;
    }

    @Override
    default public HashStream32 putBytes(byte[] b, int off, int len) {
        AbstractHashStream.super.putBytes(b, off, len);
        return this;
    }

    @Override
    default public HashStream32 putByteArray(byte[] x) {
        AbstractHashStream.super.putByteArray(x);
        return this;
    }

    @Override
    default public HashStream32 putChar(char v) {
        AbstractHashStream.super.putChar(v);
        return this;
    }

    @Override
    default public HashStream32 putChars(char[] x) {
        AbstractHashStream.super.putChars(x);
        return this;
    }

    @Override
    default public HashStream32 putChars(char[] x, int off, int len) {
        AbstractHashStream.super.putChars(x, off, len);
        return this;
    }

    @Override
    default public HashStream32 putChars(CharSequence s) {
        AbstractHashStream.super.putChars(s);
        return this;
    }

    @Override
    default public HashStream32 putCharArray(char[] x) {
        AbstractHashStream.super.putCharArray(x);
        return this;
    }

    @Override
    default public HashStream32 putString(String s) {
        AbstractHashStream.super.putString(s);
        return this;
    }

    @Override
    default public HashStream32 putShort(short v) {
        AbstractHashStream.super.putShort(v);
        return this;
    }

    @Override
    default public HashStream32 putShortArray(short[] x) {
        AbstractHashStream.super.putShortArray(x);
        return this;
    }

    @Override
    default public HashStream32 putShorts(short[] x) {
        AbstractHashStream.super.putShorts(x);
        return this;
    }

    @Override
    default public HashStream32 putShorts(short[] x, int off, int len) {
        AbstractHashStream.super.putShorts(x, off, len);
        return this;
    }

    @Override
    default public HashStream32 putInt(int v) {
        AbstractHashStream.super.putInt(v);
        return this;
    }

    @Override
    default public HashStream32 putIntArray(int[] x) {
        AbstractHashStream.super.putIntArray(x);
        return this;
    }

    @Override
    default public HashStream32 putInts(int[] x) {
        AbstractHashStream.super.putInts(x);
        return this;
    }

    @Override
    default public HashStream32 putInts(int[] x, int off, int len) {
        AbstractHashStream.super.putInts(x, off, len);
        return this;
    }

    @Override
    default public HashStream32 putLong(long v) {
        AbstractHashStream.super.putLong(v);
        return this;
    }

    @Override
    default public HashStream32 putLongArray(long[] x) {
        AbstractHashStream.super.putLongArray(x);
        return this;
    }

    @Override
    default public HashStream32 putLongs(long[] x) {
        AbstractHashStream.super.putLongs(x);
        return this;
    }

    @Override
    default public HashStream32 putLongs(long[] x, int off, int len) {
        AbstractHashStream.super.putLongs(x, off, len);
        return this;
    }

    @Override
    default public HashStream32 putFloat(float v) {
        AbstractHashStream.super.putFloat(v);
        return this;
    }

    @Override
    default public HashStream32 putFloats(float[] x) {
        AbstractHashStream.super.putFloats(x);
        return this;
    }

    @Override
    default public HashStream32 putFloats(float[] x, int off, int len) {
        AbstractHashStream.super.putFloats(x, off, len);
        return this;
    }

    @Override
    default public HashStream32 putFloatArray(float[] x) {
        AbstractHashStream.super.putFloatArray(x);
        return this;
    }

    @Override
    default public HashStream32 putDouble(double v) {
        AbstractHashStream.super.putDouble(v);
        return this;
    }

    @Override
    default public HashStream32 putDoubleArray(double[] x) {
        AbstractHashStream.super.putDoubleArray(x);
        return this;
    }

    @Override
    default public HashStream32 putDoubles(double[] x) {
        AbstractHashStream.super.putDoubles(x);
        return this;
    }

    @Override
    default public HashStream32 putDoubles(double[] x, int off, int len) {
        AbstractHashStream.super.putDoubles(x, off, len);
        return this;
    }

    @Override
    default public HashStream32 putUUID(UUID uuid) {
        AbstractHashStream.super.putUUID(uuid);
        return this;
    }

    @Override
    default public <T> HashStream32 put(T data, HashFunnel<T> funnel) {
        AbstractHashStream.super.put((Object)data, (HashFunnel)funnel);
        return this;
    }

    @Override
    default public <T> HashStream32 putNullable(T data, HashFunnel<T> funnel) {
        AbstractHashStream.super.putNullable((Object)data, (HashFunnel)funnel);
        return this;
    }

    @Override
    default public <T> HashStream32 putOrderedIterable(Iterable<T> data, HashFunnel<? super T> funnel) {
        AbstractHashStream.super.putOrderedIterable((Iterable)data, (HashFunnel)funnel);
        return this;
    }

    @Override
    default public <T> HashStream32 putUnorderedIterable(Iterable<T> data, HashFunnel<? super T> funnel, Hasher64 hasher) {
        AbstractHashStream.super.putUnorderedIterable((Iterable)data, (HashFunnel)funnel, hasher);
        return this;
    }

    @Override
    default public <T> HashStream32 putUnorderedIterable(Iterable<T> data, HashFunnel<? super T> funnel, HashStream64 hashStream) {
        AbstractHashStream.super.putUnorderedIterable((Iterable)data, (HashFunnel)funnel, hashStream);
        return this;
    }

    @Override
    default public <T> HashStream32 putUnorderedIterable(Iterable<T> data, ToLongFunction<? super T> elementHashFunction) {
        AbstractHashStream.super.putUnorderedIterable((Iterable)data, (ToLongFunction)elementHashFunction);
        return this;
    }

    @Override
    default public <T> HashStream32 putOptional(Optional<T> obj, HashFunnel<? super T> funnel) {
        AbstractHashStream.super.putOptional((Optional)obj, (HashFunnel)funnel);
        return this;
    }

    @Override
    default public HashStream32 putOptionalInt(OptionalInt v) {
        AbstractHashStream.super.putOptionalInt(v);
        return this;
    }

    @Override
    default public HashStream32 putOptionalLong(OptionalLong v) {
        AbstractHashStream.super.putOptionalLong(v);
        return this;
    }

    @Override
    default public HashStream32 putOptionalDouble(OptionalDouble v) {
        AbstractHashStream.super.putOptionalDouble(v);
        return this;
    }

    @Override
    default public <T> int resetAndHashToInt(T obj, HashFunnel<T> funnel) {
        funnel.put(obj, this.reset());
        return this.getAsInt();
    }
}

