/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import org.apache.kafka.common.utils.Time;

public class Throttle {
    private final int maxPerPeriod;
    private final int periodMs;
    private int count;
    private long prevPeriod;
    private long lastTimeMs;

    Throttle(int maxPerPeriod, int periodMs) {
        this.maxPerPeriod = maxPerPeriod;
        this.periodMs = periodMs;
        this.count = maxPerPeriod;
        this.prevPeriod = -1L;
        this.lastTimeMs = 0L;
    }

    public synchronized boolean increment() throws InterruptedException {
        boolean throttled = false;
        while (true) {
            if (this.count < this.maxPerPeriod) {
                ++this.count;
                return throttled;
            }
            this.lastTimeMs = this.time().milliseconds();
            long curPeriod = this.lastTimeMs / (long)this.periodMs;
            if (curPeriod <= this.prevPeriod) {
                long nextPeriodMs = (curPeriod + 1L) * (long)this.periodMs;
                this.delay(nextPeriodMs - this.lastTimeMs);
                throttled = true;
                continue;
            }
            this.prevPeriod = curPeriod;
            this.count = 0;
        }
    }

    public synchronized long lastTimeMs() {
        return this.lastTimeMs;
    }

    protected Time time() {
        return Time.SYSTEM;
    }

    protected synchronized void delay(long amount) throws InterruptedException {
        if (amount > 0L) {
            this.wait(amount);
        }
    }
}

